/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.compat.computers.generic.ComputerControlState;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.Lazy;
import org.apache.commons.lang3.mutable.MutableInt;

public abstract class MultiblockPartBlockEntity<T extends MultiblockPartBlockEntity<T>>
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IGeneralMultiblock,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IMirrorAble,
IModelOffsetProvider {
    public boolean formed = false;
    public BlockPos posInMultiblock = BlockPos.f_121853_;
    public BlockPos offsetToMaster = BlockPos.f_121853_;
    protected final IETemplateMultiblock multiblockInstance;
    public long onlyLocalDissassembly = -1L;
    protected final Lazy<Vec3i> structureDimensions;
    protected final boolean hasRedstoneControl;
    protected boolean redstoneControlInverted = false;
    public ComputerControlState computerControl = ComputerControlState.NO_COMPUTER;

    protected MultiblockPartBlockEntity(IETemplateMultiblock multiblockInstance, BlockEntityType<? extends T> type, boolean hasRSControl, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.multiblockInstance = multiblockInstance;
        this.structureDimensions = Lazy.of(() -> multiblockInstance.getSize(this.f_58857_));
        this.hasRedstoneControl = hasRSControl;
    }

    @Override
    @Nonnull
    public Direction getFacing() {
        return IEBlockInterfaces.IStateBasedDirectional.super.getFacing();
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.formed = nbt.m_128471_("formed");
        this.posInMultiblock = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("posInMultiblock"));
        this.offsetToMaster = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("offset"));
        this.redstoneControlInverted = nbt.m_128471_("redstoneControlInverted");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128379_("formed", this.formed);
        nbt.m_128365_("posInMultiblock", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos((Vec3i)this.posInMultiblock)));
        nbt.m_128365_("offset", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos((Vec3i)this.offsetToMaster)));
        nbt.m_128379_("redstoneControlInverted", this.redstoneControlInverted);
    }

    @Nullable
    public T master() {
        if (this.offsetToMaster.equals((Object)Vec3i.f_123288_)) {
            return (T)this;
        }
        if (this.tempMasterBE != null) {
            return (T)((MultiblockPartBlockEntity)this.tempMasterBE);
        }
        return this.getEntityForPos(this.multiblockInstance.getMasterFromOriginOffset());
    }

    public void updateMasterBlock(BlockState state, boolean blockUpdate) {
        IEBlockInterfaces.IGeneralMultiblock master = this.master();
        if (master != null) {
            ((IEBaseBlockEntity)((Object)master)).markChunkDirty();
            if (blockUpdate) {
                ((IEBaseBlockEntity)((Object)master)).markContainingBlockForUpdate(state);
            }
        }
    }

    @Override
    public boolean isDummy() {
        return !this.offsetToMaster.equals((Object)Vec3i.f_123288_);
    }

    public BlockState getOriginalBlock() {
        for (StructureTemplate.StructureBlockInfo block : this.multiblockInstance.getStructure(this.f_58857_)) {
            if (!block.f_74675_.equals((Object)this.posInMultiblock)) continue;
            return block.f_74676_;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void disassemble() {
        if (this.formed && !this.f_58857_.f_46443_) {
            this.tempMasterBE = this.master();
            BlockPos startPos = this.getOrigin();
            this.multiblockInstance.disassemble(this.f_58857_, startPos, this.getIsMirrored(), this.multiblockInstance.untransformDirection(this.getFacing()));
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
    }

    public BlockPos getOrigin() {
        return TemplateMultiblock.withSettingsAndOffset(this.f_58858_, BlockPos.f_121853_.m_141950_((Vec3i)this.posInMultiblock), this.getIsMirrored(), this.multiblockInstance.untransformDirection(this.getFacing()));
    }

    public BlockPos getBlockPosForPos(BlockPos targetPos) {
        BlockPos origin = this.getOrigin();
        return TemplateMultiblock.withSettingsAndOffset(origin, targetPos, this.getIsMirrored(), this.multiblockInstance.untransformDirection(this.getFacing()));
    }

    public void replaceStructureBlock(BlockPos pos, BlockState state, ItemStack stack, int h, int l, int w) {
        if (state.m_60734_() == this.m_58900_().m_60734_()) {
            this.getLevelNonnull().m_7471_(pos, false);
        }
        this.getLevelNonnull().m_46597_(pos, state);
        BlockEntity tile = this.getLevelNonnull().m_7702_(pos);
        if (tile instanceof IEBlockInterfaces.IReadOnPlacement) {
            IEBlockInterfaces.IReadOnPlacement readPlacement = (IEBlockInterfaces.IReadOnPlacement)tile;
            readPlacement.readOnPlacement(null, stack);
        }
    }

    public Set<BlockPos> getRedstonePos() {
        throw new UnsupportedOperationException("Tried to get RS position for a multiblock without RS control!");
    }

    public boolean isRedstonePos() {
        if (!this.hasRedstoneControl || this.getRedstonePos() == null) {
            return false;
        }
        for (BlockPos i : this.getRedstonePos()) {
            if (!this.posInMultiblock.equals((Object)i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.isRedstonePos() && this.hasRedstoneControl) {
            IEBlockInterfaces.IGeneralMultiblock master;
            if (!this.f_58857_.f_46443_ && (master = this.master()) != null) {
                ((MultiblockPartBlockEntity)master).redstoneControlInverted = !((MultiblockPartBlockEntity)master).redstoneControlInverted;
                ChatUtils.sendServerNoSpamMessages(player, new Component[]{new TranslatableComponent("chat.immersiveengineering.info.rsControl." + (((MultiblockPartBlockEntity)master).redstoneControlInverted ? "invertedOn" : "invertedOff"))});
                this.updateMasterBlock(null, true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean isRSDisabled() {
        Set<BlockPos> rsPositions = this.getRedstonePos();
        if (rsPositions == null || rsPositions.isEmpty()) {
            return false;
        }
        IEBlockInterfaces.IGeneralMultiblock master = this.master();
        if (master == null) {
            master = this;
        }
        if (((MultiblockPartBlockEntity)master).computerControl.isStillAttached()) {
            return !((MultiblockPartBlockEntity)master).computerControl.isEnabled();
        }
        ((MultiblockPartBlockEntity)master).computerControl = ComputerControlState.NO_COMPUTER;
        for (BlockPos rsPos : rsPositions) {
            boolean b;
            T tile = this.getEntityForPos(rsPos);
            if (tile == null || this.redstoneControlInverted == (b = ((IEBaseBlockEntity)tile).isRSPowered())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public T getEntityForPos(BlockPos targetPosInMB) {
        BlockPos target = this.getBlockPosForPos(targetPosInMB);
        BlockEntity tile = SafeChunkUtils.getSafeBE((LevelAccessor)this.getLevelNonnull(), target);
        if (this.getClass().isInstance(tile)) {
            return (T)((MultiblockPartBlockEntity)tile);
        }
        return null;
    }

    @Override
    @Nonnull
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        BlockPos mirroredPosInMB = this.posInMultiblock;
        if (size == null) {
            size = this.multiblockInstance.getSize(this.f_58857_);
        }
        if (this.getIsMirrored()) {
            mirroredPosInMB = new BlockPos(size.m_123341_() - mirroredPosInMB.m_123341_() - 1, mirroredPosInMB.m_123342_(), mirroredPosInMB.m_123343_());
        }
        return this.multiblockInstance.multiblockToModelPos(mirroredPosInMB);
    }

    public VoxelShape getShape(CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> cache) {
        return cache.get(this.posInMultiblock, (Pair<Direction, Boolean>)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    public static <T extends MultiblockPartBlockEntity<?>> void updateComparators(T tile, Collection<BlockPos> offsets, MutableInt cachedValue, int newValue) {
        if (newValue == cachedValue.intValue()) {
            return;
        }
        cachedValue.setValue(newValue);
        Level world = tile.getLevelNonnull();
        for (BlockPos offset : offsets) {
            BlockPos worldPos = tile.getBlockPosForPos(offset);
            BlockState stateAt = world.m_8055_(worldPos);
            world.m_46717_(worldPos, stateAt.m_60734_());
        }
    }
}

