/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.client.fx.CustomParticleManager;
import blusunrize.immersiveengineering.client.utils.DistField;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.mojang.math.Vector3f;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ChargingStationBlockEntity
extends IEBaseBlockEntity
implements IEClientTickableBE,
IEServerTickableBE,
IIEInventory,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IComparatorOverride,
IEBlockInterfaces.IPlayerInteraction {
    public AveragingEnergyStorage energyStorage = new AveragingEnergyStorage(32000);
    public NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    public final DistField<CustomParticleManager> particles = DistField.client(() -> CustomParticleManager::new);
    private boolean charging = true;
    public int comparatorOutput = 0;
    private final ResettableCapability<IEnergyStorage> energyCap = this.registerEnergyInput(this.energyStorage);
    private final ResettableCapability<IItemHandler> insertionHandler = this.registerCapability(new IEInventoryHandler(1, this));

    public ChargingStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.CHARGING_STATION.get(), pos, state);
    }

    @Override
    public void tickClient() {
        this.particles.get().clientTick();
        if (EnergyHelper.isFluxReceiver((ICapabilityProvider)this.inventory.get(0)) && this.charging) {
            float charge = 0.0f;
            float max = EnergyHelper.getMaxEnergyStored((ICapabilityProvider)this.inventory.get(0));
            if (max > 0.0f) {
                charge = (float)EnergyHelper.getEnergyStored((ICapabilityProvider)this.inventory.get(0)) / max;
            }
            for (int i = 0; i < 3; ++i) {
                long time = this.f_58857_.m_46467_();
                if (!(charge >= 1.0f) && (time % 12L < (long)(i * 4) || time % 12L > (long)(i * 4 + 2))) continue;
                int shift = i - 1;
                double x = 0.5 + (this.getFacing() == Direction.WEST ? -0.46875 : (this.getFacing() == Direction.EAST ? 0.46875 : (this.getFacing() == Direction.NORTH ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                double y = 0.25;
                double z = 0.5 + (this.getFacing() == Direction.NORTH ? -0.46875 : (this.getFacing() == Direction.SOUTH ? 0.46875 : (this.getFacing() == Direction.EAST ? -0.1875 * (double)shift : 0.1875 * (double)shift)));
                this.particles.get().add(new DustParticleOptions(new Vector3f(1.0f - charge, charge, 0.0f), 0.5f), x, y, z, 0.25, 0.25, 0.25, -1);
            }
        }
    }

    @Override
    public void tickServer() {
        if (EnergyHelper.isFluxReceiver((ICapabilityProvider)this.inventory.get(0))) {
            if (this.charging) {
                if (this.energyStorage.getEnergyStored() == 0) {
                    this.charging = false;
                    this.markContainingBlockForUpdate(null);
                    return;
                }
                int stored = EnergyHelper.getEnergyStored((ICapabilityProvider)this.inventory.get(0));
                int max = EnergyHelper.getMaxEnergyStored((ICapabilityProvider)this.inventory.get(0));
                int space = max - stored;
                if (space > 0) {
                    int energyDecNew;
                    int energyDec = 10 * stored / max;
                    int insert = Math.min(space, Math.max(this.energyStorage.getAverageInsertion(), (Integer)IEServerConfig.MACHINES.charger_consumption.get()));
                    int accepted = Math.min(EnergyHelper.insertFlux((ICapabilityProvider)this.inventory.get(0), insert, true), this.energyStorage.extractEnergy(insert, true));
                    if ((accepted = this.energyStorage.extractEnergy(accepted, false)) > 0) {
                        stored += EnergyHelper.insertFlux((ICapabilityProvider)this.inventory.get(0), accepted, false);
                    }
                    if (energyDec != (energyDecNew = 10 * stored / max)) {
                        this.markContainingBlockForUpdate(null);
                    }
                }
            } else if ((double)this.energyStorage.getEnergyStored() >= (double)this.energyStorage.getMaxEnergyStored() * 0.95) {
                this.charging = true;
                this.markContainingBlockForUpdate(null);
            }
        }
        if (this.f_58857_.m_46467_() % 32L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 0x1F)) {
            int i;
            float max;
            float charge = 0.0f;
            if (EnergyHelper.isFluxReceiver((ICapabilityProvider)this.inventory.get(0)) && (max = (float)EnergyHelper.getMaxEnergyStored((ICapabilityProvider)this.inventory.get(0))) > 0.0f) {
                charge = (float)EnergyHelper.getEnergyStored((ICapabilityProvider)this.inventory.get(0)) / max;
            }
            if ((i = (int)(15.0f * charge)) != this.comparatorOutput) {
                this.comparatorOutput = i;
                this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
            }
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        this.inventory.set(0, (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("inventory")));
        this.charging = nbt.m_128471_("charging");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.serializeTo(this.energyStorage, nbt);
        nbt.m_128379_("charging", this.charging);
        if (!((ItemStack)this.inventory.get(0)).m_41619_()) {
            nbt.m_128365_("inventory", (Tag)((ItemStack)this.inventory.get(0)).m_41739_(new CompoundTag()));
        }
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 0) {
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    @Override
    public int getComparatorInputOverride() {
        return this.comparatorOutput;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return Shapes.m_83048_((double)(this.getFacing().m_122434_() == Direction.Axis.X ? 0.0 : 0.125), (double)0.0, (double)(this.getFacing().m_122434_() == Direction.Axis.Z ? 0.0 : 0.125), (double)(this.getFacing().m_122434_() == Direction.Axis.X ? 1.0 : 0.875), (double)1.0, (double)(this.getFacing().m_122434_() == Direction.Axis.Z ? 1.0 : 0.875));
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return EnergyHelper.isFluxReceiver((ICapabilityProvider)stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY && (facing == null || facing == Direction.DOWN || facing == this.getFacing().m_122424_())) {
            return this.energyCap.cast();
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.insertionHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        if (this.isStackValid(0, heldItem)) {
            ItemStack stored = !((ItemStack)this.inventory.get(0)).m_41619_() ? ((ItemStack)this.inventory.get(0)).m_41777_() : ItemStack.f_41583_;
            this.inventory.set(0, (Object)heldItem.m_41777_());
            player.m_21008_(hand, stored);
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        if (!((ItemStack)this.inventory.get(0)).m_41619_()) {
            if (!this.f_58857_.f_46443_) {
                player.m_5552_(((ItemStack)this.inventory.get(0)).m_41777_(), 0.5f);
            }
            this.inventory.set(0, (Object)ItemStack.f_41583_);
            this.m_6596_();
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }
}

