/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.blocks.metal.BreakerSwitchBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RedstoneBreakerBlockEntity
extends BreakerSwitchBlockEntity
implements IEServerTickableBE {
    public RedstoneBreakerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends BreakerSwitchBlockEntity>)((BlockEntityType)IEBlockEntities.REDSTONE_BREAKER.get()), pos, state);
    }

    @Override
    public void tickServer() {
        boolean activeOld = this.getIsActive();
        if (this.isRSPowered() == activeOld) {
            this.setActive(!activeOld);
            this.updateConductivity();
        }
    }

    @Override
    protected boolean canTakeHV() {
        return true;
    }

    @Override
    protected boolean allowEnergyToPass() {
        return this.getIsActive() ^ this.inverted;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        Vec3 start = new Vec3(0.0, 0.125, 0.0);
        Vec3 end = new Vec3(1.0, 0.875, 1.0);
        Matrix4 mat = new Matrix4(this.getFacing());
        mat.translate(0.5, 0.5, 0.0).rotate(1.5707963267948966 * (double)this.rotation, 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0);
        start = mat.apply(start);
        end = mat.apply(end);
        return Shapes.m_83064_((AABB)new AABB(start, end));
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Matrix4 mat = new Matrix4(this.getFacing());
        mat.translate(0.5, 0.5, 0.0).rotate(1.5707963267948966 * (double)this.rotation, 0.0, 0.0, 1.0).translate(-0.5, -0.5, 0.0);
        boolean isLeft = here.getIndex() == 0;
        return mat.apply(isLeft ? new Vec3(0.125, 0.5, 1.0) : new Vec3(0.875, 0.5, 1.0));
    }

    @Override
    public int getWeakRSOutput(@Nonnull Direction side) {
        return 0;
    }

    @Override
    public int getStrongRSOutput(@Nonnull Direction side) {
        return 0;
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public boolean canConnectRedstone(@Nonnull Direction side) {
        return false;
    }
}

