/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.CoresampleItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class SampleDrillBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEClientTickableBE,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IPlayerInteraction,
IModelOffsetProvider {
    public MutableEnergyStorage energyStorage = new MutableEnergyStorage(8000);
    public int dummy = 0;
    public int process = 0;
    public boolean isRunning = false;
    @Nonnull
    public ItemStack sample = ItemStack.f_41583_;
    private final MultiblockCapability<IEnergyStorage> energyCap = MultiblockCapability.make(this, be -> be.energyCap, SampleDrillBlockEntity::master, this.registerEnergyInput(this.energyStorage));
    private AABB renderAABB;

    public SampleDrillBlockEntity(BlockEntityType<SampleDrillBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean canTickAny() {
        return this.sample.m_41619_();
    }

    @Override
    public void tickClient() {
        if (this.isRunning) {
            ++this.process;
        }
    }

    @Override
    public void tickServer() {
        boolean canRun;
        int consumption = (Integer)IEServerConfig.MACHINES.coredrill_consumption.get();
        int totalTime = (Integer)IEServerConfig.MACHINES.coredrill_time.get();
        boolean bl = canRun = this.process > 0 && this.process < totalTime && this.energyStorage.getEnergyStored() >= consumption && !this.isRSPowered() && !this.f_58857_.m_46859_(this.m_58899_().m_142082_(0, -1, 0));
        if (canRun && this.energyStorage.extractEnergy(consumption, false) == consumption) {
            ++this.process;
            if (this.process >= totalTime) {
                MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(this.f_58857_, this.m_58899_());
                this.sample = this.createCoreSample(info);
                this.process = 0;
                canRun = false;
                this.markContainingBlockForUpdate(null);
            }
            this.markChunkDirty();
        }
        if (canRun != this.isRunning) {
            this.isRunning = canRun;
            this.markChunkDirty();
            this.markContainingBlockForUpdate(null);
        }
    }

    public float getSampleProgress() {
        return (float)this.process / (float)((Integer)IEServerConfig.MACHINES.coredrill_time.get()).intValue();
    }

    public boolean isSamplingFinished() {
        return this.process >= (Integer)IEServerConfig.MACHINES.coredrill_time.get();
    }

    @Nullable
    public List<CoresampleItem.VeinSampleData> getVein() {
        if (this.sample.m_41619_()) {
            return null;
        }
        return CoresampleItem.getVeins(this.sample);
    }

    @Nonnull
    public ItemStack createCoreSample(@Nullable MineralWorldInfo info) {
        ItemStack stack = new ItemStack(IEItems.Misc.CORESAMPLE);
        ItemNBTHelper.putLong(stack, "timestamp", this.f_58857_.m_46467_());
        CoresampleItem.setDimension(stack, (ResourceKey<Level>)this.f_58857_.m_46472_());
        CoresampleItem.setCoords(stack, this.m_58899_());
        CoresampleItem.setMineralInfo(stack, info, this.m_58899_());
        return stack;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.serializeTo(this.energyStorage, nbt);
        nbt.m_128405_("dummy", this.dummy);
        nbt.m_128405_("process", this.process);
        nbt.m_128379_("isRunning", this.isRunning);
        if (!this.sample.m_41619_()) {
            nbt.m_128365_("sample", (Tag)this.sample.m_41739_(new CompoundTag()));
        }
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        EnergyHelper.deserializeFrom(this.energyStorage, nbt);
        this.dummy = nbt.m_128451_("dummy");
        this.process = nbt.m_128451_("process");
        this.isRunning = nbt.m_128471_("isRunning");
        this.sample = nbt.m_128425_("sample", 10) ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("sample")) : ItemStack.f_41583_;
    }

    public AABB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.dummy == 0 ? new AABB(this.m_58899_(), this.m_58899_().m_142082_(1, 3, 1)) : new AABB(this.m_58899_(), this.m_58899_());
        }
        return this.renderAABB;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (side == null || this.dummy == 0 && side.m_122434_().m_122479_())) {
            return this.energyCap.getAndCast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean isDummy() {
        return this.dummy > 0;
    }

    @Override
    @Nullable
    public SampleDrillBlockEntity master() {
        SampleDrillBlockEntity drill;
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.m_58899_().m_6625_(this.dummy);
        BlockEntity te = Utils.getExistingTileEntity(this.f_58857_, masterPos);
        return te instanceof SampleDrillBlockEntity ? (drill = (SampleDrillBlockEntity)te) : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        state = (BlockState)state.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true));
        for (int i = 1; i <= 2; ++i) {
            this.f_58857_.m_46597_(this.f_58858_.m_142082_(0, i, 0), state);
            ((SampleDrillBlockEntity)this.f_58857_.m_7702_((BlockPos)this.f_58858_.m_142082_((int)0, (int)i, (int)0))).dummy = i;
        }
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        for (int i = 0; i <= 2; ++i) {
            if (!(this.f_58857_.m_7702_(this.m_58899_().m_142082_(0, -this.dummy, 0).m_142082_(0, i, 0)) instanceof SampleDrillBlockEntity)) continue;
            this.f_58857_.m_7471_(this.m_58899_().m_142082_(0, -this.dummy, 0).m_142082_(0, i, 0), false);
        }
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        BlockEntity te;
        if (this.dummy != 0 && (te = this.f_58857_.m_7702_(this.m_58899_().m_142082_(0, -this.dummy, 0))) instanceof SampleDrillBlockEntity) {
            return ((SampleDrillBlockEntity)te).interact(side, player, hand, heldItem, hitX, hitY, hitZ);
        }
        if (!this.sample.m_41619_()) {
            if (!this.f_58857_.f_46443_) {
                player.m_5552_(this.sample.m_41777_(), 0.5f);
                this.sample = ItemStack.f_41583_;
                this.m_6596_();
                this.markContainingBlockForUpdate(null);
            }
            return true;
        }
        if (this.process <= 0) {
            if (!this.f_58857_.f_46443_ && this.energyStorage.getEnergyStored() >= (Integer)IEServerConfig.MACHINES.coredrill_consumption.get()) {
                this.process = 1;
                this.m_6596_();
                this.markContainingBlockForUpdate(null);
            }
            return true;
        }
        return false;
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        return new BlockPos(0, this.dummy, 0);
    }
}

