/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.SawmillRecipe;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.utils.shapes.CachedShapesWithTransform;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.generic.PoweredMultiblockBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IEMultiblocks;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.ticking.IEClientTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.MultiblockCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.orientation.RelativeBlockFace;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class SawmillBlockEntity
extends PoweredMultiblockBlockEntity<SawmillBlockEntity, MultiblockRecipe>
implements ConveyorHandler.IConveyorAttachable,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IPlayerInteraction,
IEClientTickableBE {
    public float animation_bladeRotation = 0.0f;
    public ItemStack sawblade = ItemStack.f_41583_;
    public List<SawmillProcess> sawmillProcessQueue = new ArrayList<SawmillProcess>();
    private int combinedLogs = 0;
    private final CapabilityReference<IItemHandler> outputCap = CapabilityReference.forBlockEntityAt(this, () -> {
        Direction outDir = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
        return new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(4, 1, 1)).m_142300_(outDir), outDir.m_122424_());
    }, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private final CapabilityReference<IItemHandler> secondaryOutputCap = CapabilityReference.forBlockEntityAt(this, this::getSecondaryOutputCapPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    private static final CachedShapesWithTransform<BlockPos, Pair<Direction, Boolean>> SHAPES = CachedShapesWithTransform.createForMultiblock(SawmillBlockEntity::getShape);
    private static final AABB SAWBLADE_AABB = new AABB(2.6875, 1.0, 1.375, 4.3125, 2.0, 1.625);
    private static final Function<SawmillBlockEntity, AABB> CACHED_SAWBLADE_AABB = new Function<SawmillBlockEntity, AABB>(){
        final Map<Pair<Direction, Boolean>, AABB> cache = new ConcurrentHashMap<Pair<Direction, Boolean>, AABB>();

        @Override
        public AABB apply(SawmillBlockEntity tile) {
            return this.cache.computeIfAbsent((Pair<Direction, Boolean>)Pair.of((Object)tile.getFacing(), (Object)tile.getIsMirrored()), key -> CachedShapesWithTransform.withFacingAndMirror(SAWBLADE_AABB, (Direction)key.getFirst(), (Boolean)key.getSecond())).m_82338_(tile.getOrigin());
        }
    };
    final MultiblockCapability<IItemHandler> insertionHandler = MultiblockCapability.make(this, be -> be.insertionHandler, MultiblockPartBlockEntity::master, this.registerCapability(new PoweredMultiblockBlockEntity.MultiblockInventoryHandler_DirectProcessing<SawmillBlockEntity, MultiblockRecipe>(this){

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            stack = stack.m_41777_();
            SawmillBlockEntity.this.insertItemToProcess(stack, simulate);
            return stack;
        }
    }));

    public SawmillBlockEntity(BlockEntityType<SawmillBlockEntity> type, BlockPos pos, BlockState state) {
        super(IEMultiblocks.SAWMILL, 32000, true, type, pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.sawblade = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("sawblade"));
        ListTag processNBT = nbt.m_128437_("sawmillQueue", 10);
        this.sawmillProcessQueue.clear();
        for (int i = 0; i < processNBT.size(); ++i) {
            CompoundTag tag = processNBT.m_128728_(i);
            SawmillProcess process = SawmillProcess.readFromNBT(tag);
            this.sawmillProcessQueue.add(process);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!this.sawblade.m_41619_()) {
            nbt.m_128365_("sawblade", (Tag)this.sawblade.m_41739_(new CompoundTag()));
        }
        ListTag processNBT = new ListTag();
        for (SawmillProcess process : this.sawmillProcessQueue) {
            processNBT.add((Object)process.writeToNBT());
        }
        nbt.m_128365_("sawmillQueue", (Tag)processNBT);
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
    }

    @Override
    public boolean canTickAny() {
        return super.canTickAny() && !this.isRSDisabled();
    }

    @Override
    public void tickClient() {
        if (this.shouldRenderAsActive()) {
            Optional<SawmillProcess> process;
            this.animation_bladeRotation += 36.0f;
            this.animation_bladeRotation %= 360.0f;
            if (!this.sawblade.m_41619_() && (process = this.sawmillProcessQueue.stream().filter(SawmillProcess::isSawing).findFirst()).isPresent()) {
                Direction particleDir = this.getIsMirrored() ? this.getFacing().m_122427_() : this.getFacing().m_122428_();
                AABB aabb = CACHED_SAWBLADE_AABB.apply(this);
                double posX = aabb.f_82288_ + this.f_58857_.f_46441_.nextDouble() * (aabb.f_82291_ - aabb.f_82288_);
                double posY = aabb.f_82289_ + this.f_58857_.f_46441_.nextDouble() * (aabb.f_82292_ - aabb.f_82289_);
                double posZ = aabb.f_82290_ + this.f_58857_.f_46441_.nextDouble() * (aabb.f_82293_ - aabb.f_82290_);
                double vX = this.f_58857_.f_46441_.nextDouble() * (double)particleDir.m_122429_() * 0.3;
                double vY = this.f_58857_.f_46441_.nextDouble() * 0.3;
                double vZ = this.f_58857_.f_46441_.nextDouble() * (double)particleDir.m_122431_() * 0.3;
                this.f_58857_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, process.get().getCurrentStack(true)), posX, posY, posZ, vX, vY, vZ);
            }
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.tickedProcesses = 0;
        int max = this.getMaxProcessPerTick();
        int i = 0;
        Iterator<SawmillProcess> processIterator = this.sawmillProcessQueue.iterator();
        this.tickedProcesses = 0;
        HashSet<ItemStack> secondaries = new HashSet<ItemStack>();
        while (processIterator.hasNext() && i++ < max) {
            SawmillProcess process = processIterator.next();
            if (process.processStep(this, secondaries)) {
                ++this.tickedProcesses;
                this.updateMasterBlock(null, true);
            }
            if (!process.processFinished) continue;
            this.doProcessOutput(process.getCurrentStack(!this.sawblade.m_41619_()).m_41777_());
            processIterator.remove();
            if (!this.sawblade.m_41629_(((Integer)IEServerConfig.MACHINES.sawmill_bladeDamage.get()).intValue(), Utils.RAND, null)) continue;
            this.sawblade = ItemStack.f_41583_;
            this.updateMasterBlock(null, true);
        }
        for (ItemStack output : secondaries) {
            this.doSecondaryOutput(output.m_41777_());
        }
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        SawmillBlockEntity master = (SawmillBlockEntity)this.master();
        if (master != null) {
            if (player.m_6144_() && !master.sawblade.m_41619_()) {
                if (heldItem.m_41619_()) {
                    player.m_21008_(hand, master.sawblade.m_41777_());
                } else if (!this.f_58857_.f_46443_) {
                    player.m_5552_(master.sawblade.m_41777_(), 0.0f);
                }
                master.sawblade = ItemStack.f_41583_;
                this.updateMasterBlock(null, true);
                return true;
            }
            if (IETags.sawblades.m_8110_((Object)heldItem.m_41720_())) {
                ItemStack tempBlade = !master.sawblade.m_41619_() ? master.sawblade.m_41777_() : ItemStack.f_41583_;
                master.sawblade = ItemHandlerHelper.copyStackWithSize((ItemStack)heldItem, (int)1);
                heldItem.m_41774_(1);
                if (heldItem.m_41613_() <= 0) {
                    heldItem = ItemStack.f_41583_;
                } else {
                    player.m_21008_(hand, heldItem);
                }
                if (!tempBlade.m_41619_()) {
                    if (heldItem.m_41619_()) {
                        player.m_21008_(hand, tempBlade);
                    } else if (!this.f_58857_.f_46443_) {
                        player.m_5552_(tempBlade, 0.0f);
                    }
                }
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.posInMultiblock, (Pair<Direction, Boolean>)Pair.of((Object)this.getFacing(), (Object)this.getIsMirrored()));
    }

    private static List<AABB> getShape(BlockPos posInMultiblock) {
        ImmutableSet slabs = ImmutableSet.of((Object)new BlockPos(0, 0, 0), (Object)new BlockPos(4, 0, 0), (Object)new BlockPos(4, 0, 2));
        if (slabs.contains(posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.5, (double)1.0).m_83299_();
        }
        if (new BlockPos(0, 0, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
            list.add(new AABB(0.125, 0.5, 0.625, 0.25, 1.0, 0.875));
            list.add(new AABB(0.75, 0.5, 0.625, 0.875, 1.0, 0.875));
            return list;
        }
        if (new BlockPos(0, 1, 2).equals((Object)posInMultiblock)) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0).m_83299_();
        }
        if (new BlockPos(1, 1, 1).equals((Object)posInMultiblock)) {
            return Shapes.m_83048_((double)0.25, (double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0).m_83299_();
        }
        if (new BlockPos(1, 1, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AABB[]{new AABB(0.25, 0.0, 0.0, 0.875, 1.0, 0.125)});
            list.add(new AABB(0.25, 0.0, 0.125, 0.875, 0.875, 0.75));
            list.add(new AABB(0.1875, 0.0, 0.0, 0.9375, 0.125, 0.8125));
            return list;
        }
        if (new BlockPos(1, 0, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
            list.add(new AABB(0.1875, 0.5, 0.0, 0.9375, 1.0, 0.8125));
            list.add(new AABB(0.9375, 0.5, 0.25, 1.0, 0.875, 0.625));
            return list;
        }
        if (new BlockPos(2, 0, 2).equals((Object)posInMultiblock)) {
            ArrayList list = Lists.newArrayList((Object[])new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0)});
            list.add(new AABB(0.0, 0.5, 0.25, 1.0, 0.875, 0.625));
            return list;
        }
        if (posInMultiblock.m_123342_() == 1 && posInMultiblock.m_123343_() == 1) {
            return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.125, (double)1.0).m_83299_();
        }
        return Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).m_83299_();
    }

    @Override
    public Set<PoweredMultiblockBlockEntity.MultiblockFace> getEnergyPos() {
        return ImmutableSet.of((Object)new PoweredMultiblockBlockEntity.MultiblockFace(2, 1, 0, RelativeBlockFace.UP));
    }

    @Override
    public Set<BlockPos> getRedstonePos() {
        return ImmutableSet.of((Object)new BlockPos(0, 1, 2));
    }

    @Override
    protected int getComparatorValueOnMaster() {
        float damage = 1.0f - (float)this.sawblade.m_41773_() / (float)this.sawblade.m_41776_();
        return Mth.m_14143_((float)(damage * 15.0f));
    }

    @Override
    public boolean shouldRenderAsActiveImpl() {
        return this.energyStorage.getEnergyStored() > 0 && !this.isRSDisabled() && !this.sawblade.m_41619_();
    }

    private void insertItemToProcess(ItemStack stack, boolean simulate) {
        if (this.sawmillProcessQueue.size() < this.getProcessQueueMaxLength()) {
            float dist = 1.0f;
            float minProcessDist = 0.1f;
            SawmillProcess p = null;
            if (this.sawmillProcessQueue.size() > 0) {
                p = this.sawmillProcessQueue.get(this.sawmillProcessQueue.size() - 1);
                if (p != null) {
                    dist = p.getRelativeProcessStep();
                    if (!stack.m_41656_(p.input) || this.combinedLogs > 2) {
                        if (!simulate) {
                            this.combinedLogs = 0;
                        }
                        minProcessDist = 0.5f;
                    }
                }
            } else if (this.combinedLogs > 0) {
                this.combinedLogs = 0;
            }
            if (p != null && dist < minProcessDist) {
                return;
            }
            if (!simulate) {
                p = new SawmillProcess(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                this.sawmillProcessQueue.add(p);
                this.m_6596_();
                this.markContainingBlockForUpdate(null);
                ++this.combinedLogs;
            }
            stack.m_41774_(1);
        }
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (!world.f_46443_ && entity != null && entity.m_6084_()) {
            SawmillBlockEntity master = (SawmillBlockEntity)this.master();
            if (master == null) {
                return;
            }
            if (new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack stack = itemEntity.m_32055_();
                if (stack.m_41619_()) {
                    return;
                }
                stack = stack.m_41777_();
                master.insertItemToProcess(stack, false);
                if (stack.m_41613_() <= 0) {
                    entity.m_146870_();
                } else {
                    itemEntity.m_32045_(stack);
                }
            } else if (entity instanceof LivingEntity && !master.sawblade.m_41619_() && CACHED_SAWBLADE_AABB.apply(master).m_82381_(entity.m_142469_())) {
                if (entity instanceof Player && ((Player)entity).m_150110_().f_35934_) {
                    return;
                }
                int consumed = master.energyStorage.extractEnergy(80, true);
                if (consumed > 0) {
                    master.energyStorage.extractEnergy(consumed, false);
                    entity.m_6469_(IEDamageSources.sawmill, 7.0f);
                }
            }
        }
    }

    @Override
    public boolean isInWorldProcessingMachine() {
        return true;
    }

    @Override
    public boolean additionalCanProcessCheck(MultiblockProcess<MultiblockRecipe> process) {
        return true;
    }

    @Override
    public void doProcessOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.outputCap, output, false)).m_41619_()) {
            Direction outDir = this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_();
            BlockPos pos = this.m_58899_().m_5484_(outDir, 3);
            Utils.dropStackAtPos(this.f_58857_, pos, output, outDir);
        }
    }

    public void doSecondaryOutput(ItemStack output) {
        if (!(output = Utils.insertStackIntoInventory(this.secondaryOutputCap, output, false)).m_41619_()) {
            DirectionalBlockPos secondaryPos = this.getSecondaryOutputCapPos();
            Utils.dropStackAtPos(this.f_58857_, secondaryPos.position(), output, secondaryPos.side().m_122424_());
        }
    }

    @Override
    public void doProcessFluidOutput(FluidStack output) {
    }

    @Override
    public void onProcessFinish(MultiblockProcess<MultiblockRecipe> process) {
    }

    @Override
    public int getMaxProcessPerTick() {
        return 6;
    }

    @Override
    public int getProcessQueueMaxLength() {
        return 6;
    }

    @Override
    public float getMinProcessDistance(MultiblockProcess<MultiblockRecipe> process) {
        return 0.5f;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return null;
    }

    @Override
    public NonNullList<ItemStack> getDroppedItems() {
        return ListUtils.fromItems(this.sawblade);
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return true;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public int[] getOutputSlots() {
        return null;
    }

    @Override
    public int[] getOutputTanks() {
        return new int[0];
    }

    @Override
    public IFluidTank[] getInternalTanks() {
        return new IFluidTank[0];
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public MultiblockRecipe findRecipeForInsertion(ItemStack inserting) {
        return null;
    }

    @Override
    protected MultiblockRecipe getRecipeForId(ResourceLocation id) {
        return null;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && new BlockPos(0, 1, 1).equals((Object)this.posInMultiblock) && facing == (this.getIsMirrored() ? this.getFacing().m_122427_() : this.getFacing().m_122428_())) {
            return this.insertionHandler.getAndCast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Direction[] sigOutputDirections() {
        if (new BlockPos(4, 1, 1).equals((Object)this.posInMultiblock)) {
            return new Direction[]{this.getIsMirrored() ? this.getFacing().m_122428_() : this.getFacing().m_122427_()};
        }
        return new Direction[0];
    }

    private DirectionalBlockPos getSecondaryOutputCapPos() {
        Direction shiftDir = this.getFacing().m_122424_();
        return new DirectionalBlockPos(this.getBlockPosForPos(new BlockPos(3, 0, 2)).m_142300_(shiftDir), shiftDir.m_122424_());
    }

    public static class SawmillProcess {
        private final ItemStack input;
        private final SawmillRecipe recipe;
        private final float maxProcessTicks;
        private final int energyPerTick;
        private int processTick;
        private boolean stripped = false;
        private boolean sawed = false;
        private boolean processFinished = false;

        public SawmillProcess(ItemStack input) {
            this.input = input;
            this.recipe = SawmillRecipe.findRecipe(input);
            if (this.recipe != null) {
                this.maxProcessTicks = this.recipe.getTotalProcessTime();
                this.energyPerTick = this.recipe.getTotalProcessEnergy() / this.recipe.getTotalProcessTime();
            } else {
                this.maxProcessTicks = 80.0f;
                this.energyPerTick = 40;
            }
        }

        public boolean processStep(SawmillBlockEntity tile, Set<ItemStack> secondaries) {
            if (tile.energyStorage.extractEnergy(this.energyPerTick, true) >= this.energyPerTick) {
                tile.energyStorage.extractEnergy(this.energyPerTick, false);
                ++this.processTick;
                float relative = this.getRelativeProcessStep();
                if (this.recipe != null) {
                    if (!this.stripped && (double)relative >= 0.3125) {
                        this.stripped = true;
                        secondaries.addAll((Collection<ItemStack>)this.recipe.secondaryStripping);
                    }
                    if (!this.sawed && (double)relative >= 0.8625) {
                        this.sawed = true;
                        if (!tile.sawblade.m_41619_()) {
                            secondaries.addAll((Collection<ItemStack>)this.recipe.secondaryOutputs);
                        }
                    }
                }
                if (relative >= 1.0f) {
                    this.processFinished = true;
                }
                return true;
            }
            return false;
        }

        public float getRelativeProcessStep() {
            return (float)this.processTick / this.maxProcessTicks;
        }

        public ItemStack getCurrentStack(boolean sawblade) {
            if (this.recipe == null) {
                return this.input;
            }
            if (!this.stripped) {
                return this.input;
            }
            ItemStack stripped = this.recipe.stripped;
            if (stripped.m_41619_()) {
                stripped = this.input;
            }
            if (!this.sawed) {
                return stripped;
            }
            return sawblade ? this.recipe.output : stripped;
        }

        public boolean isSawing() {
            return (double)this.getRelativeProcessStep() > 0.5375 && !this.sawed;
        }

        public CompoundTag writeToNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("input", (Tag)this.input.m_41739_(new CompoundTag()));
            nbt.m_128405_("processTick", this.processTick);
            nbt.m_128379_("stripped", this.stripped);
            nbt.m_128379_("sawed", this.sawed);
            return nbt;
        }

        public static SawmillProcess readFromNBT(CompoundTag nbt) {
            ItemStack input = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("input"));
            SawmillProcess process = new SawmillProcess(input);
            process.processTick = nbt.m_128451_("processTick");
            process.stripped = nbt.m_128471_("stripped");
            process.sawed = nbt.m_128471_("sawed");
            return process;
        }
    }
}

