/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.stone;

import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.generic.MultiblockPartBlockEntity;
import blusunrize.immersiveengineering.common.blocks.multiblocks.IETemplateMultiblock;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class FurnaceLikeBlockEntity<R, T extends FurnaceLikeBlockEntity<R, T>>
extends MultiblockPartBlockEntity<T>
implements IIEInventory,
IEBlockInterfaces.IActiveState,
IEBlockInterfaces.IInteractionObjectIE<T>,
IEBlockInterfaces.IProcessBE,
IEBlockInterfaces.IBlockBounds {
    protected final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private int process = 0;
    private int processMax = 0;
    private int burnTime = 0;
    private int lastBurnTime = 0;
    public final StateView stateView = new StateView();
    private final int fuelSlot;
    private final List<InputSlot<R>> inputs;
    private final List<OutputSlot<R>> outputs;
    private final ToIntFunction<R> getProcessingTime;

    protected FurnaceLikeBlockEntity(IETemplateMultiblock mb, BlockEntityType<T> type, int fuelSlot, List<InputSlot<R>> inputs, List<OutputSlot<R>> outputs, ToIntFunction<R> getProcessingTime, BlockPos pos, BlockState state) {
        super(mb, type, false, pos, state);
        this.fuelSlot = fuelSlot;
        this.inputs = inputs;
        this.outputs = outputs;
        this.getProcessingTime = getProcessingTime;
    }

    @Override
    public boolean canUseGui(Player player) {
        return this.formed;
    }

    @Override
    public T getGuiMaster() {
        return (T)((FurnaceLikeBlockEntity)this.master());
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return Shapes.m_83144_();
    }

    @Override
    public void tickServer() {
        boolean activeAfterTick;
        int addedBurntime;
        boolean activeBeforeTick = this.getIsActive();
        if (this.burnTime > 0) {
            R recipe;
            int processSpeed = 1;
            if (this.process > 0) {
                processSpeed = this.getProcessSpeed();
            }
            this.burnTime -= processSpeed;
            if (this.process > 0) {
                if (this.isAnyInputEmpty()) {
                    this.process = 0;
                    this.processMax = 0;
                } else {
                    recipe = this.getRecipe();
                    if (recipe != null && this.getProcessTime(recipe) != this.processMax) {
                        this.processMax = 0;
                        this.process = 0;
                        this.setActive(false);
                    } else {
                        this.process -= processSpeed;
                        processSpeed = 0;
                        if (!activeBeforeTick) {
                            this.setActive(true);
                        }
                    }
                }
                this.m_6596_();
            }
            if (this.process <= 0) {
                if (this.processMax > 0) {
                    this.doRecipeIO();
                    this.processMax = 0;
                    this.burnTime -= this.process;
                }
                if ((recipe = this.getRecipe()) != null) {
                    int time = this.getProcessTime(recipe);
                    this.process = time - processSpeed;
                    this.processMax = time;
                    this.setActive(true);
                }
            }
        } else if (activeBeforeTick) {
            this.setActive(false);
        }
        if (this.burnTime <= 0 && this.getRecipe() != null && (addedBurntime = this.getBurnTimeOf((ItemStack)this.inventory.get(this.fuelSlot))) > 0) {
            this.lastBurnTime = addedBurntime;
            this.burnTime += this.lastBurnTime;
            Utils.modifyInvStackSize(this.inventory, this.fuelSlot, -1);
            this.m_6596_();
        }
        if (activeBeforeTick != (activeAfterTick = this.getIsActive())) {
            this.m_6596_();
            if (!activeAfterTick) {
                this.turnOff();
            }
            for (StructureTemplate.StructureBlockInfo info : this.multiblockInstance.getStructure(this.f_58857_)) {
                FurnaceLikeBlockEntity te = (FurnaceLikeBlockEntity)this.getEntityForPos(info.f_74675_);
                if (te == null) continue;
                te.setActive(activeAfterTick);
            }
        }
    }

    protected void turnOff() {
    }

    @Nullable
    public R getRecipe() {
        R recipe = this.getRecipeForInput();
        if (recipe == null) {
            return null;
        }
        for (OutputSlot<R> out : this.outputs) {
            ItemStack currentStack = (ItemStack)this.inventory.get(out.slotIndex);
            ItemStack outputSlot = out.get(recipe);
            if (currentStack.m_41619_()) continue;
            if (!ItemStack.m_41746_((ItemStack)currentStack, (ItemStack)outputSlot)) {
                return null;
            }
            if (currentStack.m_41613_() + outputSlot.m_41613_() <= this.getSlotLimit(out.slotIndex)) continue;
            return null;
        }
        return recipe;
    }

    @Nullable
    protected abstract R getRecipeForInput();

    protected int getProcessSpeed() {
        return 1;
    }

    @Override
    public int[] getCurrentProcessesStep() {
        FurnaceLikeBlockEntity master = (FurnaceLikeBlockEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesStep();
        }
        return new int[]{this.processMax - this.process};
    }

    @Override
    public int[] getCurrentProcessesMax() {
        FurnaceLikeBlockEntity master = (FurnaceLikeBlockEntity)this.master();
        if (master != this && master != null) {
            return master.getCurrentProcessesMax();
        }
        return new int[]{this.processMax};
    }

    @Override
    public boolean m_7531_(int id, int arg) {
        if (id == 0) {
            this.formed = arg == 1;
        }
        this.m_6596_();
        this.markContainingBlockForUpdate(null);
        return true;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        if (!descPacket) {
            this.process = nbt.m_128451_("process");
            this.processMax = nbt.m_128451_("processMax");
            this.burnTime = nbt.m_128451_("burnTime");
            this.lastBurnTime = nbt.m_128451_("lastBurnTime");
            ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        if (!descPacket) {
            nbt.m_128405_("process", this.process);
            nbt.m_128405_("processMax", this.processMax);
            nbt.m_128405_("burnTime", this.burnTime);
            nbt.m_128405_("lastBurnTime", this.lastBurnTime);
            ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        }
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
    }

    public StateView getGuiInts() {
        return this.stateView;
    }

    private boolean isAnyInputEmpty() {
        for (InputSlot<R> i : this.inputs) {
            if (!((ItemStack)this.inventory.get(i.slotIndex)).m_41619_()) continue;
            return true;
        }
        return false;
    }

    private int getProcessTime(R recipe) {
        return this.getProcessingTime.applyAsInt(recipe);
    }

    private void doRecipeIO() {
        R recipe = this.getRecipe();
        if (recipe != null) {
            for (InputSlot<R> inputSlot : this.inputs) {
                Utils.modifyInvStackSize(this.inventory, inputSlot.slotIndex, -inputSlot.get(recipe).getCount());
            }
            for (OutputSlot outputSlot : this.outputs) {
                ItemStack result = outputSlot.get(recipe);
                if (result.m_41619_()) continue;
                if (!((ItemStack)this.inventory.get(outputSlot.slotIndex)).m_41619_()) {
                    ((ItemStack)this.inventory.get(outputSlot.slotIndex)).m_41769_(result.m_41777_().m_41613_());
                    continue;
                }
                this.inventory.set(outputSlot.slotIndex, (Object)result.m_41777_());
            }
        }
    }

    protected abstract int getBurnTimeOf(ItemStack var1);

    public class StateView
    implements ContainerData {
        public static final int LAST_BURN_TIME = 0;
        public static final int BURN_TIME = 1;
        public static final int PROCESS_MAX = 2;
        public static final int CURRENT_PROCESS = 3;

        public int getLastBurnTime() {
            return this.m_6413_(0);
        }

        public int getBurnTime() {
            return this.m_6413_(1);
        }

        public int getMaxProcess() {
            return this.m_6413_(2);
        }

        public int getProcess() {
            return this.m_6413_(3);
        }

        public int m_6413_(int index) {
            switch (index) {
                case 0: {
                    return FurnaceLikeBlockEntity.this.lastBurnTime;
                }
                case 1: {
                    return FurnaceLikeBlockEntity.this.burnTime;
                }
                case 2: {
                    return FurnaceLikeBlockEntity.this.processMax;
                }
                case 3: {
                    return FurnaceLikeBlockEntity.this.process;
                }
            }
            throw new IllegalArgumentException("Unknown index " + index);
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    FurnaceLikeBlockEntity.this.lastBurnTime = value;
                    break;
                }
                case 1: {
                    FurnaceLikeBlockEntity.this.burnTime = value;
                    break;
                }
                case 2: {
                    FurnaceLikeBlockEntity.this.processMax = value;
                    break;
                }
                case 3: {
                    FurnaceLikeBlockEntity.this.process = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown index " + index);
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    }

    protected static class OutputSlot<R> {
        private final Function<R, ItemStack> getFromRecipe;
        private final int slotIndex;

        public OutputSlot(Function<R, ItemStack> getFromRecipe, int slotIndex) {
            this.getFromRecipe = getFromRecipe;
            this.slotIndex = slotIndex;
        }

        public ItemStack get(R recipe) {
            return this.getFromRecipe.apply(recipe);
        }
    }

    protected static class InputSlot<R> {
        private final Function<R, IngredientWithSize> getFromRecipe;
        private final int slotIndex;

        public InputSlot(Function<R, IngredientWithSize> getFromRecipe, int slotIndex) {
            this.getFromRecipe = getFromRecipe;
            this.slotIndex = slotIndex;
        }

        public IngredientWithSize get(R recipe) {
            return this.getFromRecipe.apply(recipe);
        }
    }
}

