/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.tool.LogicCircuitHandler;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.items.LogicCircuitBoardItem;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class LogicUnitBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IInteractionObjectIE<LogicUnitBlockEntity>,
IEBlockInterfaces.IStateBasedDirectional,
LogicCircuitHandler.ILogicCircuitHandler {
    private static final int SIZE_COLORS = DyeColor.values().length;
    private static final int SIZE_REGISTERS = LogicCircuitHandler.LogicCircuitRegister.values().length - SIZE_COLORS;
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);
    private final Map<Direction, boolean[]> inputs = new EnumMap<Direction, boolean[]>(Direction.class);
    private final boolean[] registers = new boolean[SIZE_REGISTERS];
    private final boolean[] outputs = new boolean[SIZE_COLORS];
    private final Map<Direction, ResettableCapability<CapabilityRedstoneNetwork.RedstoneBundleConnection>> redstoneCaps = new EnumMap<Direction, ResettableCapability<CapabilityRedstoneNetwork.RedstoneBundleConnection>>(Direction.class);
    ResettableLazy<boolean[]> combinedInputs;

    public LogicUnitBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.LOGIC_UNIT.get(), pos, state);
        for (Direction f : DirectionUtils.VALUES) {
            ResettableCapability<1> forSide = this.registerCapability(new CapabilityRedstoneNetwork.RedstoneBundleConnection(){

                @Override
                public void onChange(byte[] externalInputs, Direction side) {
                    boolean[] sideInputs = LogicUnitBlockEntity.this.inputs.getOrDefault(side, new boolean[SIZE_COLORS]);
                    boolean[] preInput = Arrays.copyOf(sideInputs, SIZE_COLORS);
                    for (int i = 0; i < SIZE_COLORS; ++i) {
                        sideInputs[i] = externalInputs[i] > 0;
                    }
                    if (!Arrays.equals(preInput, sideInputs)) {
                        LogicUnitBlockEntity.this.inputs.put(side, sideInputs);
                        LogicUnitBlockEntity.this.combinedInputs.reset();
                        LogicUnitBlockEntity.this.updateOutputs();
                    }
                }

                @Override
                public void updateInput(byte[] signals, Direction side) {
                    for (DyeColor dye : DyeColor.values()) {
                        if (!LogicUnitBlockEntity.this.outputs[dye.m_41060_()]) continue;
                        signals[dye.m_41060_()] = 15;
                    }
                }
            });
            this.redstoneCaps.put(f, forSide);
        }
        this.combinedInputs = new ResettableLazy(() -> {
            boolean[] ret = new boolean[SIZE_COLORS];
            for (boolean[] side : this.inputs.values()) {
                for (int i = 0; i < SIZE_COLORS; ++i) {
                    int n = i;
                    ret[n] = ret[n] | side[i];
                }
            }
            return ret;
        });
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return placer.m_6144_();
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        CompoundTag nbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
        if (!nbt.m_128456_()) {
            stack.m_41751_(nbt);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            this.readCustomNBT(stack.m_41784_(), false);
        }
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public LogicUnitBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEContainerTypes.BEContainer<LogicUnitBlockEntity, ?> getContainerType() {
        return IEContainerTypes.LOGIC_UNIT;
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return stack.m_41720_() instanceof LogicCircuitBoardItem;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
        this.updateOutputs();
        this.markContainingBlockForUpdate(null);
    }

    private void updateOutputs() {
        boolean[] outPre = Arrays.copyOf(this.outputs, SIZE_COLORS);
        Arrays.fill(this.registers, false);
        Arrays.fill(this.outputs, false);
        this.inventory.stream().map(LogicCircuitBoardItem::getInstruction).filter(Objects::nonNull).forEachOrdered(instruction -> instruction.apply(this));
        if (!Arrays.equals(outPre, this.outputs)) {
            this.markConnectorsDirty();
        }
    }

    private void markConnectorsDirty() {
        this.redstoneCaps.values().forEach(cap -> ((CapabilityRedstoneNetwork.RedstoneBundleConnection)cap.get()).markDirty());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION && facing != null) {
            return this.redstoneCaps.get(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean getLogicCircuitRegister(LogicCircuitHandler.LogicCircuitRegister register) {
        if (register.ordinal() < SIZE_COLORS) {
            return this.combinedInputs.get()[register.ordinal()];
        }
        return this.registers[register.ordinal() - SIZE_COLORS];
    }

    @Override
    public void setLogicCircuitRegister(LogicCircuitHandler.LogicCircuitRegister register, boolean state) {
        if (register.ordinal() < SIZE_COLORS) {
            this.outputs[register.ordinal()] = state;
        } else {
            this.registers[register.ordinal() - LogicUnitBlockEntity.SIZE_COLORS] = state;
        }
    }
}

