/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.wooden;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEContainerTypes;
import blusunrize.immersiveengineering.common.util.ResettableCapability;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEInventoryHandler;
import blusunrize.immersiveengineering.common.util.inventory.IIEInventory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class WoodenCrateBlockEntity
extends IEBaseBlockEntity
implements IIEInventory,
IEBlockInterfaces.IInteractionObjectIE<WoodenCrateBlockEntity>,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IComparatorOverride {
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    public ResourceLocation lootTable;
    public String name;
    private ListTag enchantments;
    private final ResettableCapability<IItemHandler> insertionCap = this.registerCapability(new IEInventoryHandler(27, this));

    public WoodenCrateBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.WOODEN_CRATE.get(), pos, state);
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (nbt.m_128425_("name", 8)) {
            this.name = nbt.m_128461_("name");
        }
        if (nbt.m_128425_("enchantments", 9)) {
            this.enchantments = nbt.m_128437_("enchantments", 10);
        }
        if (!descPacket) {
            if (nbt.m_128425_("lootTable", 8)) {
                this.lootTable = new ResourceLocation(nbt.m_128461_("lootTable"));
            } else {
                ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
            }
        }
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        if (this.name != null) {
            nbt.m_128359_("name", this.name);
        }
        if (this.enchantments != null && this.enchantments.size() > 0) {
            nbt.m_128365_("enchantments", (Tag)this.enchantments);
        }
        if (!descPacket) {
            if (this.lootTable != null) {
                nbt.m_128359_("lootTable", this.lootTable.toString());
            } else {
                ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
            }
        }
    }

    @Override
    @Nonnull
    public Component m_5446_() {
        if (this.name != null) {
            return new TextComponent(this.name);
        }
        Block b = this.m_58900_().m_60734_();
        if (b == IEBlocks.WoodenDevices.REINFORCED_CRATE.get()) {
            return new TranslatableComponent("block.immersiveengineering.reinforced_crate");
        }
        return new TranslatableComponent("block.immersiveengineering.crate");
    }

    @Override
    public boolean canUseGui(Player player) {
        return true;
    }

    @Override
    public WoodenCrateBlockEntity getGuiMaster() {
        return this;
    }

    @Override
    public IEContainerTypes.BEContainer<WoodenCrateBlockEntity, ?> getContainerType() {
        return IEContainerTypes.WOODEN_CRATE;
    }

    @Override
    @Nonnull
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        if (this.lootTable != null) {
            LootTable loottable = this.f_58857_.m_142572_().m_129898_().m_79217_(this.lootTable);
            this.lootTable = null;
            LootContext.Builder contextBuilder = new LootContext.Builder((ServerLevel)this.f_58857_);
            contextBuilder.m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.f_58858_));
            if (player != null) {
                contextBuilder.m_78963_(player.m_36336_());
            }
            LootContext context = contextBuilder.m_78975_(LootContextParamSets.f_81411_);
            Random rand = new Random();
            List list = loottable.m_79129_(context);
            ArrayList listSlots = Lists.newArrayList();
            for (int i = 0; i < this.inventory.size(); ++i) {
                if (!((ItemStack)this.inventory.get(i)).m_41619_()) continue;
                listSlots.add(i);
            }
            Collections.shuffle(listSlots, rand);
            if (!listSlots.isEmpty()) {
                Utils.shuffleLootItems(list, listSlots.size(), rand);
                for (ItemStack itemstack : list) {
                    int slot = (Integer)listSlots.remove(listSlots.size() - 1);
                    this.inventory.set(slot, (Object)itemstack);
                }
                this.m_6596_();
            }
        }
        return IEBlockInterfaces.IInteractionObjectIE.super.m_7208_(id, playerInventory, player);
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public boolean isStackValid(int slot, ItemStack stack) {
        return IEApi.isAllowedInCrate(stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 64;
    }

    @Override
    public void doGraphicalUpdates() {
        this.m_6596_();
    }

    @Override
    public List<ItemStack> getBlockEntityDrop(LootContext context) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        CompoundTag tag = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)tag, this.inventory, (boolean)false);
        if (!tag.m_128456_()) {
            stack.m_41751_(tag);
        }
        if (this.name != null) {
            stack.m_41714_((Component)new TextComponent(this.name));
        }
        if (this.enchantments != null && this.enchantments.size() > 0) {
            stack.m_41784_().m_128365_("ench", (Tag)this.enchantments);
        }
        return ImmutableList.of((Object)stack);
    }

    @Override
    public void readOnPlacement(LivingEntity placer, ItemStack stack) {
        if (stack.m_41782_()) {
            this.readCustomNBT(stack.m_41784_(), false);
            if (stack.m_41788_()) {
                this.name = stack.m_41786_().getString();
            }
            this.enchantments = stack.m_41785_();
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return Utils.calcRedstoneFromInventory(this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.insertionCap.cast();
        }
        return super.getCapability(capability, facing);
    }
}

