/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.utils.TagUtils;
import com.google.common.collect.ImmutableList;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.items.ItemHandlerHelper;

public class ArcRecyclingRecipe
extends ArcFurnaceRecipe {
    private final Supplier<TagContainer> tags;
    private Map<ItemStack, Double> outputs;
    private final Lazy<NonNullList<ItemStack>> defaultOutputs = Lazy.of(() -> {
        NonNullList ret = NonNullList.m_122779_();
        for (Map.Entry<ItemStack, Double> e : this.outputs.entrySet()) {
            double scaledOut = e.getValue();
            this.addOutputToList(scaledOut, (NonNullList<ItemStack>)ret, e);
        }
        return ret;
    });

    public ArcRecyclingRecipe(ResourceLocation id, Supplier<TagContainer> tags, Map<ItemStack, Double> outputs, IngredientWithSize input, int time, int energyPerTick) {
        super(id, (NonNullList<ItemStack>)outputs.keySet().stream().collect(NonNullList::m_122779_, AbstractList::add, AbstractCollection::addAll), ItemStack.f_41583_, (List<StackWithChance>)ImmutableList.of(), time, energyPerTick, input, new IngredientWithSize[0]);
        this.tags = tags;
        this.outputs = outputs;
        this.setSpecialRecipeType("Recycling");
    }

    @Override
    public NonNullList<ItemStack> generateActualOutput(ItemStack input, NonNullList<ItemStack> additives, long seed) {
        if (this.outputs == null) {
            return NonNullList.m_122779_();
        }
        float mod = !input.m_41763_() ? 1.0f : (float)(input.m_41776_() - input.m_41773_()) / (float)input.m_41776_();
        NonNullList outs = NonNullList.m_122779_();
        for (Map.Entry<ItemStack, Double> e : this.outputs.entrySet()) {
            double scaledOut = (double)mod * e.getValue();
            this.addOutputToList(scaledOut, (NonNullList<ItemStack>)outs, e);
        }
        return outs;
    }

    @Override
    public NonNullList<ItemStack> getBaseOutputs() {
        return (NonNullList)this.defaultOutputs.get();
    }

    @Override
    public NonNullList<ItemStack> getItemOutputs() {
        return (NonNullList)this.defaultOutputs.get();
    }

    private void addOutputToList(double scaledOut, NonNullList<ItemStack> outs, Map.Entry<ItemStack, Double> e) {
        String[] type;
        int nuggetOut;
        if (scaledOut >= 1.0) {
            outs.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)e.getKey(), (int)((int)scaledOut)));
        }
        if ((nuggetOut = (int)((scaledOut - (double)((int)scaledOut)) * 9.0)) > 0 && (type = TagUtils.getMatchingPrefixAndRemaining(this.tags.get(), e.getKey(), "ingots")) != null) {
            ItemStack nuggets = IEApi.getPreferredTagStack(this.tags.get(), IETags.getNugget(type[1]));
            outs.add((Object)ItemHandlerHelper.copyStackWithSize((ItemStack)nuggets, (int)nuggetOut));
        }
    }

    @Override
    public boolean matches(ItemStack input, NonNullList<ItemStack> additives) {
        return !input.m_41619_() && this.input.test(input);
    }

    public Map<ItemStack, Double> getOutputs() {
        return this.outputs;
    }
}

