/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractFluidAwareRecipe;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.common.util.RecipeMatcher;

public class ShapelessFluidAwareRecipe
extends AbstractFluidAwareRecipe<MatchLocation> {
    public ShapelessFluidAwareRecipe(ResourceLocation idIn, String groupIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(idIn, groupIn, recipeItemsIn, recipeOutputIn);
    }

    public ShapelessFluidAwareRecipe(ShapelessRecipe in) {
        this(in.m_6423_(), in.m_6076_(), (NonNullList<Ingredient>)in.m_7527_(), in.m_8043_());
    }

    @Override
    @Nullable
    protected MatchLocation findMatch(CraftingContainer inv) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int[] slotToInput = new int[inv.m_6643_()];
        Arrays.fill(slotToInput, -1);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            slotToInput[i] = inputs.size();
            inputs.add(itemstack);
        }
        if (inputs.size() != this.m_7527_().size()) {
            return null;
        }
        int[] matchMap = RecipeMatcher.findMatches(inputs, this.m_7527_());
        if (matchMap == null) {
            return null;
        }
        int[][] slotToIngredient = new int[inv.m_39347_()][inv.m_39346_()];
        for (int x = 0; x < inv.m_39347_(); ++x) {
            for (int y = 0; y < inv.m_39346_(); ++y) {
                int inputId = slotToInput[x + inv.m_39347_() * y];
                slotToIngredient[x][y] = inputId >= 0 ? matchMap[inputId] : -1;
            }
        }
        return new MatchLocation(slotToIngredient);
    }

    public ShapelessRecipe toVanilla() {
        return new ShapelessRecipe(this.m_6423_(), this.m_6076_(), this.m_8043_(), this.m_7527_());
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.m_7527_().size();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializers.IE_SHAPELESS_SERIALIZER.get();
    }

    public static class MatchLocation
    implements AbstractFluidAwareRecipe.IMatchLocation {
        private final int[][] map;

        public MatchLocation(int[][] map) {
            this.map = map;
        }

        @Override
        public int getListIndex(int x, int y) {
            return this.map[x][y];
        }
    }
}

