/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;

public class ArcFurnaceRecipeSerializer
extends IERecipeSerializer<ArcFurnaceRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.ARC_FURNACE);
    }

    @Override
    public ArcFurnaceRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray results = json.getAsJsonArray("results");
        NonNullList outputs = NonNullList.m_122780_((int)results.size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < results.size(); ++i) {
            outputs.set(i, (Object)ArcFurnaceRecipeSerializer.readOutput(results.get(i)));
        }
        IngredientWithSize input = IngredientWithSize.deserialize(json.get("input"));
        JsonArray additives = json.getAsJsonArray("additives");
        IngredientWithSize[] ingredients = new IngredientWithSize[additives.size()];
        for (int i = 0; i < additives.size(); ++i) {
            ingredients[i] = IngredientWithSize.deserialize(additives.get(i));
        }
        ItemStack slag = ItemStack.f_41583_;
        if (json.has("slag")) {
            slag = ArcFurnaceRecipeSerializer.readOutput(json.get("slag"));
        }
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        JsonArray array = json.getAsJsonArray("secondaries");
        ArrayList<StackWithChance> secondaries = new ArrayList<StackWithChance>();
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                StackWithChance secondary = ArcFurnaceRecipeSerializer.readConditionalStackWithChance(array.get(i));
                if (secondary == null) continue;
                secondaries.add(secondary);
            }
        }
        return IEServerConfig.MACHINES.arcFurnaceConfig.apply(new ArcFurnaceRecipe(recipeId, (NonNullList<ItemStack>)outputs, slag, secondaries, time, energy, input, ingredients));
    }

    @Nullable
    public ArcFurnaceRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        List<ItemStack> outputNullable = PacketUtils.readList(buffer, FriendlyByteBuf::m_130267_);
        NonNullList outputs = NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((ItemStack[])outputNullable.toArray(ItemStack[]::new)));
        List<StackWithChance> secondaries = PacketUtils.readList(buffer, StackWithChance::read);
        IngredientWithSize input = IngredientWithSize.read(buffer);
        IngredientWithSize[] additives = PacketUtils.readList(buffer, IngredientWithSize::read).toArray(new IngredientWithSize[0]);
        ItemStack slag = buffer.m_130267_();
        int time = buffer.readInt();
        int energy = buffer.readInt();
        if (!buffer.readBoolean()) {
            return new ArcFurnaceRecipe(recipeId, (NonNullList<ItemStack>)outputs, slag, secondaries, time, energy, input, additives);
        }
        int numOutputs = buffer.m_130242_();
        HashMap<ItemStack, Double> recyclingOutputs = new HashMap<ItemStack, Double>(numOutputs);
        for (int i = 0; i < numOutputs; ++i) {
            recyclingOutputs.put(buffer.m_130267_(), buffer.readDouble());
        }
        return new ArcRecyclingRecipe(recipeId, () -> Minecraft.m_91087_().m_91403_().m_105148_(), recyclingOutputs, input, time, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, ArcFurnaceRecipe recipe) {
        PacketUtils.writeListReverse(buffer, recipe.output, FriendlyByteBuf::m_130055_);
        PacketUtils.writeList(buffer, recipe.secondaryOutputs, StackWithChance::write);
        recipe.input.write(buffer);
        PacketUtils.writeList(buffer, Arrays.asList(recipe.additives), IngredientWithSize::write);
        buffer.m_130055_(recipe.slag);
        buffer.writeInt(recipe.getTotalProcessTime());
        buffer.writeInt(recipe.getTotalProcessEnergy());
        buffer.writeBoolean(recipe instanceof ArcRecyclingRecipe);
        if (recipe instanceof ArcRecyclingRecipe) {
            ArcRecyclingRecipe recyclingRecipe = (ArcRecyclingRecipe)recipe;
            Map<ItemStack, Double> outputs = recyclingRecipe.getOutputs();
            buffer.m_130130_(outputs.size());
            for (Map.Entry<ItemStack, Double> e : outputs.entrySet()) {
                buffer.m_130055_(e.getKey());
                buffer.writeDouble(e.getValue().doubleValue());
            }
        }
    }
}

