/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class MineralMixSerializer
extends IERecipeSerializer<MineralMix> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.CRUSHER);
    }

    @Override
    public MineralMix readFromJson(ResourceLocation recipeId, JsonObject json) {
        JsonArray array = json.getAsJsonArray("ores");
        ArrayList<StackWithChance> tempOres = new ArrayList<StackWithChance>();
        float totalChance = 0.0f;
        for (int i = 0; i < array.size(); ++i) {
            JsonObject element = array.get(i).getAsJsonObject();
            if (!CraftingHelper.processConditions((JsonObject)element, (String)"conditions")) continue;
            ItemStack stack2 = MineralMixSerializer.readOutput(element.get("output"));
            float chance = GsonHelper.m_13915_((JsonObject)element, (String)"chance");
            totalChance += chance;
            tempOres.add(new StackWithChance(stack2, chance));
        }
        float finalTotalChance = totalChance;
        StackWithChance[] ores = (StackWithChance[])tempOres.stream().map(stack -> stack.recalculate(finalTotalChance)).toArray(StackWithChance[]::new);
        int weight = GsonHelper.m_13927_((JsonObject)json, (String)"weight");
        float failChance = GsonHelper.m_13820_((JsonObject)json, (String)"fail_chance", (float)0.0f);
        array = json.getAsJsonArray("dimensions");
        ArrayList<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
        for (int i = 0; i < array.size(); ++i) {
            dimensions.add(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(array.get(i).getAsString())));
        }
        ResourceLocation rl = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"sample_background", (String)"minecraft:stone"));
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(rl);
        if (b == Blocks.f_50016_) {
            b = Blocks.f_50069_;
        }
        return new MineralMix(recipeId, ores, weight, failChance, dimensions, b);
    }

    @Nullable
    public MineralMix fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int count = buffer.readInt();
        StackWithChance[] outputs = new StackWithChance[count];
        for (int i = 0; i < count; ++i) {
            outputs[i] = StackWithChance.read(buffer);
        }
        int weight = buffer.readInt();
        float failChance = buffer.readFloat();
        count = buffer.readInt();
        ArrayList<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
        for (int i = 0; i < count; ++i) {
            dimensions.add(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buffer.m_130281_()));
        }
        Block bg = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        return new MineralMix(recipeId, outputs, weight, failChance, dimensions, bg);
    }

    public void toNetwork(FriendlyByteBuf buffer, MineralMix recipe) {
        buffer.writeInt(recipe.outputs.length);
        for (StackWithChance secondaryOutput : recipe.outputs) {
            secondaryOutput.write(buffer);
        }
        buffer.writeInt(recipe.weight);
        buffer.writeFloat(recipe.failChance);
        buffer.writeInt(recipe.dimensions.size());
        for (ResourceKey dimension : recipe.dimensions) {
            buffer.m_130085_(dimension.m_135782_());
        }
        buffer.m_130085_(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)recipe.background));
    }
}

