/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MixerRecipe;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MixerRecipeSerializer
extends IERecipeSerializer<MixerRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.Multiblocks.MIXER);
    }

    @Override
    public MixerRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        FluidStack fluidOutput = ApiUtils.jsonDeserializeFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)"result"));
        FluidTagInput fluidInput = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fluid"));
        JsonArray inputs = json.getAsJsonArray("inputs");
        IngredientWithSize[] ingredients = new IngredientWithSize[inputs.size()];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = IngredientWithSize.deserialize(inputs.get(i));
        }
        int energy = GsonHelper.m_13927_((JsonObject)json, (String)"energy");
        return IEServerConfig.MACHINES.mixerConfig.apply(new MixerRecipe(recipeId, fluidOutput, fluidInput, ingredients, energy));
    }

    @Nullable
    public MixerRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        FluidStack fluidOutput = buffer.readFluidStack();
        FluidTagInput fluidInput = FluidTagInput.read(buffer);
        int ingredientCount = buffer.readInt();
        IngredientWithSize[] itemInputs = new IngredientWithSize[ingredientCount];
        for (int i = 0; i < ingredientCount; ++i) {
            itemInputs[i] = IngredientWithSize.read(buffer);
        }
        int energy = buffer.readInt();
        return new MixerRecipe(recipeId, fluidOutput, fluidInput, itemInputs, energy);
    }

    public void toNetwork(FriendlyByteBuf buffer, MixerRecipe recipe) {
        buffer.writeFluidStack(recipe.fluidOutput);
        recipe.fluidInput.write(buffer);
        buffer.writeInt(recipe.itemInputs.length);
        for (IngredientWithSize input : recipe.itemInputs) {
            input.write(buffer);
        }
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

