/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.common.entities.IEMinecartEntity;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.GenericDeferredWork;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraftforge.fluids.FluidStack;

public class IEMinecartItem
extends IEBaseItem {
    private final IEMinecartEntity.MinecartConstructor constructor;
    private static final DispenseItemBehavior MINECART_DISPENSER_BEHAVIOR = new DefaultDispenseItemBehavior(){
        private final DefaultDispenseItemBehavior behaviourDefaultDispenseItem = new DefaultDispenseItemBehavior();

        public ItemStack m_7498_(BlockSource source, ItemStack stack) {
            double d3;
            RailShape railshape;
            Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel world = source.m_7727_();
            double d0 = source.m_7096_() + (double)direction.m_122429_() * 1.125;
            double d1 = Math.floor(source.m_7098_()) + (double)direction.m_122430_();
            double d2 = source.m_7094_() + (double)direction.m_122431_() * 1.125;
            BlockPos blockpos = source.m_7961_().m_142300_(direction);
            BlockState blockstate = world.m_8055_(blockpos);
            RailShape railShape = railshape = blockstate.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)world, blockpos, null) : RailShape.NORTH_SOUTH;
            if (blockstate.m_60620_((Tag)BlockTags.f_13034_)) {
                d3 = railshape.m_61745_() ? 0.6 : 0.1;
            } else {
                if (!blockstate.m_60795_() || !world.m_8055_(blockpos.m_7495_()).m_60620_((Tag)BlockTags.f_13034_)) {
                    return this.behaviourDefaultDispenseItem.m_6115_(source, stack);
                }
                BlockState blockstate1 = world.m_8055_(blockpos.m_7495_());
                RailShape railshape1 = blockstate1.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate1.m_60734_()).getRailDirection(blockstate1, (BlockGetter)world, blockpos.m_7495_(), null) : RailShape.NORTH_SOUTH;
                d3 = direction != Direction.DOWN && railshape1.m_61745_() ? -0.4 : -0.9;
            }
            IEMinecartEntity<?> minecartEntity = ((IEMinecartItem)stack.m_41720_()).createCart((Level)world, d0, d1 + d3, d2, stack);
            if (stack.m_41788_()) {
                minecartEntity.m_6593_(stack.m_41786_());
            }
            minecartEntity.readTileFromItem(null, stack);
            world.m_7967_(minecartEntity);
            stack.m_41774_(1);
            return stack;
        }

        protected void m_6823_(BlockSource source) {
            source.m_7727_().m_46796_(1000, source.m_7961_(), 0);
        }
    };

    public IEMinecartItem(IEMinecartEntity.MinecartConstructor constructor) {
        super(new Item.Properties().m_41487_(1));
        this.constructor = constructor;
        GenericDeferredWork.registerDispenseBehavior((ItemLike)this, MINECART_DISPENSER_BEHAVIOR);
    }

    public final IEMinecartEntity<?> createCart(Level world, double x, double y, double z, ItemStack stack) {
        return this.constructor.make(world, x, y, z);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockpos;
        Level world = context.m_43725_();
        BlockState blockstate = world.m_8055_(blockpos = context.m_8083_());
        if (!blockstate.m_60620_((Tag)BlockTags.f_13034_)) {
            return InteractionResult.FAIL;
        }
        ItemStack itemstack = context.m_43722_();
        if (!world.f_46443_) {
            RailShape railshape = blockstate.m_60734_() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)world, blockpos, null) : RailShape.NORTH_SOUTH;
            double d0 = 0.0;
            if (railshape.m_61745_()) {
                d0 = 0.5;
            }
            IEMinecartEntity<?> minecartEntity = this.createCart(world, (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.0625 + d0, (double)blockpos.m_123343_() + 0.5, itemstack);
            if (itemstack.m_41788_()) {
                minecartEntity.m_6593_(itemstack.m_41786_());
            }
            minecartEntity.readTileFromItem((LivingEntity)context.m_43723_(), itemstack);
            world.m_7967_(minecartEntity);
        }
        itemstack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        FluidStack fs;
        super.m_7373_(stack, world, tooltip, advanced);
        if (ItemNBTHelper.hasKey(stack, "tank") && (fs = FluidStack.loadFluidStackFromNBT((CompoundTag)ItemNBTHelper.getTagCompound(stack, "tank"))) != null) {
            tooltip.add((Component)TextUtils.applyFormat((Component)new TranslatableComponent("desc.immersiveengineering.info.fluidStored", new Object[]{fs.getDisplayName(), fs.getAmount()}), ChatFormatting.GRAY));
        }
    }
}

