/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.network.MessageRequestEnergyUpdate;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class VoltmeterItem
extends IEBaseItem {
    public static RemoteEnergyData lastEnergyUpdate = new RemoteEnergyData(FastEither.left(BlockPos.f_121853_), 0L, false, 0, 0);

    public VoltmeterItem() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (WirecoilUtils.hasWireLink(stack)) {
            WireLink link = WireLink.readFromItem(stack);
            tooltip.add((Component)new TranslatableComponent("desc.immersiveengineering.info.attachedToDim", new Object[]{link.cp.getX(), link.cp.getY(), link.cp.getZ(), link.dimension.toString()}));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IEnergyStorage energyCap;
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = context.m_43722_();
        BlockEntity bEntity = world.m_7702_(pos);
        if (!(player != null && player.m_6144_() || bEntity == null || (energyCap = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)bEntity, CapabilityEnergy.ENERGY)) == null)) {
            int max = energyCap.getMaxEnergyStored();
            int stored = energyCap.getEnergyStored();
            if (max > 0) {
                ChatUtils.sendServerNoSpamMessages(player, new Component[]{new TranslatableComponent("chat.immersiveengineering.info.energyStorage", new Object[]{stored, max})});
            }
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.m_6144_() && bEntity instanceof IImmersiveConnectable) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            TargetingInfo targetingInfo = new TargetingInfo(context);
            BlockPos masterPos = ((IImmersiveConnectable)bEntity).getConnectionMaster(null, targetingInfo);
            BlockPos delta = pos.m_141950_((Vec3i)masterPos);
            ConnectionPoint cp = ((IImmersiveConnectable)bEntity).getTargetedPoint(targetingInfo, (Vec3i)delta);
            if (cp == null) {
                return InteractionResult.FAIL;
            }
            if (!WirecoilUtils.hasWireLink(stack)) {
                WireLink link = WireLink.create(cp, world, delta, targetingInfo);
                link.writeToItem(stack);
            } else {
                EnergyTransferHandler energyHandler;
                LocalWireNetwork netLink;
                GlobalWireNetwork global;
                LocalWireNetwork netHere;
                WireLink link = WireLink.readFromItem(stack);
                if (link.dimension.equals((Object)world.m_46472_()) && (netHere = (global = GlobalWireNetwork.getNetwork(world)).getNullableLocalNet(cp)) == (netLink = global.getNullableLocalNet(link.cp)) && netHere != null && (energyHandler = netHere.getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class)) != null) {
                    EnergyTransferHandler.Path energyPath = energyHandler.getPath(link.cp, cp);
                    double loss = energyPath != null ? energyPath.loss : 1.0;
                    player.m_6352_((Component)new TranslatableComponent("chat.immersiveengineering.info.averageLoss", new Object[]{Utils.formatDouble(loss * 100.0, "###.000")}), Util.f_137441_);
                }
                WirecoilUtils.clearWireLink(stack);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public record RemoteEnergyData(FastEither<BlockPos, Integer> pos, long measuredInTick, boolean isValid, int stored, int capacity) {
        public static RemoteEnergyData read(FriendlyByteBuf in) {
            int capacity;
            int stored;
            FastEither<BlockPos, Integer> pos = MessageRequestEnergyUpdate.readPos(in);
            long measuredInTick = in.m_130258_();
            boolean isValid = in.readBoolean();
            if (isValid) {
                stored = in.m_130242_();
                capacity = in.m_130242_();
            } else {
                capacity = 0;
                stored = 0;
            }
            return new RemoteEnergyData(pos, measuredInTick, isValid, stored, capacity);
        }

        public void write(FriendlyByteBuf out) {
            MessageRequestEnergyUpdate.writePos(out, this.pos);
            out.m_130103_(this.measuredInTick).writeBoolean(this.isValid);
            if (this.isValid) {
                out.m_130130_(this.stored).m_130130_(this.capacity);
            }
        }
    }
}

