/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;

public class WirecutterItem
extends IEBaseItem {
    public WirecutterItem() {
        super(new Item.Properties().m_41499_(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return (Integer)IEServerConfig.TOOLS.cutterDurabiliy.getOrDefault();
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.m_41777_();
        if (container.m_41629_(1, Utils.RAND, null)) {
            return ItemStack.f_41583_;
        }
        return container;
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean m_41465_() {
        return true;
    }

    public boolean m_8120_(@Nonnull ItemStack stack) {
        return true;
    }

    public int m_6473_() {
        return 14;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.f_44984_ || enchantment == Enchantments.f_44986_ || enchantment == Enchantments.f_44962_;
    }

    public boolean m_6813_(ItemStack itemstack, Level pLevel, BlockState state, BlockPos pPos, LivingEntity pEntityLiving) {
        boolean effective = state.m_60620_(IETags.wirecutterHarvestable);
        itemstack.m_41629_(1, Utils.RAND, null);
        return effective;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (this.isCorrectToolForDrops(stack, state)) {
            return 6.0f;
        }
        return super.m_8102_(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_60620_(IETags.wirecutterHarvestable);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockEntity tileEntity = world.m_7702_(pos);
        TargetingInfo target = new TargetingInfo(context.m_43719_(), (float)context.m_43720_().f_82479_, (float)context.m_43720_().f_82480_, (float)context.m_43720_().f_82481_);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (player != null && tileEntity instanceof IImmersiveConnectable) {
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(null, target);
            if (!((tileEntity = world.m_7702_(masterPos)) instanceof IImmersiveConnectable)) {
                return InteractionResult.PASS;
            }
            if (!world.f_46443_) {
                IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                GlobalWireNetwork net = GlobalWireNetwork.getNetwork(world);
                AtomicBoolean cut = new AtomicBoolean(false);
                net.removeAllConnectionsAt(nodeHere, conn -> {
                    ItemStack coil = conn.type.getWireCoil((Connection)conn);
                    world.m_7967_((Entity)new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), coil));
                    cut.set(true);
                });
                if (cut.get()) {
                    this.damageStack(stack, player, context.m_43724_());
                }
            }
        } else if (player != null) {
            return this.m_7203_(world, player, context.m_43724_()).m_19089_();
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        double reachDistance;
        Connection target;
        ItemStack stack = player.m_21120_(hand);
        if (!world.f_46443_ && (target = WireUtils.getTargetConnection(world, player, null, reachDistance = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_())) != null) {
            GlobalWireNetwork.getNetwork(world).removeAndDropConnection(target, player.m_142538_(), world);
            this.damageStack(stack, player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void damageStack(ItemStack stack, Player player, InteractionHand hand) {
        int nbtDamage = ItemNBTHelper.getInt(stack, "Damage") + 1;
        if (nbtDamage < (Integer)IEServerConfig.TOOLS.cutterDurabiliy.get()) {
            ItemNBTHelper.putInt(stack, "Damage", nbtDamage);
        } else {
            player.m_21190_(hand);
            player.m_21008_(hand, ItemStack.f_41583_);
        }
    }
}

