/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.network.IMessage;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageClientCommand
implements IMessage {
    private final Type type;

    public MessageClientCommand(Type type) {
        this.type = type;
    }

    public MessageClientCommand(FriendlyByteBuf buf) {
        this(Type.values()[buf.m_130242_()]);
    }

    public static void send(CommandContext<CommandSourceStack> context, Type type) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_81374_();
        ServerPlayer entity = source.m_81375_();
        ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new MessageClientCommand(type));
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130130_(this.type.ordinal());
    }

    @Override
    public void process(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(this.type.run);
    }

    public static enum Type {
        RESET_MANUAL(ImmersiveEngineering.proxy::resetManual),
        RESET_SHADER_CACHES(ImmersiveEngineering.proxy::clearRenderCaches);

        private final Runnable run;

        private Type(Runnable run) {
            this.run = run;
        }
    }
}

