/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.arcfurnace;

import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.crafting.ArcRecyclingRecipe;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIIngredientStackListBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ArcFurnaceRecipeCategory
extends IERecipeCategory<ArcFurnaceRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("immersiveengineering", "arcfurnace");
    public static final ResourceLocation UID_RECYCLING = new ResourceLocation("immersiveengineering", "arcfurnace_recycling");
    private IDrawableStatic arrow;

    public ArcFurnaceRecipeCategory(IGuiHelper helper, Class<? extends ArcFurnaceRecipe> recipeClass, ResourceLocation uid) {
        super(recipeClass, helper, uid, "block.immersiveengineering.arc_furnace");
        this.setBackground(helper.createBlankDrawable(148, 54));
        this.setIcon(helper.createDrawableIngredient((Object)new ItemStack(IEBlocks.Multiblocks.ARC_FURNACE)));
        this.arrow = helper.drawableBuilder(JEIHelper.JEI_GUI, 19, 4, 24, 18).setTextureSize(128, 128).build();
    }

    public static ArcFurnaceRecipeCategory getDefault(IGuiHelper helper) {
        return new ArcFurnaceRecipeCategory(helper, ArcFurnaceRecipe.class, UID);
    }

    public static ArcFurnaceRecipeCategory getRecycling(IGuiHelper helper) {
        ArcFurnaceRecipeCategory cat = new ArcFurnaceRecipeCategory(helper, ArcRecyclingRecipe.class, UID_RECYCLING);
        cat.title.m_130946_(" - Recycling");
        cat.setIcon((IDrawable)helper.drawableBuilder(new ResourceLocation("immersiveengineering", "textures/gui/recycle.png"), 0, 0, 16, 16).setTextureSize(16, 16).build());
        return cat;
    }

    public void setIngredients(ArcFurnaceRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, JEIIngredientStackListBuilder.make(recipe.input).add(recipe.additives).build());
        NonNullList<ItemStack> l = ListUtils.fromItems(recipe.output);
        if (recipe.slag == null) {
            System.out.println("ERROR ON RECIPE");
        } else if (!recipe.slag.m_41619_()) {
            l.add((Object)recipe.slag);
        }
        ingredients.setOutputs(VanillaTypes.ITEM, l);
    }

    private int getWidth(ArcFurnaceRecipe recipe) {
        int w = 86;
        if (recipe.getBaseOutputs().size() > 1) {
            w += 18;
        }
        if (recipe.secondaryOutputs.size() > 0) {
            w += 40;
        }
        return w;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ArcFurnaceRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int i = 0;
        int x = (148 - this.getWidth(recipe)) / 2;
        guiItemStacks.init(i, true, x + 8, 0);
        guiItemStacks.set(i++, Arrays.asList(recipe.input.getMatchingStacks()));
        for (int j = 0; j < recipe.additives.length; ++j) {
            guiItemStacks.init(i, true, x + j % 2 * 18, 18 + j / 2 * 18);
            guiItemStacks.set(i++, Arrays.asList(recipe.additives[j].getMatchingStacks()));
        }
        NonNullList<ItemStack> simulatedOutput = recipe.getBaseOutputs();
        int outputSize = simulatedOutput.size();
        for (int j = 0; j < outputSize; ++j) {
            guiItemStacks.init(i, false, x + 68 + j % 2 * 18, j / 2 * 18);
            guiItemStacks.set(i++, (ItemStack)simulatedOutput.get(j));
        }
        int xSecondary = x + (outputSize > 1 ? 106 : 88);
        for (int j = 0; j < recipe.secondaryOutputs.size(); ++j) {
            guiItemStacks.init(i, false, xSecondary, j * 18);
            guiItemStacks.set(i++, recipe.secondaryOutputs.get(j).stack());
        }
        if (!recipe.slag.m_41619_()) {
            guiItemStacks.init(i, false, x + 68, 36);
            guiItemStacks.set(i++, recipe.slag);
        }
    }

    public void draw(ArcFurnaceRecipe recipe, PoseStack transform, double mouseX, double mouseY) {
        int j;
        int x = (148 - this.getWidth(recipe)) / 2;
        this.arrow.draw(transform, x + 40, 10);
        JEIHelper.slotDrawable.draw(transform, x + 8, 0);
        for (j = 0; j < 4; ++j) {
            JEIHelper.slotDrawable.draw(transform, x + j % 2 * 18, 18 + j / 2 * 18);
        }
        for (j = 0; j < recipe.getBaseOutputs().size(); ++j) {
            JEIHelper.slotDrawable.draw(transform, x + 68 + j % 2 * 18, j / 2 * 18);
        }
        int xSecondary = x + (recipe.getBaseOutputs().size() > 1 ? 106 : 88);
        for (int j2 = 0; j2 < recipe.secondaryOutputs.size(); ++j2) {
            JEIHelper.slotDrawable.draw(transform, xSecondary, j2 * 18);
            ClientUtils.font().m_92883_(transform, Utils.formatDouble(recipe.secondaryOutputs.get(j2).chance() * 100.0f, "0.##") + "%", (float)(xSecondary + 20), (float)(j2 * 18 + 6), 0x777777);
        }
        JEIHelper.slotDrawable.draw(transform, x + 68, 36);
    }

    public List<Component> getTooltipStrings(ArcFurnaceRecipe recipe, double mouseX, double mouseY) {
        int x = (148 - this.getWidth(recipe)) / 2;
        if (mouseX >= (double)(x + 40) && mouseX <= (double)(x + 64) && mouseY >= 8.0 && mouseY <= 26.0) {
            float time = recipe.getTotalProcessTime();
            float energy = (float)recipe.getTotalProcessEnergy() / time;
            Utils.formatDouble(energy, "#.##");
            return Arrays.asList(new TranslatableComponent("desc.immersiveengineering.info.ift", new Object[]{Utils.formatDouble(energy, "#.##")}), new TranslatableComponent("desc.immersiveengineering.info.seconds", new Object[]{Utils.formatDouble(time / 20.0f, "#.##")}));
        }
        return super.getTooltipStrings((Object)recipe, mouseX, mouseY);
    }
}

