/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.blastfurnace;

import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIIngredientStackListBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class BlastFurnaceRecipeCategory
extends IERecipeCategory<BlastFurnaceRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("immersiveengineering", "blastfurnace");
    private final IDrawableAnimated flame;
    private final IDrawableAnimated arrow;

    public BlastFurnaceRecipeCategory(IGuiHelper helper) {
        super(BlastFurnaceRecipe.class, helper, UID, "gui.immersiveengineering.blastFurnace");
        ResourceLocation background = new ResourceLocation("immersiveengineering", "textures/gui/blast_furnace.png");
        this.setBackground(helper.createDrawable(background, 42, 9, 100, 64));
        this.setIcon(helper.createDrawableIngredient((Object)new ItemStack(IEBlocks.Multiblocks.BLAST_FURNACE)));
        this.flame = helper.drawableBuilder(background, 177, 0, 14, 14).buildAnimated(300, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = helper.drawableBuilder(background, 176, 14, 24, 17).buildAnimated(300, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setIngredients(BlastFurnaceRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, JEIIngredientStackListBuilder.make(recipe.input).build());
        ingredients.setOutputs(VanillaTypes.ITEM, ListUtils.fromItems(recipe.output, recipe.slag));
    }

    public void setRecipe(IRecipeLayout recipeLayout, BlastFurnaceRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 9, 7);
        guiItemStacks.init(1, false, 69, 7);
        guiItemStacks.init(2, false, 69, 43);
        guiItemStacks.set(0, Arrays.asList(recipe.input.getMatchingStacks()));
        guiItemStacks.set(1, recipe.output);
        guiItemStacks.set(2, recipe.slag);
    }

    public void draw(BlastFurnaceRecipe recipe, PoseStack poseStack, double mouseX, double mouseY) {
        this.flame.draw(poseStack, 12, 27);
        this.arrow.draw(poseStack, 33, 26);
    }
}

