/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.mixin.coremods;

import blusunrize.immersiveengineering.api.wires.IConnectionTemplate;
import blusunrize.immersiveengineering.common.wires.WireTemplateHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureTemplate.class})
public abstract class TemplateMixin
implements IConnectionTemplate {
    private final List<IConnectionTemplate.TemplateConnection> connections = new ArrayList<IConnectionTemplate.TemplateConnection>();

    @Inject(method={"fillFromWorld"}, at={@At(value="HEAD")})
    public void takeConnectionsFromWorld(Level worldIn, BlockPos startPos, Vec3i size, boolean p_163806_, Block p_163807_, CallbackInfo ci) {
        WireTemplateHelper.fillConnectionsInArea(worldIn, startPos, size, this);
    }

    @Inject(method={"placeInWorld"}, at={@At(value="RETURN")})
    public void addConnectionsToWorld(ServerLevelAccessor iworld, BlockPos startPos, BlockPos p_237146_3_, StructurePlaceSettings orientation, Random p_237146_5_, int p_237146_6_, CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValue() == Boolean.TRUE) {
            WireTemplateHelper.addConnectionsFromTemplate(iworld, this, orientation, startPos);
        }
    }

    @Inject(method={"save"}, at={@At(value="RETURN")})
    public void writeConnectionsToNBT(CompoundTag $, CallbackInfoReturnable<CompoundTag> cir) {
        WireTemplateHelper.addConnectionsToNBT(this, (CompoundTag)cir.getReturnValue());
    }

    @Inject(method={"load"}, at={@At(value="RETURN")})
    public void readConnectionsFromNBT(CompoundTag compound, CallbackInfo ci) {
        WireTemplateHelper.readConnectionsFromNBT(compound, this);
    }

    @Override
    public List<IConnectionTemplate.TemplateConnection> getStoredConnections() {
        return this.connections;
    }
}

