/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.SplitResult;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.GuiButtonManualLink;
import blusunrize.lib.manual.gui.ManualScreen;
import blusunrize.lib.manual.links.Link;
import blusunrize.lib.manual.utils.ManualLogger;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.RenderProperties;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class ManualUtils {
    public static final String THIS = "this";
    private static final Map<String, ResourceLocation> resourceMap = new HashMap<String, ResourceLocation>();

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof ResourceLocation) {
            return ManualUtils.isInTag(stack, (ResourceLocation)o);
        }
        if (o instanceof ItemStack) {
            if (!ItemStack.m_41746_((ItemStack)((ItemStack)o), (ItemStack)stack)) {
                return false;
            }
            if (((ItemStack)o).m_41782_()) {
                return ((ItemStack)o).m_41783_().equals((Object)stack.m_41783_());
            }
            return true;
        }
        return false;
    }

    public static boolean isInTag(ItemStack stack, ResourceLocation tag) {
        Tag itemTag = ItemTags.m_13193_().m_13404_(tag);
        if (itemTag != null && itemTag.m_8110_((Object)stack.m_41720_())) {
            return true;
        }
        Tag blockTag = BlockTags.m_13115_().m_13404_(tag);
        return blockTag != null && blockTag.m_8110_((Object)Block.m_49814_((Item)stack.m_41720_()));
    }

    public static boolean isNonemptyItemTag(ResourceLocation name) {
        return ManualUtils.isNonEmptyTag(ItemTags.m_13193_(), name);
    }

    public static boolean isNonemptyBlockTag(ResourceLocation name) {
        return ManualUtils.isNonEmptyTag(BlockTags.m_13115_(), name);
    }

    private static <T> boolean isNonEmptyTag(TagCollection<T> collection, ResourceLocation name) {
        Tag tag = collection.m_13404_(name);
        return tag != null && tag.m_6497_().size() > 0;
    }

    public static boolean isNonemptyBlockOrItemTag(ResourceLocation name) {
        return ManualUtils.isNonemptyBlockTag(name) || ManualUtils.isNonemptyItemTag(name);
    }

    public static String getTitleForNode(Tree.AbstractNode<ResourceLocation, ManualEntry> node, ManualInstance inst) {
        if (node.isLeaf()) {
            return inst.formatEntryName(node.getLeafData().getTitle());
        }
        return inst.formatCategoryName(node.getNodeData());
    }

    public static void drawTexturedRect(ResourceLocation texture, int x, int y, int w, int h, float ... uv) {
        ManualUtils.drawTexturedRect(RenderSystem.m_157191_(), texture, x, y, w, h, uv);
    }

    public static void drawTexturedRect(PoseStack transform, ResourceLocation texture, int x, int y, int w, int h, float ... uv) {
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        Matrix4f mat = transform.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(mat, (float)x, (float)(y + h), 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uv[0], uv[3]).m_5752_();
        buffer.m_85982_(mat, (float)(x + w), (float)(y + h), 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uv[1], uv[3]).m_5752_();
        buffer.m_85982_(mat, (float)(x + w), (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uv[1], uv[2]).m_5752_();
        buffer.m_85982_(mat, (float)x, (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(uv[0], uv[2]).m_5752_();
        buffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)buffer);
    }

    public static <T> List<T> getPrimitiveSpellingCorrections(String query, Iterable<T> valid, int maxDistance, Function<T, String> getTitle) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (T node : valid) {
            String s2 = getTitle.apply(node);
            if (s2 == null || s2.trim().isEmpty() || ManualUtils.getSpellingDistanceBetweenStrings(query, s2) >= maxDistance) continue;
            ret.add(node);
        }
        ret.sort(Comparator.comparingInt(s -> ManualUtils.getSpellingDistanceBetweenStrings(query, (String)getTitle.apply(s))));
        return ret;
    }

    public static int getSpellingDistanceBetweenStrings(String query, String target) {
        query = query.toLowerCase(Locale.ENGLISH);
        target = target.toLowerCase(Locale.ENGLISH);
        String[] queryWords = query.split(" ");
        String[] targetWords = target.split(" ");
        int distance = 0;
        for (int iWord = 0; iWord < queryWords.length; ++iWord) {
            if (iWord >= targetWords.length) {
                ++distance;
                continue;
            }
            int wordDistance = 0;
            for (int iChar = 0; iChar < queryWords[iWord].length(); ++iChar) {
                if (iChar >= targetWords[iWord].length()) {
                    ++distance;
                    continue;
                }
                if (queryWords[iWord].charAt(iChar) == targetWords[iWord].charAt(iChar)) continue;
                ++wordDistance;
                if (iChar <= 0 || queryWords[iWord].charAt(iChar - 1) != targetWords[iWord].charAt(iChar) || queryWords[iWord].charAt(iChar) != targetWords[iWord].charAt(iChar - 1)) continue;
                wordDistance -= 2;
            }
            if (wordDistance > 0) {
                wordDistance += Math.abs(targetWords[iWord].length() - queryWords[iWord].length());
            }
            distance += wordDistance;
        }
        return distance;
    }

    public static void addLinkButtons(ManualEntry entry, ManualInstance manual, ManualScreen gui, List<List<SplitResult.Token>> text, int x, int y, List<Button> pageButtons) {
        IdentityHashMap partButtons = new IdentityHashMap();
        MutableInt lineId = new MutableInt(0);
        for (List<SplitResult.Token> line : text) {
            MutableObject textUpToHere = new MutableObject((Object)"");
            for (SplitResult.Token token : line) {
                token.getContent().ifRight(arg_0 -> ManualUtils.lambda$addLinkButtons$2(manual, (Mutable)textUpToHere, lineId, entry, gui, x, y, partButtons, arg_0));
                textUpToHere.setValue((Object)((String)textUpToHere.getValue() + token.getText()));
            }
            lineId.increment();
        }
        for (List<SplitResult.Token> parts : partButtons.values()) {
            for (GuiButtonManualLink guiButtonManualLink : parts) {
                guiButtonManualLink.otherParts = parts;
                pageButtons.add(guiButtonManualLink);
            }
        }
    }

    public static String attemptStringTranslation(String tranlationKey, String arg) {
        String translated;
        String untranslated = String.format(tranlationKey, arg);
        if (!untranslated.equals(translated = I18n.m_118938_((String)untranslated, (Object[])new Object[0]))) {
            return translated;
        }
        return arg;
    }

    public static Tesselator tes() {
        return Tesselator.m_85913_();
    }

    public static Minecraft mc() {
        return Minecraft.m_91087_();
    }

    @Deprecated
    public static void bindTexture(ResourceLocation path) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)path);
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static ItemRenderer renderItem() {
        return ManualUtils.mc().m_91291_();
    }

    public static void drawSplitString(PoseStack transform, Font fontRenderer, List<String> text, int x, int y, int colour) {
        for (String s : text) {
            fontRenderer.m_92883_(transform, s, (float)x, (float)y, colour);
            Objects.requireNonNull(fontRenderer);
            y += 9;
        }
    }

    private static void parseSpecial(JsonObject obj, String anchor, ManualInstance instance, List<ManualEntry.SpecialElementData> out) {
        String type = GsonHelper.m_13906_((JsonObject)obj, (String)"type");
        int offset = GsonHelper.m_13824_((JsonObject)obj, (String)"offset", (int)0);
        ResourceLocation resLoc = ManualUtils.getLocationForManual(type, instance);
        try {
            Function<JsonObject, SpecialManualElement> createElement = instance.getElementFactory(resLoc);
            out.add(new ManualEntry.SpecialElementData(anchor, offset, () -> (SpecialManualElement)createElement.apply(obj)));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void parseSpecials(JsonObject data, ManualInstance instance, List<ManualEntry.SpecialElementData> out) {
        for (Map.Entry entry : data.entrySet()) {
            JsonElement currData = (JsonElement)entry.getValue();
            if (currData.isJsonObject()) {
                ManualUtils.parseSpecial(currData.getAsJsonObject(), (String)entry.getKey(), instance, out);
                continue;
            }
            for (JsonElement inner : currData.getAsJsonArray()) {
                ManualUtils.parseSpecial(inner.getAsJsonObject(), (String)entry.getKey(), instance, out);
            }
        }
    }

    public static ResourceLocation getLocationForManual(String s, ManualInstance instance) {
        if (s.indexOf(58) >= 0) {
            return new ResourceLocation(s);
        }
        return new ResourceLocation(instance.getDefaultResourceDomain(), s);
    }

    public static boolean isNumber(JsonObject main, String name) {
        return main.has(name) && main.get(name).isJsonPrimitive() && main.get(name).getAsJsonPrimitive().isNumber();
    }

    @Nullable
    public static PositionedItemStack parsePosItemStack(JsonElement ele) {
        JsonObject json = ele.getAsJsonObject();
        if (!ManualUtils.isNumber(json, "x")) {
            return null;
        }
        int x = GsonHelper.m_13927_((JsonObject)json, (String)"x");
        if (!ManualUtils.isNumber(json, "y")) {
            return null;
        }
        int y = GsonHelper.m_13927_((JsonObject)json, (String)"y");
        if (GsonHelper.m_13813_((JsonObject)json, (String)"item")) {
            return new PositionedItemStack(CraftingHelper.getItemStack((JsonObject)json, (boolean)true), x, y);
        }
        if (GsonHelper.m_13885_((JsonObject)json, (String)"stacks")) {
            JsonArray arr = json.getAsJsonArray("stacks");
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(arr.size());
            for (JsonElement stack : arr) {
                stacks.add(CraftingHelper.getItemStack((JsonObject)stack.getAsJsonObject(), (boolean)true));
            }
            return new PositionedItemStack(stacks, x, y);
        }
        try {
            return new PositionedItemStack(CraftingHelper.getIngredient((JsonElement)json), x, y);
        }
        catch (JsonSyntaxException xcp) {
            return null;
        }
    }

    public static ItemStack getItemStackFromJson(ManualInstance m, JsonElement jsonEle) {
        if (jsonEle.isJsonPrimitive()) {
            ResourceLocation itemName = ManualUtils.getLocationForManual(jsonEle.getAsString(), m);
            return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemName));
        }
        return CraftingHelper.getItemStack((JsonObject)jsonEle.getAsJsonObject(), (boolean)true);
    }

    public static Object getRecipeObjFromJson(ManualInstance m, JsonElement jsonEle) {
        if (jsonEle.isJsonObject()) {
            JsonObject json = jsonEle.getAsJsonObject();
            if (GsonHelper.m_13813_((JsonObject)json, (String)"recipe")) {
                return ManualUtils.getLocationForManual(GsonHelper.m_13906_((JsonObject)json, (String)"recipe"), m);
            }
            if (GsonHelper.m_13813_((JsonObject)json, (String)"orename")) {
                return json.get("orename").getAsString();
            }
            if (GsonHelper.m_13813_((JsonObject)json, (String)"item")) {
                return CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            }
        } else {
            if (jsonEle.isJsonArray()) {
                JsonArray json = jsonEle.getAsJsonArray();
                PositionedItemStack[] stacks = new PositionedItemStack[json.size()];
                for (int i = 0; i < json.size(); ++i) {
                    PositionedItemStack posStack = ManualUtils.parsePosItemStack(json.get(i));
                    if (posStack == null) {
                        throw new RuntimeException("Failed to load positional item stack from " + json.get(i));
                    }
                    stacks[i] = posStack;
                }
                return stacks;
            }
            if (jsonEle.isJsonPrimitive() && jsonEle.getAsJsonPrimitive().isString()) {
                return ManualUtils.getLocationForManual(jsonEle.getAsString(), m);
            }
        }
        throw new RuntimeException("Could not find recipe for " + jsonEle);
    }

    public static boolean listStack(String search, ItemStack stack) {
        return stack.m_41786_().getString().toLowerCase(Locale.ENGLISH).contains(search);
    }

    public static void renderItemStack(PoseStack transform, ItemStack stack, int x, int y, boolean overlay) {
        if (!stack.m_41619_()) {
            PoseStack modelViewStack = RenderSystem.m_157191_();
            modelViewStack.m_85836_();
            modelViewStack.m_166854_(transform.m_85850_().m_85861_());
            RenderSystem.m_157182_();
            ItemRenderer itemRenderer = ManualUtils.renderItem();
            itemRenderer.f_115093_ -= 50.0f;
            itemRenderer.m_115203_(stack, x, y);
            itemRenderer.f_115093_ += 50.0f;
            if (overlay) {
                Font font = RenderProperties.get((Item)stack.m_41720_()).getFont(stack);
                font = font != null ? font : Minecraft.m_91087_().f_91062_;
                itemRenderer.m_115174_(font, stack, x, y, null);
            }
            modelViewStack.m_85849_();
            RenderSystem.m_157182_();
        }
    }

    private static /* synthetic */ void lambda$addLinkButtons$2(ManualInstance manual, Mutable textUpToHere, MutableInt lineId, ManualEntry entry, ManualScreen gui, int x, int y, Map partButtons, SplitResult.LinkPart linkPart) {
        ManualInstance.ManualLink outputLink;
        int bx = manual.fontRenderer().m_92895_((String)textUpToHere.getValue());
        int n = lineId.intValue();
        Objects.requireNonNull(manual.fontRenderer());
        int by = n * 9;
        Link link = linkPart.getParent();
        String linkText = linkPart.getText();
        ResourceLocation bkey = link.getTarget(entry);
        int bw = manual.fontRenderer().m_92895_(linkText);
        ManualEntry bEntry = manual.getEntry(bkey);
        if (bEntry != null && bEntry.hasAnchor(link.getTargetAnchor())) {
            outputLink = new ManualInstance.ManualLink(bEntry, link.getTargetAnchor(), link.getTargetOffset());
        } else {
            if (bEntry == null) {
                ManualLogger.LOGGER.error("Unknown manual entry: {} (link from {})", (Object)bkey, (Object)entry.getLocation());
            } else if (!bEntry.hasAnchor(link.getTargetAnchor())) {
                ManualLogger.LOGGER.error("Unknown anchor {} in entry {} (link from {})", (Object)link.getTargetAnchor(), (Object)bkey, (Object)entry.getLocation());
            }
            outputLink = null;
        }
        Objects.requireNonNull(manual.fontRenderer());
        GuiButtonManualLink btn = new GuiButtonManualLink(gui, x + bx, y + by, bw, (int)(9.0 * 1.5), outputLink, linkText);
        partButtons.computeIfAbsent(link, l -> new ArrayList()).add(btn);
    }
}

