/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigForge;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfig;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class EntityConfig<T extends Entity>
extends ExtendedConfigForge<EntityConfig<T>, EntityType<T>> {
    @Nullable
    private ItemConfig spawnEggItemConfig;

    public EntityConfig(ModBase mod, String namedId, Function<EntityConfig<T>, EntityType.Builder<T>> elementConstructor) {
        this(mod, namedId, elementConstructor, null);
    }

    public EntityConfig(ModBase mod, String namedId, Function<EntityConfig<T>, EntityType.Builder<T>> elementConstructor, @Nullable BiFunction<EntityConfig<T>, EntityType<T>, ItemConfig> spawnEggItemConstructor) {
        super(mod, namedId, elementConstructor.andThen(builder -> builder.m_20712_(mod.getModId() + ":" + namedId)));
        if (spawnEggItemConstructor != null) {
            mod.getConfigHandler().addConfigurable(spawnEggItemConstructor.apply(this, (EntityType)this.getInstance()));
        }
    }

    public static <T extends Mob> BiFunction<EntityConfig<T>, EntityType<T>, ItemConfig> getDefaultSpawnEggItemConfigConstructor(ModBase mod, String itemName, int primaryColorIn, int secondaryColorIn) {
        return EntityConfig.getDefaultSpawnEggItemConfigConstructor(mod, itemName, primaryColorIn, secondaryColorIn, null);
    }

    public static <T extends Mob> BiFunction<EntityConfig<T>, EntityType<T>, ItemConfig> getDefaultSpawnEggItemConfigConstructor(ModBase mod, String itemName, int primaryColorIn, int secondaryColorIn, @Nullable Function<Item.Properties, Item.Properties> itemPropertiesModifier) {
        return (entityConfig, entityType) -> {
            Item.Properties itemProperties = new Item.Properties().m_41491_(mod.getDefaultItemGroup());
            if (itemPropertiesModifier != null) {
                itemProperties = (Item.Properties)itemPropertiesModifier.apply(itemProperties);
            }
            Item.Properties finalItemProperties = itemProperties;
            ItemConfig itemConfig = new ItemConfig(mod, itemName, (Function<ItemConfig, ? extends Item>)((Function<ItemConfig, Item>)itemConfigSub -> new ForgeSpawnEggItem(() -> entityType, primaryColorIn, secondaryColorIn, finalItemProperties)));
            entityConfig.setSpawnEggItemConfig(itemConfig);
            return itemConfig;
        };
    }

    @Override
    public String getTranslationKey() {
        return "entity." + this.getNamedId();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.ENTITY;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onRegistered() {
        super.onRegistered();
        EntityRenderers.m_174036_((EntityType)((EntityType)this.getInstance()), manager -> this.getRender(manager, Minecraft.m_91087_().m_91291_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract EntityRenderer<? super T> getRender(EntityRendererProvider.Context var1, ItemRenderer var2);

    @Override
    public IForgeRegistry<EntityType<?>> getRegistry() {
        return ForgeRegistries.ENTITIES;
    }

    @Nullable
    public ItemConfig getSpawnEggItemConfig() {
        return this.spawnEggItemConfig;
    }

    public void setSpawnEggItemConfig(@Nullable ItemConfig spawnEggItemConfig) {
        this.spawnEggItemConfig = spawnEggItemConfig;
    }
}

