/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class RecipeSerializerHelpers {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static Ingredient getJsonIngredient(JsonObject json, String key, boolean required) {
        JsonElement element = json.get(key);
        if (element == null) {
            if (required) {
                throw new JsonSyntaxException("Missing " + key + ", expected to find an ingredient object or string value");
            }
            return Ingredient.f_43901_;
        }
        if (element.isJsonObject()) {
            return Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)key));
        }
        if (element.isJsonArray()) {
            return Ingredient.m_43917_((JsonElement)GsonHelper.m_13933_((JsonObject)json, (String)key));
        }
        String itemName = GsonHelper.m_13906_((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = new ResourceLocation(itemName);
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Registry.f_122827_.m_6612_(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Item: " + itemName + " does not exist")))});
    }

    @Deprecated
    public static ItemStack getJsonItemStackOrTag(JsonObject json, boolean required) {
        return RecipeSerializerHelpers.getJsonItemStackOrTag(json, required, Collections.emptyList());
    }

    public static ItemStack getJsonItemStackOrTag(JsonObject json, boolean required, List<String> modPriorities) {
        if (json.has("tag")) {
            return RecipeSerializerHelpers.getJsonItemStackFromTag(json, "tag", modPriorities);
        }
        return RecipeSerializerHelpers.getJsonItemStack(json, "item", required);
    }

    public static ItemStack getJsonItemStack(JsonObject json, String key, boolean required) {
        JsonElement element = json.get(key);
        if (element == null) {
            if (required) {
                throw new JsonSyntaxException("Missing " + key + ", expected to find an item object or string value");
            }
            return ItemStack.f_41583_;
        }
        if (element.isJsonObject()) {
            return ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)key));
        }
        String itemName = GsonHelper.m_13906_((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = new ResourceLocation(itemName);
        return new ItemStack((ItemLike)Registry.f_122827_.m_6612_(resourcelocation).orElseThrow(() -> new JsonSyntaxException("Item: " + itemName + " does not exist")));
    }

    @Deprecated
    public static ItemStack getJsonItemStackFromTag(JsonObject json, String key) {
        return RecipeSerializerHelpers.getJsonItemStackFromTag(json, key, Collections.emptyList());
    }

    public static ItemStack getJsonItemStackFromTag(JsonObject json, String key, List<String> modPriorities) {
        ItemStack[] matchingStacks = Ingredient.m_43917_((JsonElement)json).m_43908_();
        HashMap modPriorityIndex = Maps.newHashMap();
        for (int i = 0; i < modPriorities.size(); ++i) {
            modPriorityIndex.put(modPriorities.get(i), i);
        }
        ItemStack outputStack = Arrays.stream(matchingStacks).min(Comparator.comparingInt(e -> modPriorityIndex.getOrDefault(e.m_41720_().getRegistryName().m_135827_(), Integer.MAX_VALUE))).orElseThrow(() -> new IllegalStateException("No tag value found for " + key + " does not exist")).m_41777_();
        int count = 1;
        if (json.has("count")) {
            count = json.get("count").getAsInt();
        }
        outputStack.m_41764_(count);
        return outputStack;
    }

    public static FluidStack deserializeFluidStack(JsonObject json, boolean readNbt) {
        if (json.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)"fluid");
        ResourceLocation resourcelocation = new ResourceLocation(fluidName);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourcelocation);
        if (fluid instanceof EmptyFluid) {
            throw new JsonParseException("Unknown fluid '" + fluidName + "'");
        }
        CompoundTag tag = null;
        if (readNbt && json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                tag = element.isJsonObject() ? TagParser.m_129359_((String)GSON.toJson(element)) : TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element, (String)"nbt"));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        int amount = 1000;
        if (json.has("amount")) {
            amount = GsonHelper.m_13927_((JsonObject)json, (String)"amount");
        }
        return new FluidStack(fluid, amount, tag);
    }

    public static FluidStack getJsonFluidStack(JsonObject json, String key, boolean required) {
        JsonElement element = json.get(key);
        if (element == null) {
            if (required) {
                throw new JsonSyntaxException("Missing " + key + ", expected to find a fluid object or string value");
            }
            return FluidStack.EMPTY;
        }
        if (element.isJsonObject()) {
            return RecipeSerializerHelpers.deserializeFluidStack(GsonHelper.m_13930_((JsonObject)json, (String)key), true);
        }
        String fluidName = GsonHelper.m_13906_((JsonObject)json, (String)key);
        ResourceLocation resourcelocation = new ResourceLocation(fluidName);
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(resourcelocation);
        if (fluid instanceof EmptyFluid) {
            throw new JsonParseException("Unknown fluid '" + fluidName + "'");
        }
        return new FluidStack(fluid, 1000);
    }
}

