/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;

public class DamageIndicatedItemComponent {
    public ItemFluidContainer item;

    public DamageIndicatedItemComponent(ItemFluidContainer item) {
        this.item = item;
    }

    public void fillItemGroup(CreativeModeTab itemGroup, NonNullList<ItemStack> items, Fluid fluid) {
        ItemStack itemStackFull = new ItemStack((ItemLike)this.item);
        IFluidHandlerItemCapacity fluidHanderFull = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity(itemStackFull).orElse(null);
        if (fluidHanderFull != null) {
            fluidHanderFull.fill(new FluidStack(fluid, fluidHanderFull.getCapacity()), IFluidHandler.FluidAction.EXECUTE);
        }
        items.add((Object)itemStackFull);
        ItemStack itemStackEmpty = new ItemStack((ItemLike)this.item);
        items.add((Object)itemStackEmpty);
    }

    public MutableComponent getInfo(ItemStack itemStack) {
        int amount = 0;
        IFluidHandlerItemCapacity fluidHander = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity(itemStack).orElse(null);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        if (!fluidStack.isEmpty()) {
            amount = fluidStack.getAmount();
        }
        return DamageIndicatedItemComponent.getInfo(fluidStack, amount, fluidHander == null ? 0 : fluidHander.getCapacity());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static MutableComponent getInfo(FluidStack fluidStack, int amount, int capacity) {
        TextComponent prefix = new TextComponent("");
        if (!fluidStack.isEmpty()) {
            prefix = new TranslatableComponent(fluidStack.getTranslationKey()).m_130946_(": ");
        }
        return prefix.m_130946_(String.format(Locale.ROOT, "%,d", amount)).m_130946_(" / ").m_130946_(String.format(Locale.ROOT, "%,d", capacity)).m_130946_(" mB");
    }

    public void addInformation(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)((IInformationProvider)itemStack.m_41720_()).getInfo(itemStack).m_6270_(Style.f_131099_.m_131140_(IInformationProvider.ITEM_PREFIX)));
    }

    public int getDurability(ItemStack itemStack) {
        IFluidHandlerItemCapacity fluidHander = (IFluidHandlerItemCapacity)FluidHelpers.getFluidHandlerItemCapacity(itemStack).orElse(null);
        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)itemStack).orElse(FluidStack.EMPTY);
        double capacity = fluidHander == null ? 0.0 : (double)fluidHander.getCapacity();
        double amount = FluidHelpers.getAmount(fluidStack);
        return (int)((capacity - amount) / capacity);
    }
}

