/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.capabilities;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;

public class CapabilityConstructorRegistry {
    private final Map<Class<? extends BlockEntity>, List<ICapabilityConstructor<?, ? extends BlockEntity, ? extends BlockEntity>>> capabilityConstructorsTile = Maps.newIdentityHashMap();
    private final Map<Class<? extends Entity>, List<ICapabilityConstructor<?, ? extends Entity, ? extends Entity>>> capabilityConstructorsEntity = Maps.newIdentityHashMap();
    private final Map<Class<? extends Item>, List<ICapabilityConstructor<?, ? extends Item, ? extends ItemStack>>> capabilityConstructorsItem = Maps.newIdentityHashMap();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> capabilityConstructorsTileSuper = Sets.newHashSet();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> capabilityConstructorsEntitySuper = Sets.newHashSet();
    private Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> capabilityConstructorsItemSuper = Sets.newHashSet();
    private final Map<Item, List<ICapabilityConstructor<?, ? extends Item, ? extends ItemStack>>> capabilityConstructorsItemInstance = Maps.newIdentityHashMap();
    private final List<Pair<Supplier<Item>, ICapabilityConstructor<?, ? extends Item, ? extends ItemStack>>> capabilityConstructorsItemInstancePending = Lists.newArrayList();
    protected final ModBase mod;
    protected boolean baked = false;
    protected boolean registeredTileEventListener = false;
    protected boolean registeredEntityEventListener = false;
    protected boolean registeredItemStackEventListener = false;

    public CapabilityConstructorRegistry(ModBase mod) {
        this.mod = mod;
    }

    protected ModBase getMod() {
        return this.mod;
    }

    protected void checkNotBaked() {
        if (this.baked) {
            throw new IllegalStateException("Please register capabilities before pre-init.");
        }
    }

    public <T extends BlockEntity> void registerTile(Class<T> clazz, ICapabilityConstructor<?, T, T> constructor) {
        this.checkNotBaked();
        ArrayList constructors = this.capabilityConstructorsTile.get(clazz);
        if (constructors == null) {
            constructors = Lists.newArrayList();
            this.capabilityConstructorsTile.put(clazz, constructors);
        }
        constructors.add(constructor);
        if (!this.registeredTileEventListener) {
            this.registeredTileEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new TileEventListener());
        }
    }

    public <T extends Entity> void registerEntity(Class<T> clazz, ICapabilityConstructor<?, T, T> constructor) {
        this.checkNotBaked();
        ArrayList constructors = this.capabilityConstructorsEntity.get(clazz);
        if (constructors == null) {
            constructors = Lists.newArrayList();
            this.capabilityConstructorsEntity.put(clazz, constructors);
        }
        constructors.add(constructor);
        if (!this.registeredEntityEventListener) {
            this.registeredEntityEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new EntityEventListener());
        }
    }

    public <T extends Item> void registerItem(Class<T> clazz, ICapabilityConstructor<?, T, ItemStack> constructor) {
        this.checkNotBaked();
        ArrayList constructors = this.capabilityConstructorsItem.get(clazz);
        if (constructors == null) {
            constructors = Lists.newArrayList();
            this.capabilityConstructorsItem.put(clazz, constructors);
        }
        constructors.add(constructor);
        if (!this.registeredItemStackEventListener) {
            this.registeredItemStackEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new ItemStackEventListener());
        }
    }

    public <K, V> void registerInheritableTile(Class<K> clazz, ICapabilityConstructor<?, V, V> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsTileSuper.add(Pair.of(clazz, constructor));
        if (!this.registeredTileEventListener) {
            this.registeredTileEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new TileEventListener());
        }
    }

    public <K, V> void registerInheritableEntity(Class<K> clazz, ICapabilityConstructor<?, V, V> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsEntitySuper.add(Pair.of(clazz, constructor));
        if (!this.registeredEntityEventListener) {
            this.registeredEntityEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new EntityEventListener());
        }
    }

    public <T> void registerInheritableItem(Class<T> clazz, ICapabilityConstructor<?, ?, ? extends ItemStack> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsItemSuper.add(Pair.of(clazz, constructor));
        if (!this.registeredItemStackEventListener) {
            this.registeredItemStackEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new ItemStackEventListener());
        }
    }

    public <T extends Item> void registerItem(Supplier<T> itemSupplier, ICapabilityConstructor<?, T, ItemStack> constructor) {
        this.checkNotBaked();
        this.capabilityConstructorsItemInstancePending.add(Pair.of(itemSupplier, constructor));
        if (!this.registeredItemStackEventListener) {
            this.registeredItemStackEventListener = true;
            MinecraftForge.EVENT_BUS.register((Object)new ItemStackEventListener());
        }
    }

    protected void registerItemsEffective() {
        for (Pair<Supplier<Item>, ICapabilityConstructor<?, ? extends Item, ? extends ItemStack>> pair : this.capabilityConstructorsItemInstancePending) {
            this.registerItemEffective((Supplier)pair.getLeft(), (ICapabilityConstructor)pair.getRight());
        }
        this.capabilityConstructorsItemInstancePending.clear();
    }

    protected <T extends Item> void registerItemEffective(Supplier<T> itemSupplier, ICapabilityConstructor<?, T, ItemStack> constructor) {
        Item item = Objects.requireNonNull((Item)itemSupplier.get(), "Tried to register an item capability for a null item with constructor for " + constructor.getCapability().getName());
        ArrayList constructors = this.capabilityConstructorsItemInstance.get(item);
        if (constructors == null) {
            constructors = Lists.newArrayList();
            this.capabilityConstructorsItemInstance.put(item, constructors);
        }
        constructors.add(constructor);
    }

    protected <K, KE, H, HE> ICapabilityProvider createProvider(KE hostType, HE host, ICapabilityConstructor<?, K, H> capabilityConstructor) {
        return capabilityConstructor.createProvider(hostType, host);
    }

    protected <T> void onLoad(Map<Class<? extends T>, List<ICapabilityConstructor<?, ? extends T, ? extends T>>> allConstructors, Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> allInheritableConstructors, @Nullable Map<? extends T, List<ICapabilityConstructor<?, ? extends T, ? extends T>>> allInstanceConstructors, T object, AttachCapabilitiesEvent<?> event, Class<? extends T> baseClass) {
        this.onLoad(allConstructors, allInheritableConstructors, allInstanceConstructors, object, object, event, baseClass);
    }

    protected <K, V> void onLoad(Map<Class<? extends K>, List<ICapabilityConstructor<?, ? extends K, ? extends V>>> allConstructors, Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> allInheritableConstructors, @Nullable Map<? extends K, List<ICapabilityConstructor<?, ? extends K, ? extends V>>> allInstanceConstructors, K keyObject, V valueObject, AttachCapabilitiesEvent<?> event, Class<? extends K> baseClass) {
        Collection instanceConstructors;
        Collection constructors;
        boolean initialized;
        boolean bl = initialized = this.baked || MinecraftHelpers.isMinecraftInitialized();
        if (!this.baked && MinecraftHelpers.isMinecraftInitialized()) {
            this.bake();
        }
        if ((constructors = (Collection)allConstructors.get(keyObject.getClass())) != null) {
            for (ICapabilityConstructor iCapabilityConstructor : constructors) {
                if (!initialized && iCapabilityConstructor.getCapability() == null) continue;
                this.addLoadedCapabilityProvider(event, keyObject, valueObject, iCapabilityConstructor);
            }
        }
        for (Pair pair : allInheritableConstructors) {
            if (!initialized && ((ICapabilityConstructor)pair.getRight()).getCapability() == null || keyObject != baseClass && pair.getLeft() != keyObject && !((Class)pair.getLeft()).isInstance(keyObject)) continue;
            this.addLoadedCapabilityProvider(event, keyObject, valueObject, (ICapabilityConstructor)pair.getRight());
        }
        if (allInstanceConstructors != null && (instanceConstructors = (Collection)allInstanceConstructors.get(keyObject)) != null) {
            for (ICapabilityConstructor constructor : instanceConstructors) {
                if (!initialized && constructor.getCapability() == null) continue;
                this.addLoadedCapabilityProvider(event, keyObject, valueObject, constructor);
            }
        }
    }

    protected <K, V> void addLoadedCapabilityProvider(AttachCapabilitiesEvent<?> event, K keyObject, V valueObject, ICapabilityConstructor<?, ?, ?> constructor) {
        ICapabilityProvider provider = this.createProvider(keyObject, valueObject, constructor);
        if (provider != null) {
            ResourceLocation id = new ResourceLocation(this.getMod().getModId(), constructor.getCapability().getName().toLowerCase(Locale.ENGLISH));
            if (!event.getCapabilities().containsKey(id)) {
                event.addCapability(id, provider);
            } else {
                this.getMod().getLoggerHelper().log(Level.DEBUG, "Duplicate capability registration of " + id + " in " + keyObject);
            }
        }
    }

    protected <K, V> void removeNullCapabilities(Map<Class<? extends K>, List<ICapabilityConstructor<?, ? extends K, ? extends V>>> allConstructors, Collection<Pair<Class<?>, ICapabilityConstructor<?, ?, ?>>> allInheritableConstructors, @Nullable Map<? extends K, List<ICapabilityConstructor<?, ? extends K, ? extends V>>> allInstanceConstructors) {
        HashMultimap toRemoveMap = HashMultimap.create();
        for (Class<K> clazz : allConstructors.keySet()) {
            Collection collection = allConstructors.get(clazz);
            for (ICapabilityConstructor iCapabilityConstructor : collection) {
                if (iCapabilityConstructor.getCapability() != null) continue;
                toRemoveMap.put(clazz, (Object)iCapabilityConstructor);
            }
        }
        for (Map.Entry entry : toRemoveMap.entries()) {
            List<ICapabilityConstructor<?, K, V>> list = allConstructors.get(entry.getKey());
            list.remove(entry.getValue());
        }
        ArrayList toRemoveInheritableList = Lists.newArrayList();
        for (Pair<Class<?>, ICapabilityConstructor<?, ?, ?>> pair : allInheritableConstructors) {
            if (((ICapabilityConstructor)pair.getRight()).getCapability() != null) continue;
            toRemoveInheritableList.add(pair);
        }
        for (Pair pair : toRemoveInheritableList) {
            allInheritableConstructors.remove(pair);
        }
        if (allInstanceConstructors != null) {
            HashMultimap hashMultimap = HashMultimap.create();
            for (K key : allInstanceConstructors.keySet()) {
                Collection collection = allInstanceConstructors.get(key);
                for (ICapabilityConstructor iCapabilityConstructor : collection) {
                    if (iCapabilityConstructor.getCapability() != null) continue;
                    hashMultimap.put(key, (Object)iCapabilityConstructor);
                }
            }
            for (Map.Entry entry : hashMultimap.entries()) {
                List<ICapabilityConstructor<?, K, V>> list = allInstanceConstructors.get(entry.getKey());
                list.remove(entry.getValue());
            }
        }
    }

    public void bake() {
        this.baked = true;
        this.registerItemsEffective();
        this.removeNullCapabilities(this.capabilityConstructorsTile, this.capabilityConstructorsTileSuper, null);
        this.removeNullCapabilities(this.capabilityConstructorsEntity, this.capabilityConstructorsEntitySuper, null);
        this.removeNullCapabilities(this.capabilityConstructorsItem, this.capabilityConstructorsItemSuper, this.capabilityConstructorsItemInstance);
        this.capabilityConstructorsTileSuper = ImmutableList.copyOf(this.capabilityConstructorsTileSuper);
        this.capabilityConstructorsEntitySuper = ImmutableList.copyOf(this.capabilityConstructorsEntitySuper);
        this.capabilityConstructorsItemSuper = ImmutableList.copyOf(this.capabilityConstructorsItemSuper);
    }

    public class TileEventListener {
        @SubscribeEvent
        public void onTileLoad(AttachCapabilitiesEvent<BlockEntity> event) {
            CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsTile, CapabilityConstructorRegistry.this.capabilityConstructorsTileSuper, null, (BlockEntity)event.getObject(), event, BlockEntity.class);
        }
    }

    public class EntityEventListener {
        @SubscribeEvent
        public void onEntityLoad(AttachCapabilitiesEvent<Entity> event) {
            CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsEntity, CapabilityConstructorRegistry.this.capabilityConstructorsEntitySuper, null, (Entity)event.getObject(), event, Entity.class);
        }
    }

    public class ItemStackEventListener {
        @SubscribeEvent
        public void onItemStackLoad(AttachCapabilitiesEvent<ItemStack> event) {
            if (!((ItemStack)event.getObject()).m_41619_()) {
                CapabilityConstructorRegistry.this.onLoad(CapabilityConstructorRegistry.this.capabilityConstructorsItem, CapabilityConstructorRegistry.this.capabilityConstructorsItemSuper, CapabilityConstructorRegistry.this.capabilityConstructorsItemInstance, ((ItemStack)event.getObject()).m_41720_(), (ItemStack)event.getObject(), event, Item.class);
            }
        }
    }
}

