/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.xptome;

import bl4ckscor3.mod.xptome.Configuration;
import bl4ckscor3.mod.xptome.openmods.utils.EnchantmentUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;

public class XPTomeItem
extends Item {
    public static final Style TOOLTIP_STYLE = Style.f_131099_.m_131157_(ChatFormatting.GRAY);
    private static final Component TOOLTIP_1 = new TranslatableComponent("xpbook.tooltip.1").m_6270_(TOOLTIP_STYLE);
    private static final Component TOOLTIP_2 = new TranslatableComponent("xpbook.tooltip.2").m_6270_(TOOLTIP_STYLE);

    public XPTomeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int storedXP = this.getStoredXP(stack);
        if (stack.m_41613_() > 1) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_6144_() && storedXP < (Integer)Configuration.CONFIG.maxXP.get()) {
            int xpToStore = 0;
            if (((Boolean)Configuration.CONFIG.storeUntilPreviousLevel.get()).booleanValue()) {
                int xpForCurrentLevel = EnchantmentUtils.getExperienceForLevel(player.f_36078_);
                xpToStore = EnchantmentUtils.getPlayerXP(player) - xpForCurrentLevel;
                if (xpToStore == 0 && player.f_36078_ > 0) {
                    xpToStore = xpForCurrentLevel - EnchantmentUtils.getExperienceForLevel(player.f_36078_ - 1);
                }
            } else {
                xpToStore = EnchantmentUtils.getPlayerXP(player);
            }
            if (xpToStore == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            int actuallyStored = this.addXP(stack, xpToStore);
            if (actuallyStored > 0) {
                int previousLevel = player.f_36078_;
                MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.XpChange(player, -actuallyStored));
                EnchantmentUtils.addPlayerXP(player, -actuallyStored);
                if (previousLevel != player.f_36078_) {
                    MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.LevelChange(player, player.f_36078_));
                }
            }
            if (!world.f_46443_) {
                world.m_5594_(null, player.m_142538_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, (world.f_46441_.nextFloat() - world.f_46441_.nextFloat()) * 0.35f + 0.9f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!player.m_6144_() && storedXP > 0) {
            if (((Boolean)Configuration.CONFIG.retriveUntilNextLevel.get()).booleanValue()) {
                int xpForPlayer = EnchantmentUtils.getExperienceForLevel(player.f_36078_ + 1) - EnchantmentUtils.getPlayerXP(player);
                int xpToRetrieve = (int)Math.floor((double)xpForPlayer / (Double)Configuration.CONFIG.retrievalPercentage.get());
                int actuallyRemoved = this.removeXP(stack, xpToRetrieve);
                if (actuallyRemoved < xpForPlayer) {
                    xpForPlayer = (int)Math.floor((double)actuallyRemoved * (Double)Configuration.CONFIG.retrievalPercentage.get());
                }
                this.addOrSpawnXPForPlayer(player, xpForPlayer);
            } else {
                this.addOrSpawnXPForPlayer(player, (int)Math.ceil((double)storedXP * (Double)Configuration.CONFIG.retrievalPercentage.get()));
                this.setStoredXP(stack, 0);
            }
            if (!world.f_46443_ && !((Boolean)Configuration.CONFIG.retrieveXPOrbs.get()).booleanValue()) {
                float pitchMultiplier = player.f_36078_ > 30 ? 1.0f : (float)player.f_36078_ / 30.0f;
                world.m_5594_(null, player.m_142538_(), SoundEvents.f_12275_, SoundSource.PLAYERS, pitchMultiplier * 0.75f, 1.0f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    private void addOrSpawnXPForPlayer(Player player, int amount) {
        if (((Boolean)Configuration.CONFIG.retrieveXPOrbs.get()).booleanValue()) {
            if (!player.f_19853_.f_46443_) {
                player.f_19853_.m_7967_((Entity)new ExperienceOrb(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), amount));
            }
        } else {
            int previousLevel = player.f_36078_;
            MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.XpChange(player, amount));
            EnchantmentUtils.addPlayerXP(player, amount);
            if (previousLevel != player.f_36078_) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerXpEvent.LevelChange(player, player.f_36078_));
            }
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return (int)Math.max(0.0, 13.0 * ((double)this.getStoredXP(stack) / (double)((Integer)Configuration.CONFIG.maxXP.get()).intValue()));
    }

    public int m_142159_(ItemStack stack) {
        float maxXP = ((Integer)Configuration.CONFIG.maxXP.get()).intValue();
        float f = Math.max(0.0f, (float)this.getStoredXP(stack) / maxXP);
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public boolean m_5812_(ItemStack stack) {
        return this.getStoredXP(stack) > 0;
    }

    public boolean m_41465_() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(TOOLTIP_1);
        tooltip.add(TOOLTIP_2);
        tooltip.add((Component)new TranslatableComponent("xpbook.tooltip.3", new Object[]{this.getStoredXP(stack), Configuration.CONFIG.maxXP.get()}).m_6270_(TOOLTIP_STYLE));
    }

    public int addXP(ItemStack stack, int amount) {
        int maxStorage;
        if (amount <= 0) {
            return 0;
        }
        int stored = this.getStoredXP(stack);
        if (stored >= (maxStorage = ((Integer)Configuration.CONFIG.maxXP.get()).intValue())) {
            return 0;
        }
        if (stored + amount <= maxStorage) {
            this.setStoredXP(stack, stored + amount);
            return amount;
        }
        this.setStoredXP(stack, maxStorage);
        return maxStorage - stored;
    }

    public int removeXP(ItemStack stack, int amount) {
        if (amount <= 0) {
            return 0;
        }
        int stored = this.getStoredXP(stack);
        if (stored <= 0) {
            return 0;
        }
        if (stored >= amount) {
            this.setStoredXP(stack, stored - amount);
            return amount;
        }
        this.setStoredXP(stack, 0);
        return stored;
    }

    public void setStoredXP(ItemStack stack, int amount) {
        stack.m_41784_().m_128405_("xp", amount);
    }

    public int getStoredXP(ItemStack stack) {
        return stack.m_41784_().m_128451_("xp");
    }
}

