/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.ftbchunks.client;

import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftbteams.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import frankv.jmi.JMI;
import frankv.jmi.JMIOverlayHelper;
import frankv.jmi.ftbchunks.client.ClaimingMode;
import frankv.jmi.ftbchunks.client.FTBClaimedChunkData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.PolygonOverlay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClaimedChunkPolygon {
    private IClientAPI jmAPI;
    private static final Minecraft mc = Minecraft.m_91087_();
    public static HashMap<ChunkDimPos, PolygonOverlay> chunkOverlays = new HashMap();
    public static HashMap<ChunkDimPos, FTBClaimedChunkData> chunkData = new HashMap();
    public static HashMap<ChunkDimPos, PolygonOverlay> forceLoadedOverlays = new HashMap();
    public static List<FTBClaimedChunkData> queue = new LinkedList<FTBClaimedChunkData>();

    public ClaimedChunkPolygon(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::onTeamPropsChanged);
    }

    public static String getPolygonTitleByPlayerPos() {
        if (ClaimedChunkPolygon.mc.f_91074_ == null) {
            return "";
        }
        ChunkDimPos pos = new ChunkDimPos(ClaimedChunkPolygon.mc.f_91074_.f_19853_.m_46472_(), ClaimedChunkPolygon.mc.f_91074_.m_146902_().f_45578_, ClaimedChunkPolygon.mc.f_91074_.m_146902_().f_45579_);
        if (!chunkOverlays.containsKey(pos)) {
            return "Wilderness";
        }
        return chunkOverlays.get(pos).getTitle();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!JMI.CLIENT_CONFIG.getFtbChunks()) {
            return;
        }
        if (ClaimedChunkPolygon.mc.f_91073_ == null) {
            return;
        }
        for (int i = 0; i < 200; ++i) {
            if (queue == null || queue.isEmpty()) {
                return;
            }
            ResourceKey playerDim = ClaimedChunkPolygon.mc.f_91073_.m_46472_();
            FTBClaimedChunkData data = queue.get(0);
            if (data.team == null) {
                this.removeChunk(data, (ResourceKey<Level>)playerDim);
            } else if (ClaimedChunkPolygon.shouldReplace(data)) {
                this.replaceChunk(data, (ResourceKey<Level>)playerDim);
            } else {
                this.addChunk(data, (ResourceKey<Level>)playerDim);
            }
            queue.remove(0);
        }
    }

    public void createPolygonsOnMappingStarted() {
        ClientLevel level = ClaimedChunkPolygon.mc.f_91073_;
        if (level == null) {
            return;
        }
        for (FTBClaimedChunkData data : chunkData.values()) {
            if (!data.chunkDimPos.dimension.equals((Object)level.m_46472_()) || !JMIOverlayHelper.createPolygon(data.overlay)) continue;
            chunkOverlays.put(data.chunkDimPos, data.overlay);
        }
    }

    private void addChunk(FTBClaimedChunkData data, ResourceKey<Level> dim) {
        ChunkDimPos pos = data.chunkDimPos;
        if (chunkOverlays.containsKey(pos)) {
            return;
        }
        chunkData.put(pos, data);
        if (!pos.dimension.equals(dim)) {
            return;
        }
        if (JMIOverlayHelper.createPolygon(data.overlay)) {
            chunkOverlays.put(data.chunkDimPos, data.overlay);
        }
    }

    private void removeChunk(FTBClaimedChunkData data, ResourceKey<Level> dim) {
        ChunkDimPos pos = data.chunkDimPos;
        if (!chunkOverlays.containsKey(pos)) {
            return;
        }
        chunkData.remove(pos);
        if (!pos.dimension.equals(dim)) {
            return;
        }
        try {
            this.jmAPI.remove((Displayable)chunkOverlays.get(pos));
            chunkOverlays.remove(pos);
        }
        catch (Throwable t) {
            JMI.LOGGER.error(t.getMessage(), t);
        }
    }

    private void replaceChunk(FTBClaimedChunkData data, ResourceKey<Level> dim) {
        this.removeChunk(data, dim);
        this.addChunk(data, dim);
        if (ClaimingMode.activated) {
            this.showForceLoaded(data.chunkDimPos, false);
            this.showForceLoaded(data.chunkDimPos, true);
        }
    }

    public void showForceLoadedByArea(boolean show) {
        ClientLevel level = ClaimedChunkPolygon.mc.f_91073_;
        if (level == null) {
            return;
        }
        if (!show) {
            for (ChunkDimPos pos : forceLoadedOverlays.keySet()) {
                chunkOverlays.get(pos).setTitle(ClaimedChunkPolygon.chunkData.get((Object)pos).team.getDisplayName());
            }
            JMIOverlayHelper.removePolygons(forceLoadedOverlays.values());
            forceLoadedOverlays.clear();
            return;
        }
        for (ChunkPos p : ClaimingMode.area) {
            ChunkDimPos chunkDimPos = new ChunkDimPos(level.m_46472_(), p.f_45578_, p.f_45579_);
            this.showForceLoaded(chunkDimPos, true);
        }
    }

    private void showForceLoaded(ChunkDimPos chunkDimPos, boolean show) {
        if (!chunkData.containsKey(chunkDimPos)) {
            return;
        }
        FTBClaimedChunkData data = chunkData.get(chunkDimPos);
        String teamName = data.team.getDisplayName();
        if (show && data.forceLoaded && !forceLoadedOverlays.containsKey(chunkDimPos)) {
            PolygonOverlay claimedOverlay = ClaimingMode.forceLoadedPolygon(chunkDimPos);
            if (JMIOverlayHelper.createPolygon(claimedOverlay)) {
                forceLoadedOverlays.put(chunkDimPos, claimedOverlay);
            }
            chunkOverlays.get(chunkDimPos).setTitle(teamName + "\nForce Loaded");
        } else if (!show && forceLoadedOverlays.containsKey(chunkDimPos)) {
            this.jmAPI.remove((Displayable)forceLoadedOverlays.get(chunkDimPos));
            forceLoadedOverlays.remove(chunkDimPos);
            chunkOverlays.get(chunkDimPos).setTitle(teamName);
        }
    }

    public void onTeamPropsChanged(ClientTeamPropertiesChangedEvent event) {
        UUID teamId = event.getTeam().getId();
        ResourceKey dim = ClaimedChunkPolygon.mc.f_91073_.m_46472_();
        for (FTBClaimedChunkData data : new HashSet<FTBClaimedChunkData>(chunkData.values())) {
            if (!data.teamId.equals(teamId)) continue;
            data.updateOverlayProps();
            this.replaceChunk(data, (ResourceKey<Level>)dim);
        }
    }

    public static void addToQueue(MapDimension dim, SendChunkPacket.SingleChunk chunk, UUID teamId) {
        if (!JMI.ftbchunks) {
            return;
        }
        queue.add(new FTBClaimedChunkData(dim, chunk, teamId));
    }

    private static boolean shouldReplace(FTBClaimedChunkData data) {
        if (data.team == null) {
            return false;
        }
        FTBClaimedChunkData that = chunkData.get(data.chunkDimPos);
        if (that == null) {
            return false;
        }
        return !data.equals(that);
    }
}

