/*
 * Decompiled with CFR 0.152.
 */
package frankv.jmi.jmdefaultconfig;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import frankv.jmi.JMI;
import frankv.jmi.jmdefaultconfig.Version;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.FileUtils;

public class FileManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File versionFile = new File(System.getProperty("user.dir") + "/journeymap/defaultconfig.json");

    public static Version readConfigVersion() {
        Version version;
        try (FileReader fileReader = new FileReader(versionFile);){
            version = (Version)GSON.fromJson((Reader)fileReader, Version.class);
            if (version == null) {
                throw new NullPointerException();
            }
        }
        catch (JsonParseException | IOException | NullPointerException e) {
            version = new Version(-1);
            versionFile.getParentFile().mkdirs();
        }
        return version;
    }

    private static void updateVersionFile(int newVersion) throws IOException {
        Version v = new Version(newVersion);
        FileWriter fileWriter = new FileWriter(versionFile);
        GSON.toJson((Object)v, (Appendable)fileWriter);
        fileWriter.flush();
        fileWriter.close();
    }

    public static void writeJMDefaultConfig(int newVersion) {
        File source = new File(System.getProperty("user.dir") + "/config/jmdefaultconfig");
        File dest = new File(System.getProperty("user.dir") + "/journeymap/");
        if (!source.exists() || !source.isDirectory()) {
            JMI.LOGGER.warn("No default config found.");
            return;
        }
        JMI.LOGGER.info("Writing default configs for Journeymap...");
        try {
            FileManager.updateVersionFile(newVersion);
            FileUtils.copyDirectory((File)source, (File)dest);
            JMI.LOGGER.info("Journeymap configs updated.");
        }
        catch (IOException e) {
            JMI.LOGGER.error("Failed to write default configs " + e);
        }
    }
}

