/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.gen.ModFeatures;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.ICustomRenderType;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockAncientSapling
extends BushBlock
implements BonemealableBlock,
IModItem,
ICustomBlockState,
ICustomItemModel,
ICustomRenderType {
    protected static final VoxelShape SHAPE = BlockAncientSapling.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);

    public BlockAncientSapling() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60978_(0.0f).m_60918_(SoundType.f_56740_));
        ModRegistry.add(this);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (!level.f_46443_) {
            super.m_7455_(state, level, pos, random);
            if (level.m_7146_(pos.m_7494_()) >= 9 && random.nextInt(7) == 0) {
                this.m_7719_(level, random, pos, state);
            }
        }
    }

    @Override
    public String getBaseName() {
        return "ancient_sapling";
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SaplingBlock.f_55973_});
    }

    public boolean m_7370_(BlockGetter p_50897_, BlockPos p_50898_, BlockState p_50899_, boolean p_50900_) {
        return true;
    }

    public boolean m_5491_(Level level, Random rand, BlockPos pos, BlockState state) {
        return level.f_46441_.nextFloat() < 0.45f;
    }

    public void m_7719_(ServerLevel level, Random rand, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)SaplingBlock.f_55973_) == 0) {
            level.m_7731_(pos, (BlockState)state.m_61122_((Property)SaplingBlock.f_55973_), 4);
        } else if (ForgeEventFactory.saplingGrowTree((LevelAccessor)level, (Random)rand, (BlockPos)pos)) {
            ModFeatures.Configured.ANCIENT_TREE.m_65385_((WorldGenLevel)level, level.m_7726_().m_8481_(), rand, pos);
        }
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cross(this.getBaseName(), generator.modLoc("block/" + this.getBaseName())));
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "block/" + this.getBaseName());
    }

    @Override
    public Supplier<RenderType> getRenderType() {
        return RenderType::m_110457_;
    }
}

