/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityAnimalGenerator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockAnimalGenerator
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    public BlockAnimalGenerator() {
        super("animal_generator", BlockEntityAnimalGenerator.class, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(3.0f).m_60918_(SoundType.f_56742_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.f_19853_.f_46443_ || entity.f_19853_.m_46467_() % 40L != 0L || !(entity instanceof Animal) || entity instanceof Mob || entity instanceof Npc) {
            return;
        }
        CompoundTag data = entity.getPersistentData();
        int timeAlive = data.m_128451_("naturesaura:time_alive");
        data.m_128405_("naturesaura:time_alive", timeAlive + 40);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.f_19853_.f_46443_ || !(entity instanceof Animal) || entity instanceof Mob || entity instanceof Npc) {
            return;
        }
        BlockPos pos = entity.m_142538_();
        Helper.getBlockEntitiesInArea((LevelAccessor)entity.f_19853_, pos, 5, tile -> {
            if (!(tile instanceof BlockEntityAnimalGenerator)) {
                return false;
            }
            BlockEntityAnimalGenerator gen = (BlockEntityAnimalGenerator)tile;
            CompoundTag data = entity.getPersistentData();
            data.m_128379_("naturesaura:no_drops", true);
            if (gen.isBusy()) {
                return false;
            }
            boolean child = entity.m_6162_();
            float timeMod = child ? 0.5f : 1.0f;
            float amountMod = child ? 0.667f : 1.0f;
            int timeAlive = data.m_128451_("naturesaura:time_alive");
            int time = Math.min(Mth.m_14143_((float)((float)(timeAlive - 15000) / 500.0f * timeMod)), 200);
            int amount = Math.min(Mth.m_14143_((float)((float)(timeAlive - 8000) / 2.0f * amountMod)), 25000);
            if (time <= 0 || amount <= 0) {
                return false;
            }
            gen.setGenerationValues(time, amount);
            BlockPos genPos = gen.m_58899_();
            PacketHandler.sendToAllAround(entity.f_19853_, pos, 32, new PacketParticles((float)entity.m_20185_(), (float)entity.m_20186_(), (float)entity.m_20189_(), PacketParticles.Type.ANIMAL_GEN_CONSUME, child ? 1 : 0, (int)(entity.m_20192_() * 10.0f), genPos.m_123341_(), genPos.m_123342_(), genPos.m_123343_()));
            return true;
        });
    }

    @SubscribeEvent
    public void onEntityDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.getPersistentData().m_128471_("naturesaura:no_drops")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityExp(LivingExperienceDropEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.getPersistentData().m_128471_("naturesaura:no_drops")) {
            event.setCanceled(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        return new AABB(pos).m_82400_(5.0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return 1128314;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_bottom"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }
}

