/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.BasicAuraContainer;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlockEntityEndFlower
extends BlockEntityImpl
implements ITickableBlockEntity {
    private final BasicAuraContainer container = new BasicAuraContainer(null, 500000){
        {
            this.aura = this.maxAura;
        }

        @Override
        public int storeAura(int amountToStore, boolean simulate) {
            return 0;
        }

        @Override
        public int drainAura(int amountToDrain, boolean simulate) {
            int amount = super.drainAura(amountToDrain, simulate);
            if (amount > 0 && !simulate) {
                BlockEntityEndFlower.this.sendToClients();
            }
            return amount;
        }

        @Override
        public int getAuraColor() {
            return 6956509;
        }
    };
    public boolean isDrainMode;

    public BlockEntityEndFlower(BlockPos pos, BlockState state) {
        super(ModBlockEntities.END_FLOWER, pos, state);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (this.f_58857_.m_46467_() % 10L != 0L) {
                return;
            }
            if (!this.isDrainMode) {
                List items = this.f_58857_.m_6443_(ItemEntity.class, new AABB(this.f_58858_).m_82400_(1.0), Entity::m_6084_);
                for (ItemEntity item : items) {
                    ItemStack stack;
                    if (item.m_32063_() || (stack = item.m_32055_()).m_41613_() != 1 || stack.m_41720_() != Items.f_42545_) continue;
                    this.isDrainMode = true;
                    item.m_6074_();
                    PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles((float)item.m_20185_(), (float)item.m_20186_(), (float)item.m_20189_(), PacketParticles.Type.END_FLOWER_CONSUME, this.container.getAuraColor()));
                    break;
                }
            } else {
                int toDrain = Math.min(5000, this.container.getStoredAura());
                this.container.drainAura(toDrain, false);
                this.generateAura(toDrain);
                if (this.container.getStoredAura() <= 0) {
                    this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50036_.m_49966_());
                    PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.END_FLOWER_DECAY, this.container.getAuraColor()));
                }
            }
        } else if (this.isDrainMode && this.f_58857_.m_46467_() % 5L == 0L) {
            NaturesAuraAPI.instance().spawnMagicParticle((float)this.f_58858_.m_123341_() + 0.25f + this.f_58857_.f_46441_.nextFloat() * 0.5f, (float)this.f_58858_.m_123342_() + 0.25f + this.f_58857_.f_46441_.nextFloat() * 0.5f, (float)this.f_58858_.m_123343_() + 0.25f + this.f_58857_.f_46441_.nextFloat() * 0.5f, this.f_58857_.f_46441_.nextGaussian() * (double)0.05f, this.f_58857_.f_46441_.nextFloat() * 0.1f, this.f_58857_.f_46441_.nextGaussian() * (double)0.05f, this.container.getAuraColor(), this.f_58857_.f_46441_.nextFloat() * 2.0f + 1.0f, 50, 0.0f, false, true);
        }
    }

    @Override
    public IAuraContainer getAuraContainer() {
        return this.container;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.container.writeNBT(compound);
            compound.m_128379_("drain_mode", this.isDrainMode);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.container.readNBT(compound);
            this.isDrainMode = compound.m_128471_("drain_mode");
        }
    }
}

