/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.blocks.BlockEnderCrate;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.gui.ContainerEnderCrate;
import de.ellpeck.naturesaura.gui.ModContainers;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BlockEntityEnderCrate
extends BlockEntityImpl
implements MenuProvider {
    public String name;
    private final IItemHandlerModifiable wrappedEnderStorage = new IItemHandlerModifiable(){

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.getStorage().setStackInSlot(slot, stack);
        }

        public int getSlots() {
            return this.getStorage().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.getStorage().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack remain = this.getStorage().insertItem(slot, stack, simulate);
            if (!simulate) {
                BlockEntityEnderCrate.this.drainAura((stack.m_41613_() - remain.m_41613_()) * 20);
            }
            return remain;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack extracted = this.getStorage().extractItem(slot, amount, simulate);
            if (!simulate) {
                BlockEntityEnderCrate.this.drainAura(extracted.m_41613_() * 20);
            }
            return extracted;
        }

        public int getSlotLimit(int slot) {
            return this.getStorage().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.getStorage().isItemValid(slot, stack);
        }

        private IItemHandlerModifiable getStorage() {
            return ILevelData.getOverworldData(BlockEntityEnderCrate.this.f_58857_).getEnderStorage(BlockEntityEnderCrate.this.name);
        }
    };

    public BlockEntityEnderCrate(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ENDER_CRATE, pos, state);
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        if (this.canOpen()) {
            return this.wrappedEnderStorage;
        }
        return null;
    }

    public boolean canOpen() {
        return this.name != null;
    }

    @Override
    public void dropInventory() {
    }

    @Override
    public void modifyDrop(ItemStack regularItem) {
        if (this.name != null) {
            if (!regularItem.m_41782_()) {
                regularItem.m_41751_(new CompoundTag());
            }
            regularItem.m_41783_().m_128359_("naturesaura:ender_name", this.name);
        }
    }

    @Override
    public void loadDataOnPlace(ItemStack stack) {
        String name;
        super.loadDataOnPlace(stack);
        if (!this.f_58857_.f_46443_ && (name = BlockEnderCrate.getEnderName(stack)) != null && !name.isEmpty()) {
            this.name = name;
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK && this.name != null) {
            compound.m_128359_("name", this.name);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK && compound.m_128441_("name")) {
            this.name = compound.m_128461_("name");
        }
    }

    public void drainAura(int amount) {
        if (amount > 0) {
            BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 35, this.f_58858_);
            IAuraChunk.getAuraChunk(this.f_58857_, spot).drainAura(spot, amount);
        }
    }

    public Component m_5446_() {
        return new TranslatableComponent("info.naturesaura.ender_crate", new Object[]{ChatFormatting.ITALIC + this.name + ChatFormatting.RESET});
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int window, Inventory inv, Player player) {
        return new ContainerEnderCrate(ModContainers.ENDER_CRATE, window, player, (IItemHandler)this.getItemHandler());
    }
}

