/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockEntityPlacer
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockEntityPlacer(BlockPos pos, BlockState state) {
        super(ModBlockEntities.PLACER, pos, state);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 15L == 0L) {
            if (this.redstonePower > 0) {
                return;
            }
            BlockEntity tileUp = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
            if (tileUp == null) {
                return;
            }
            IItemHandler handler = (IItemHandler)tileUp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).orElse(null);
            if (handler == null) {
                return;
            }
            List<ItemFrame> frames = Helper.getAttachedItemFrames(this.f_58857_, this.f_58858_);
            if (frames.isEmpty()) {
                return;
            }
            ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
            int range = 5;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos up;
                        BlockState state;
                        BlockPos pos = this.f_58858_.m_142082_(x, y, z);
                        if (!this.framesContain(frames, pos, this.f_58857_.m_8055_(pos)) || !(state = this.f_58857_.m_8055_(up = pos.m_7494_())).m_60767_().m_76336_()) continue;
                        validPositions.add(up);
                    }
                }
            }
            if (validPositions.isEmpty()) {
                return;
            }
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.extractItem(i, 1, true);
                if (stack.m_41619_()) continue;
                BlockPos pos = (BlockPos)validPositions.get(this.f_58857_.f_46441_.nextInt(validPositions.size()));
                ItemStack left = this.tryPlace(stack.m_41777_(), pos);
                if (ItemStack.m_41728_((ItemStack)stack, (ItemStack)left)) continue;
                handler.extractItem(i, 1, false);
                BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 10, this.f_58858_);
                IAuraChunk.getAuraChunk(this.f_58857_, spot).drainAura(spot, 1000);
                PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), PacketParticles.Type.PLACER_PLACING, new int[0]));
                return;
            }
        }
    }

    private boolean framesContain(List<ItemFrame> frames, BlockPos pos, BlockState state) {
        ItemStack stack = state.m_60734_().m_7397_((BlockGetter)this.f_58857_, pos, state);
        if (stack.m_41619_()) {
            return false;
        }
        for (ItemFrame frame : frames) {
            ItemStack frameStack = frame.m_31822_();
            if (frameStack.m_41619_()) continue;
            if (Helper.areItemsEqual(stack, frameStack, false)) {
                return true;
            }
            if (state.m_60734_() != Blocks.f_50093_ || frameStack.m_41720_() != ModItems.FARMING_STENCIL) continue;
            return true;
        }
        return false;
    }

    private ItemStack tryPlace(ItemStack stack, BlockPos pos) {
        if (!(this.f_58857_ instanceof ServerLevel)) {
            return stack;
        }
        FakePlayer fake = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_58857_));
        fake.m_150109_().f_35974_.set(fake.m_150109_().f_35977_, (Object)stack);
        BlockHitResult ray = new BlockHitResult(Vec3.m_82512_((Vec3i)pos), Direction.UP, pos, false);
        ForgeHooks.onPlaceItemIntoWorld((UseOnContext)new UseOnContext((Player)fake, InteractionHand.MAIN_HAND, ray));
        return fake.m_21205_().m_41777_();
    }
}

