/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.recipes.TreeRitualRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BlockEntityWoodStand
extends BlockEntityImpl
implements ITickableBlockEntity {
    public final ItemStackHandler items = new ItemStackHandlerNA(1, this, true){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private TreeRitualRecipe recipe;
    private BlockPos ritualPos;
    private int timer;

    public BlockEntityWoodStand(BlockPos pos, BlockState state) {
        super(ModBlockEntities.WOOD_STAND, pos, state);
    }

    public void setRitual(BlockPos pos, TreeRitualRecipe recipe) {
        this.ritualPos = pos;
        this.recipe = recipe;
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && this.ritualPos != null && this.recipe != null && this.f_58857_.m_46467_() % 5L == 0L) {
            if (this.isRitualOkay()) {
                boolean isOverHalf;
                boolean wasOverHalf = this.timer >= this.recipe.time / 2;
                this.timer += 5;
                boolean bl = isOverHalf = this.timer >= this.recipe.time / 2;
                if (!isOverHalf) {
                    Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'W', (pos, matcher) -> {
                        BlockEntity tile = this.f_58857_.m_7702_(pos);
                        if (tile instanceof BlockEntityWoodStand && !((BlockEntityWoodStand)tile).items.getStackInSlot(0).m_41619_()) {
                            PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticleStream((float)pos.m_123341_() + 0.2f + this.f_58857_.f_46441_.nextFloat() * 0.6f, (float)pos.m_123342_() + 0.85f, (float)pos.m_123343_() + 0.2f + this.f_58857_.f_46441_.nextFloat() * 0.6f, (float)this.ritualPos.m_123341_() + 0.5f, (float)this.ritualPos.m_123342_() + this.f_58857_.f_46441_.nextFloat() * 3.0f + 2.0f, (float)this.ritualPos.m_123343_() + 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.04f + 0.04f, 9030711, this.f_58857_.f_46441_.nextFloat() + 1.0f));
                        }
                        return true;
                    });
                }
                PacketHandler.sendToAllAround(this.f_58857_, this.ritualPos, 32, new PacketParticles(this.ritualPos.m_123341_(), this.ritualPos.m_123342_(), this.ritualPos.m_123343_(), PacketParticles.Type.TR_GOLD_POWDER, new int[0]));
                if (this.timer >= this.recipe.time) {
                    Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'G', (pos, matcher) -> {
                        this.f_58857_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                        return true;
                    });
                    BlockEntityWoodStand.recurseTreeDestruction(this.f_58857_, this.ritualPos, this.ritualPos, true, false);
                    ItemEntity item = new ItemEntity(this.f_58857_, (double)this.ritualPos.m_123341_() + 0.5, (double)this.ritualPos.m_123342_() + 4.5, (double)this.ritualPos.m_123343_() + 0.5, this.recipe.result.m_41777_());
                    this.f_58857_.m_7967_((Entity)item);
                    PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles((float)item.m_20185_(), (float)item.m_20186_(), (float)item.m_20189_(), PacketParticles.Type.TR_SPAWN_RESULT, new int[0]));
                    this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_11852_, SoundSource.BLOCKS, 0.65f, 1.0f);
                    this.ritualPos = null;
                    this.recipe = null;
                    this.timer = 0;
                } else if (isOverHalf && !wasOverHalf) {
                    Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'W', (pos, matcher) -> {
                        BlockEntity tile = this.f_58857_.m_7702_(pos);
                        if (tile instanceof BlockEntityWoodStand) {
                            BlockEntityWoodStand stand = (BlockEntityWoodStand)tile;
                            if (!stand.items.getStackInSlot(0).m_41619_()) {
                                PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(stand.f_58858_.m_123341_(), stand.f_58858_.m_123342_(), stand.f_58858_.m_123343_(), PacketParticles.Type.TR_CONSUME_ITEM, new int[0]));
                                this.f_58857_.m_6263_(null, (double)stand.f_58858_.m_123341_() + 0.5, (double)stand.f_58858_.m_123342_() + 0.5, (double)stand.f_58858_.m_123343_() + 0.5, SoundEvents.f_12638_, SoundSource.BLOCKS, 0.5f, 1.0f);
                                stand.items.setStackInSlot(0, ItemStack.f_41583_);
                                stand.sendToClients();
                            }
                        }
                        return true;
                    });
                }
            } else {
                this.ritualPos = null;
                this.recipe = null;
                this.timer = 0;
            }
        }
    }

    public static void recurseTreeDestruction(Level level, BlockPos pos, BlockPos start, boolean includeLeaves, boolean drop) {
        if (Math.abs(pos.m_123341_() - start.m_123341_()) >= 6 || Math.abs(pos.m_123343_() - start.m_123343_()) >= 6 || Math.abs(pos.m_123342_() - start.m_123342_()) >= 32) {
            return;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offset = pos.m_142082_(x, y, z);
                    BlockState state = level.m_8055_(offset);
                    if (!state.m_60734_().getTags().contains(BlockTags.f_13106_.m_6979_()) && (!includeLeaves || !(state.m_60734_() instanceof LeavesBlock))) continue;
                    if (drop) {
                        level.m_46961_(offset, true);
                    } else {
                        level.m_46597_(offset, Blocks.f_50016_.m_49966_());
                        PacketHandler.sendToAllAround(level, pos, 32, new PacketParticles(offset.m_123341_(), offset.m_123342_(), offset.m_123343_(), PacketParticles.Type.TR_DISAPPEAR, new int[0]));
                    }
                    BlockEntityWoodStand.recurseTreeDestruction(level, offset, start, includeLeaves, drop);
                }
            }
        }
    }

    private boolean isRitualOkay() {
        if (!Multiblocks.TREE_RITUAL.isComplete(this.f_58857_, this.ritualPos)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            BlockState state = this.f_58857_.m_8055_(this.ritualPos.m_6630_(i));
            if (state.m_60734_().getTags().contains(BlockTags.f_13106_.m_6979_())) continue;
            return false;
        }
        if (this.timer < this.recipe.time / 2) {
            ArrayList<Ingredient> required = new ArrayList<Ingredient>(Arrays.asList(this.recipe.ingredients));
            boolean fine = Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'W', (pos, matcher) -> {
                ItemStack stack;
                BlockEntity tile = this.f_58857_.m_7702_(pos);
                if (tile instanceof BlockEntityWoodStand && !(stack = ((BlockEntityWoodStand)tile).items.getStackInSlot(0)).m_41619_()) {
                    for (int i = required.size() - 1; i >= 0; --i) {
                        Ingredient req = (Ingredient)required.get(i);
                        if (!req.test(stack)) continue;
                        required.remove(i);
                        return true;
                    }
                    return false;
                }
                return true;
            });
            return fine && required.isEmpty();
        }
        return true;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.m_128365_("items", (Tag)this.items.serializeNBT());
        }
        if (type == BlockEntityImpl.SaveType.TILE && this.ritualPos != null && this.recipe != null) {
            compound.m_128356_("ritual_pos", this.ritualPos.m_121878_());
            compound.m_128405_("timer", this.timer);
            compound.m_128359_("recipe", this.recipe.name.toString());
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.items.deserializeNBT(compound.m_128469_("items"));
        }
        if (type == BlockEntityImpl.SaveType.TILE && compound.m_128441_("recipe")) {
            this.ritualPos = BlockPos.m_122022_((long)compound.m_128454_("ritual_pos"));
            this.timer = compound.m_128451_("timer");
            if (this.m_58898_()) {
                this.recipe = this.f_58857_.m_7465_().m_44043_(new ResourceLocation(compound.m_128461_("recipe"))).orElse(null);
            }
        }
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.items;
    }
}

