/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.chunk.ISpotDrainable;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;

public class ReplenishingEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "replenishing");

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (spot < 0) {
            ArrayList tiles = new ArrayList();
            Helper.getBlockEntitiesInArea((LevelAccessor)level, pos, 25, tile -> {
                IAuraContainer container = (IAuraContainer)tile.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER, null).orElse(null);
                if (container instanceof ISpotDrainable) {
                    tiles.add((ISpotDrainable)container);
                }
                return false;
            });
            if (!tiles.isEmpty()) {
                IAuraType type = IAuraType.forLevel(level);
                for (int i = level.f_46441_.nextInt(6); i >= 0; --i) {
                    int drained;
                    ISpotDrainable tile2 = (ISpotDrainable)tiles.get(level.f_46441_.nextInt(tiles.size()));
                    if (!tile2.isAcceptableType(type) || (drained = tile2.drainAuraPassively(-spot.intValue(), false)) <= 0) continue;
                    auraChunk.storeAura(pos, drained);
                    spot = spot + drained;
                    if (spot >= drained) break;
                }
            }
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return true;
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

