/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.compat.ICompat;
import de.ellpeck.naturesaura.data.ItemTagProvider;
import de.ellpeck.naturesaura.events.ClientEvents;
import de.ellpeck.naturesaura.renderers.SupporterFancyHandler;
import java.time.LocalDateTime;
import java.time.Month;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import vazkii.patchouli.api.BookDrawScreenEvent;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.PatchouliAPI;

public class PatchouliCompat
implements ICompat {
    private static final ResourceLocation BOOK = new ResourceLocation("naturesaura", "book");
    private static final Map<ResourceLocation, IMultiblock> MULTIBLOCKS = new HashMap<ResourceLocation, IMultiblock>();

    public static void addPatchouliMultiblock(ResourceLocation name, String[][] pattern, Object ... rawMatchers) {
        for (int i = 1; i < rawMatchers.length; i += 2) {
            Object object = rawMatchers[i];
            if (!(object instanceof Matcher)) continue;
            Matcher matcher = (Matcher)object;
            Matcher.ICheck check = matcher.check();
            rawMatchers[i] = check == null ? PatchouliAPI.get().anyMatcher() : PatchouliAPI.get().predicateMatcher(matcher.defaultState(), state -> check.matches(null, null, null, null, (BlockState)state, '\u0000'));
        }
        MULTIBLOCKS.put(name, PatchouliAPI.get().makeMultiblock(pattern, rawMatchers));
    }

    public static <T extends Recipe<?>> T getRecipe(String type, String name) {
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        ResourceLocation res = new ResourceLocation(name);
        ResourceLocation pre = new ResourceLocation(res.m_135827_(), type + "/" + res.m_135815_());
        return (T)((Recipe)manager.m_44043_(pre).orElse(null));
    }

    public static IVariable ingredientVariable(Ingredient ingredient) {
        return IVariable.wrapList((Iterable)Arrays.stream(ingredient.m_43908_()).map(IVariable::from).collect(Collectors.toList()));
    }

    @Override
    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (Map.Entry<ResourceLocation, IMultiblock> entry : MULTIBLOCKS.entrySet()) {
                PatchouliAPI.get().registerMultiblock(entry.getKey(), entry.getValue());
            }
            PatchouliAPI.get().setConfigFlag("naturesaura:rf_converter", ((Boolean)ModConfig.instance.rfConverter.get()).booleanValue());
            PatchouliAPI.get().setConfigFlag("naturesaura:chunk_loader", ((Boolean)ModConfig.instance.chunkLoader.get()).booleanValue());
        });
    }

    @Override
    public void setupClient() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void addItemTags(ItemTagProvider provider) {
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onBookDraw(BookDrawScreenEvent event) {
        ResourceLocation book = event.getBook();
        Screen gui = event.getScreen();
        if (book == null || !book.equals((Object)BOOK)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        if (now.getMonth() == Month.MAY && now.getDayOfMonth() == 21) {
            x = gui.f_96543_ / 2 + 136 - 16;
            y = gui.f_96544_ / 2 - 90 - 26;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ClientEvents.BOOK_GUI);
            Screen.m_93133_((PoseStack)event.getPoseStack(), (int)x, (int)y, (float)469.0f, (float)0.0f, (int)43, (int)42, (int)512, (int)256);
            if (event.getMouseX() >= x && event.getMouseY() >= y && event.getMouseX() < x + 43 && event.getMouseY() < y + 42) {
                gui.renderComponentTooltip(event.getPoseStack(), Collections.singletonList(new TextComponent("It's the author Ellpeck's birthday!").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.GOLD))), event.getMouseX(), event.getMouseY(), gui.getMinecraft().f_91062_);
            }
        } else if (now.getMonth() == Month.JUNE) {
            x = gui.f_96543_ / 2 + 136;
            y = gui.f_96544_ / 2 - 90 + 16;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ClientEvents.BOOK_GUI);
            Screen.m_93133_((PoseStack)event.getPoseStack(), (int)x, (int)y, (float)424.0f, (float)0.0f, (int)45, (int)26, (int)512, (int)256);
            if (event.getMouseX() >= x && event.getMouseY() >= y && event.getMouseX() < x + 45 && event.getMouseY() < y + 26) {
                gui.renderComponentTooltip(event.getPoseStack(), Collections.singletonList(new TextComponent("\u00c2\u00a76Happy \u00c2\u00a74P\u00c2\u00a76r\u00c2\u00a7ei\u00c2\u00a72d\u00c2\u00a79e\u00c2\u00a75!")), event.getMouseX(), event.getMouseY(), gui.getMinecraft().f_91062_);
            }
        }
        String name = gui.getMinecraft().f_91074_.m_7755_().getString();
        SupporterFancyHandler.FancyInfo info = SupporterFancyHandler.FANCY_INFOS.get(name);
        if (info != null) {
            int x = gui.f_96543_ / 2 - 136 + 20;
            int y = gui.f_96544_ / 2 + 90;
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)ClientEvents.BOOK_GUI);
            Screen.m_93133_((PoseStack)event.getPoseStack(), (int)x, (int)y, (float)496.0f, (float)44.0f, (int)16, (int)18, (int)512, (int)256);
            if (info.tier() == 1) {
                Screen.m_93133_((PoseStack)event.getPoseStack(), (int)x, (int)y, (float)480.0f, (float)44.0f, (int)16, (int)18, (int)512, (int)256);
            } else {
                float r = (float)(info.color() >> 16 & 0xFF) / 255.0f;
                float g = (float)(info.color() >> 8 & 0xFF) / 255.0f;
                float b = (float)(info.color() & 0xFF) / 255.0f;
                RenderSystem.m_157429_((float)r, (float)g, (float)b, (float)1.0f);
                Screen.m_93133_((PoseStack)event.getPoseStack(), (int)x, (int)y, (float)464.0f, (float)44.0f, (int)16, (int)18, (int)512, (int)256);
            }
            if (event.getMouseX() >= x && event.getMouseY() >= y && event.getMouseX() < x + 16 && event.getMouseY() < y + 18) {
                gui.renderComponentTooltip(event.getPoseStack(), Collections.singletonList(new TextComponent("Thanks for your support, " + name + "!").m_6270_(Style.f_131099_.m_131157_(ChatFormatting.YELLOW))), event.getMouseX(), event.getMouseY(), gui.getMinecraft().f_91062_);
            }
        }
    }
}

