/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorAnimalSpawner
implements IComponentProcessor {
    private AnimalSpawnerRecipe recipe;

    public void setup(IVariableProvider provider) {
        this.recipe = (AnimalSpawnerRecipe)PatchouliCompat.getRecipe("animal_spawner", provider.get("recipe").asString());
    }

    public IVariable process(String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int id = Integer.parseInt(key.substring(5)) - 1;
            return this.recipe.ingredients.length > id ? PatchouliCompat.ingredientVariable(this.recipe.ingredients[id]) : null;
        }
        return switch (key) {
            case "name" -> IVariable.wrap((String)this.recipe.entity.m_20676_().getString());
            case "entity" -> IVariable.wrap((String)this.recipe.entity.getRegistryName().toString());
            case "egg" -> IVariable.from((Object)new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType(this.recipe.entity)));
            default -> null;
        };
    }

    public boolean allowRender(String group) {
        return !"seekrit".equals(group);
    }
}

