/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities;

import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.entities.ModEntities;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.misc.LevelData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class EntityEffectInhibitor
extends Entity
implements IVisualizable {
    private static final EntityDataAccessor<String> INHIBITED_EFFECT = SynchedEntityData.m_135353_(EntityEffectInhibitor.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(EntityEffectInhibitor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AMOUNT = SynchedEntityData.m_135353_(EntityEffectInhibitor.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private ResourceLocation lastEffect;
    private boolean powderListDirty;
    @OnlyIn(value=Dist.CLIENT)
    public int renderTicks;

    public EntityEffectInhibitor(EntityType<?> entityTypeIn, Level levelIn) {
        super(entityTypeIn, levelIn);
    }

    public static void place(Level level, ItemStack stack, double posX, double posY, double posZ) {
        ResourceLocation effect = ItemEffectPowder.getEffect(stack);
        EntityEffectInhibitor entity = new EntityEffectInhibitor(ModEntities.EFFECT_INHIBITOR, level);
        entity.setInhibitedEffect(effect);
        entity.setColor(NaturesAuraAPI.EFFECT_POWDERS.get(effect));
        entity.setAmount(stack.m_41613_());
        entity.m_6034_(posX, posY, posZ);
        level.m_7967_((Entity)entity);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.powderListDirty = true;
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        this.setInhibitedEffect(null);
        this.updatePowderListStatus();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(INHIBITED_EFFECT, null);
        this.f_19804_.m_135372_(COLOR, (Object)0);
        this.f_19804_.m_135372_(AMOUNT, (Object)0);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (INHIBITED_EFFECT.equals(key) || AMOUNT.equals(key)) {
            this.powderListDirty = true;
        }
    }

    public void m_6034_(double x, double y, double z) {
        if (x != this.m_20185_() || y != this.m_20186_() || z != this.m_20189_()) {
            this.powderListDirty = true;
        }
        super.m_6034_(x, y, z);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.powderListDirty) {
            this.updatePowderListStatus();
        }
        if (this.f_19853_.f_46443_) {
            if (this.f_19853_.m_46467_() % 5L == 0L) {
                NaturesAuraAPI.instance().spawnMagicParticle(this.m_20185_() + this.f_19853_.f_46441_.nextGaussian() * (double)0.1f, this.m_20186_(), this.m_20189_() + this.f_19853_.f_46441_.nextGaussian() * (double)0.1f, this.f_19853_.f_46441_.nextGaussian() * (double)0.005f, this.f_19853_.f_46441_.nextFloat() * 0.03f, this.f_19853_.f_46441_.nextGaussian() * (double)0.005f, this.getColor(), this.f_19853_.f_46441_.nextFloat() * 3.0f + 1.0f, 120, 0.0f, true, true);
            }
            ++this.renderTicks;
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.setInhibitedEffect(new ResourceLocation(compound.m_128461_("effect")));
        this.setColor(compound.m_128451_("color"));
        this.setAmount(compound.m_128441_("amount") ? compound.m_128451_("amount") : 24);
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("effect", this.getInhibitedEffect().toString());
        compound.m_128405_("color", this.getColor());
        compound.m_128405_("amount", this.getAmount());
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_7313_(Entity entity) {
        Player player;
        return entity instanceof Player && (!this.f_19853_.m_7966_(player = (Player)entity, this.m_142538_()) || this.m_6469_(DamageSource.m_19344_((Player)player), 0.0f));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && !this.f_19853_.f_46443_) {
            this.m_6074_();
            this.m_5552_(this.getDrop(), 0.0f);
            return true;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.getDrop();
    }

    public ItemStack getDrop() {
        return ItemEffectPowder.setEffect(new ItemStack((ItemLike)ModItems.EFFECT_POWDER, this.getAmount()), this.getInhibitedEffect());
    }

    public ResourceLocation getInhibitedEffect() {
        String effect = (String)this.f_19804_.m_135370_(INHIBITED_EFFECT);
        if (effect == null || effect.isEmpty()) {
            return null;
        }
        return new ResourceLocation(effect);
    }

    public void setInhibitedEffect(ResourceLocation effect) {
        this.f_19804_.m_135381_(INHIBITED_EFFECT, (Object)(effect != null ? effect.toString() : null));
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public int getAmount() {
        return (Integer)this.f_19804_.m_135370_(AMOUNT);
    }

    public void setAmount(int amount) {
        this.f_19804_.m_135381_(AMOUNT, (Object)amount);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        return Helper.aabb(this.m_146892_()).m_82400_((double)this.getAmount());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return this.getColor();
    }

    private void updatePowderListStatus() {
        ResourceLocation effect;
        ListMultimap<ResourceLocation, Tuple<Vec3, Integer>> powders = ((LevelData)ILevelData.getLevelData((Level)this.f_19853_)).effectPowders;
        if (this.lastEffect != null) {
            List oldList = powders.get((Object)this.lastEffect);
            oldList.removeIf(t -> this.m_146892_().equals(t.m_14418_()));
        }
        if ((effect = this.getInhibitedEffect()) != null) {
            List newList = powders.get((Object)effect);
            newList.add(new Tuple((Object)this.m_146892_(), (Object)this.getAmount()));
        }
        this.powderListDirty = false;
        this.lastEffect = effect;
    }
}

