/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.network.NetworkHooks;

public class EntityMoverMinecart
extends AbstractMinecart {
    private final List<BlockPos> spotOffsets = new ArrayList<BlockPos>();
    public boolean isActive;
    private BlockPos lastPosition = BlockPos.f_121853_;

    public EntityMoverMinecart(EntityType<?> type, Level level) {
        super(type, level);
    }

    public EntityMoverMinecart(EntityType<?> type, Level level, double x, double y, double z) {
        super(type, level, x, y, z);
    }

    public void moveMinecartOnRail(BlockPos railPos) {
        super.moveMinecartOnRail(railPos);
        if (!this.isActive) {
            return;
        }
        BlockPos pos = this.m_142538_();
        if (!this.spotOffsets.isEmpty() && this.f_19853_.m_46467_() % 10L == 0L) {
            PacketHandler.sendToAllAround(this.f_19853_, pos, 32, new PacketParticles((float)this.m_20185_(), (float)this.m_20186_(), (float)this.m_20189_(), PacketParticles.Type.MOVER_CART, Mth.m_14107_((double)(this.m_20184_().f_82479_ * 100.0)), Mth.m_14107_((double)(this.m_20184_().f_82480_ * 100.0)), Mth.m_14107_((double)(this.m_20184_().f_82481_ * 100.0))));
        }
        if (pos.m_123331_((Vec3i)this.lastPosition) < 64.0) {
            return;
        }
        this.moveAura(this.f_19853_, this.lastPosition, this.f_19853_, pos);
        this.lastPosition = pos;
    }

    private void moveAura(Level oldLevel, BlockPos oldPos, Level newLevel, BlockPos newPos) {
        for (BlockPos offset : this.spotOffsets) {
            int toMove;
            int drained;
            BlockPos spot = oldPos.m_141952_((Vec3i)offset);
            IAuraChunk chunk = IAuraChunk.getAuraChunk(oldLevel, spot);
            int amount = chunk.getDrainSpot(spot);
            if (amount <= 0 || (drained = chunk.drainAura(spot, toMove = Math.min(amount, 300000), false, false)) <= 0) continue;
            int toLose = Mth.m_14167_((float)((float)drained / 250.0f));
            BlockPos newSpot = newPos.m_141952_((Vec3i)offset);
            IAuraChunk.getAuraChunk(newLevel, newSpot).storeAura(newSpot, drained - toLose, false, false);
        }
    }

    public void m_6025_(int x, int y, int z, boolean receivingPower) {
        if (this.isActive != receivingPower) {
            this.isActive = receivingPower;
            BlockPos pos = this.m_142538_();
            if (!this.isActive) {
                this.moveAura(this.f_19853_, this.lastPosition, this.f_19853_, pos);
                this.spotOffsets.clear();
                this.lastPosition = BlockPos.f_121853_;
                return;
            }
            IAuraChunk.getSpotsInArea(this.f_19853_, pos, 25, (spot, amount) -> {
                if (amount > 0) {
                    this.spotOffsets.add(spot.m_141950_((Vec3i)pos));
                }
            });
            this.lastPosition = pos;
        }
    }

    public void m_7617_(DamageSource source) {
        this.m_6074_();
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_5552_(new ItemStack((ItemLike)ModItems.MOVER_CART), 0.0f);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128379_("active", this.isActive);
        compound.m_128356_("last_pos", this.lastPosition.m_121878_());
        ListTag list = new ListTag();
        for (BlockPos offset : this.spotOffsets) {
            list.add((Object)LongTag.m_128882_((long)offset.m_121878_()));
        }
        compound.m_128365_("offsets", (Tag)list);
        return compound;
    }

    public void deserializeNBT(CompoundTag compound) {
        super.deserializeNBT(compound);
        this.isActive = compound.m_128471_("active");
        this.lastPosition = BlockPos.m_122022_((long)compound.m_128454_("last_pos"));
        this.spotOffsets.clear();
        ListTag list = compound.m_128437_("offsets", 4);
        for (Tag base : list) {
            this.spotOffsets.add(BlockPos.m_122022_((long)((LongTag)base).m_7046_()));
        }
    }

    @Nullable
    public Entity changeDimension(ServerLevel destination, ITeleporter teleporter) {
        Entity entity = super.changeDimension(destination, teleporter);
        if (entity instanceof EntityMoverMinecart) {
            BlockPos pos = entity.m_142538_();
            this.moveAura(this.f_19853_, this.lastPosition, entity.f_19853_, pos);
            ((EntityMoverMinecart)entity).lastPosition = pos;
        }
        return entity;
    }

    public BlockState m_38178_() {
        return Blocks.f_50069_.m_49966_();
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.RIDEABLE;
    }

    public ItemStack getCartItem() {
        return new ItemStack((ItemLike)ModItems.MOVER_CART);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ModItems.MOVER_CART);
    }

    public boolean canBeRidden() {
        return false;
    }

    protected void m_7114_() {
        Vec3 motion = this.m_20184_();
        this.m_20334_(motion.f_82479_ * (double)0.99f, 0.0, motion.f_82481_ * (double)0.99f);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

