/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityAuraTimer;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityGratedChute;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityItemDistributor;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityNatureAltar;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityRFConverter;
import de.ellpeck.naturesaura.items.ItemAuraCache;
import de.ellpeck.naturesaura.items.ItemRangeVisualizer;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketAuraChunk;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.mutable.MutableInt;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    public static final ResourceLocation OVERLAYS = new ResourceLocation("naturesaura", "textures/gui/overlays.png");
    public static final ResourceLocation BOOK_GUI = new ResourceLocation("naturesaura", "textures/gui/book.png");
    public static final List<PacketAuraChunk> PENDING_AURA_CHUNKS = new ArrayList<PacketAuraChunk>();
    private static final ItemStack ITEM_FRAME = new ItemStack((ItemLike)Items.f_42617_);
    private static final ItemStack DISPENSER = new ItemStack((ItemLike)Blocks.f_50061_);
    private static final Map<ResourceLocation, Tuple<ItemStack, Boolean>> SHOWING_EFFECTS = new HashMap<ResourceLocation, Tuple<ItemStack, Boolean>>();
    private static ItemStack heldCache = ItemStack.f_41583_;
    private static ItemStack heldEye = ItemStack.f_41583_;
    private static ItemStack heldOcular = ItemStack.f_41583_;
    private static BlockPos hoveringAuraSpot;

    @SubscribeEvent
    public void onDebugRender(RenderGameOverlayEvent.Text event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92063_ && ((Boolean)ModConfig.instance.debugText.get()).booleanValue()) {
            String prefix = ChatFormatting.GREEN + "[Nature's Aura]" + ChatFormatting.RESET + " ";
            ArrayList left = event.getLeft();
            if (mc.f_91074_.m_7500_()) {
                left.add("");
                MutableInt amount = new MutableInt(1000000);
                MutableInt spots = new MutableInt();
                MutableInt chunks = new MutableInt();
                IAuraChunk.getSpotsInArea((Level)mc.f_91073_, mc.f_91074_.m_142538_(), 35, (blockPos, drainSpot) -> {
                    spots.increment();
                    amount.add((Number)drainSpot);
                });
                Helper.getAuraChunksWithSpotsInArea((Level)mc.f_91073_, mc.f_91074_.m_142538_(), 35, c -> chunks.increment());
                NumberFormat format = NumberFormat.getInstance();
                left.add(prefix + "A: " + format.format(amount.intValue()) + " (S: " + spots.intValue() + ", C: " + chunks.intValue() + ")");
                left.add(prefix + "AT: " + IAuraType.forLevel((Level)mc.f_91073_).getName());
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            heldCache = ItemStack.f_41583_;
            heldEye = ItemStack.f_41583_;
            heldOcular = ItemStack.f_41583_;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91073_ == null) {
                ItemRangeVisualizer.clear();
                PENDING_AURA_CHUNKS.clear();
            } else {
                PENDING_AURA_CHUNKS.removeIf(next -> next.tryHandle((Level)mc.f_91073_));
                if (!mc.m_91104_()) {
                    if (mc.f_91073_.m_46467_() % 20L == 0L) {
                        int amount = Mth.m_14107_((double)(190.0 * (Double)ModConfig.instance.excessParticleAmount.get()));
                        for (int i = 0; i < amount; ++i) {
                            int chance;
                            int excess;
                            int z;
                            int x = Mth.m_14107_((double)mc.f_91074_.m_20185_()) + mc.f_91073_.f_46441_.nextInt(64) - 32;
                            BlockPos pos = new BlockPos(x, mc.f_91073_.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = Mth.m_14107_((double)mc.f_91074_.m_20189_()) + mc.f_91073_.f_46441_.nextInt(64) - 32) - 1, z);
                            BlockState state = mc.f_91073_.m_8055_(pos);
                            Block block = state.m_60734_();
                            if (!(block instanceof BonemealableBlock) && !(block instanceof IPlantable) && !(block instanceof LeavesBlock) && !(block instanceof MyceliumBlock) || (excess = IAuraChunk.triangulateAuraInArea((Level)mc.f_91073_, pos, 45) - 1000000) <= 0 || mc.f_91073_.f_46441_.nextInt(chance = Math.max(10, 50 - excess / 25000)) > 0) continue;
                            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.m_123341_() + mc.f_91073_.f_46441_.nextFloat(), (float)pos.m_123342_() + 0.5f, (float)pos.m_123343_() + mc.f_91073_.f_46441_.nextFloat(), mc.f_91073_.f_46441_.nextGaussian() * (double)0.01f, mc.f_91073_.f_46441_.nextFloat() * 0.025f, mc.f_91073_.f_46441_.nextGaussian() * (double)0.01f, block instanceof MyceliumBlock ? 8871073 : BiomeColors.m_108793_((BlockAndTintGetter)mc.f_91073_, (BlockPos)pos), Math.min(2.0f, 1.0f + mc.f_91073_.f_46441_.nextFloat() * ((float)excess / 30000.0f)), Math.min(300, 100 + mc.f_91073_.f_46441_.nextInt(excess / 3000 + 1)), 0.0f, false, true);
                        }
                    }
                    if (Helper.isHoldingItem((Player)mc.f_91074_, ModItems.RANGE_VISUALIZER) && mc.f_91073_.m_46467_() % 5L == 0L) {
                        NaturesAuraAPI.IInternalHooks inst = NaturesAuraAPI.instance();
                        inst.setParticleSpawnRange(512);
                        inst.setParticleDepth(false);
                        for (BlockPos pos : ItemRangeVisualizer.VISUALIZED_RAILS.get((Object)mc.f_91073_.m_46472_().m_135782_())) {
                            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.m_123341_() + mc.f_91073_.f_46441_.nextFloat(), (float)pos.m_123342_() + mc.f_91073_.f_46441_.nextFloat(), (float)pos.m_123343_() + mc.f_91073_.f_46441_.nextFloat(), 0.0, 0.0, 0.0, 14744319, mc.f_91073_.f_46441_.nextFloat() * 5.0f + 1.0f, 100, 0.0f, false, true);
                        }
                        inst.setParticleDepth(true);
                        inst.setParticleSpawnRange(32);
                    }
                    heldCache = Helper.getEquippedItem(s -> s.m_41720_() instanceof ItemAuraCache, (Player)mc.f_91074_);
                    heldEye = Helper.getEquippedItem(s -> s.m_41720_() == ModItems.EYE, (Player)mc.f_91074_);
                    heldOcular = Helper.getEquippedItem(s -> s.m_41720_() == ModItems.EYE_IMPROVED, (Player)mc.f_91074_);
                    if (!heldOcular.m_41619_() && mc.f_91073_.m_46467_() % 20L == 0L) {
                        SHOWING_EFFECTS.clear();
                        Helper.getAuraChunksWithSpotsInArea((Level)mc.f_91073_, mc.f_91074_.m_142538_(), 100, chunk -> chunk.getActiveEffectIcons((Player)mc.f_91074_, SHOWING_EFFECTS));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLevelRender(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        mc.m_91307_().m_6180_("naturesaura:onLevelRender");
        RenderSystem.m_69482_();
        PoseStack mv = RenderSystem.m_157191_();
        mv.m_85836_();
        mv.m_166854_(event.getPoseStack().m_85850_().m_85861_());
        mv.m_85837_(-view.f_82479_, -view.f_82480_, -view.f_82481_);
        RenderSystem.m_157182_();
        RenderSystem.m_69478_();
        hoveringAuraSpot = null;
        if (mc.f_91066_.f_92063_ && mc.f_91074_.m_7500_() && ((Boolean)ModConfig.instance.debugLevel.get()).booleanValue()) {
            Vec3 playerEye = mc.f_91074_.m_20299_(event.getPartialTick());
            Vec3 playerView = mc.f_91074_.m_20252_(event.getPartialTick()).m_82541_();
            float range = mc.f_91072_.m_105286_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            IAuraChunk.getSpotsInArea((Level)mc.f_91073_, mc.f_91074_.m_142538_(), 64, (pos, spot) -> {
                Helper.renderWeirdBox((VertexConsumer)buffer, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 1.0, 1.0, 1.0, spot > 0 ? 0.0f : 1.0f, spot > 0 ? 1.0f : 0.0f, 0.0f, 0.35f);
                if (playerEye.m_82531_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= (double)(range * range)) {
                    for (float d = 0.0f; d <= range; d += 0.5f) {
                        if (!pos.equals((Object)new BlockPos(playerEye.m_82549_(playerView.m_82490_((double)d))))) continue;
                        hoveringAuraSpot = pos;
                        break;
                    }
                }
            });
            tesselator.m_85914_();
        }
        if (Helper.isHoldingItem((Player)mc.f_91074_, ModItems.RANGE_VISUALIZER)) {
            RenderSystem.m_69464_();
            ResourceLocation dim = mc.f_91073_.m_46472_().m_135782_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            for (BlockPos pos2 : ItemRangeVisualizer.VISUALIZED_BLOCKS.get((Object)dim)) {
                BlockState state;
                Block block;
                if (!mc.f_91073_.m_46749_(pos2) || !((block = (state = mc.f_91073_.m_8055_(pos2)).m_60734_()) instanceof IVisualizable)) continue;
                this.renderVisualize(buffer, (IVisualizable)block, (Level)mc.f_91073_, pos2);
            }
            for (Entity entity : ItemRangeVisualizer.VISUALIZED_ENTITIES.get((Object)dim)) {
                if (!entity.m_6084_() || !(entity instanceof IVisualizable)) continue;
                this.renderVisualize(buffer, (IVisualizable)entity, (Level)mc.f_91073_, entity.m_142538_());
            }
            tesselator.m_85914_();
            RenderSystem.m_69481_();
        }
        mv.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_69461_();
        mc.m_91307_().m_7238_();
    }

    private void renderVisualize(BufferBuilder buffer, IVisualizable visualize, Level level, BlockPos pos) {
        AABB box = visualize.getVisualizationBounds(level, pos);
        if (box != null) {
            box = box.m_82400_((double)0.05f);
            int color = visualize.getVisualizationColor(level, pos);
            Helper.renderWeirdBox((VertexConsumer)buffer, box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_ - box.f_82288_, box.f_82292_ - box.f_82289_, box.f_82293_ - box.f_82290_, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 0.5f);
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        PoseStack stack = event.getMatrixStack();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            Window res = event.getWindow();
            if (mc.f_91074_ != null) {
                if (!heldCache.m_41619_()) {
                    IAuraContainer container = (IAuraContainer)heldCache.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER, null).orElse(null);
                    int width = Mth.m_14167_((float)((float)container.getStoredAura() / (float)container.getMaxAura() * 80.0f));
                    int conf = (Integer)ModConfig.instance.cacheBarLocation.get();
                    int x = res.m_85445_() / 2 + (conf == 0 ? -173 - (mc.f_91074_.m_21206_().m_41619_() ? 0 : 29) : 93);
                    int y = res.m_85446_() - 8;
                    stack.m_85836_();
                    int color = container.getAuraColor();
                    RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
                    RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAYS);
                    if (width < 80) {
                        Screen.m_93133_((PoseStack)stack, (int)(x + width), (int)y, (float)width, (float)0.0f, (int)(80 - width), (int)6, (int)256, (int)256);
                    }
                    if (width > 0) {
                        Screen.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)6.0f, (int)width, (int)6, (int)256, (int)256);
                    }
                    float scale = 0.75f;
                    stack.m_85836_();
                    stack.m_85841_(scale, scale, scale);
                    String s = heldCache.m_41786_().getString();
                    mc.f_91062_.m_92750_(stack, s, conf == 1 ? (float)x / scale : (float)(x + 80) / scale - (float)mc.f_91062_.m_92895_(s), (float)(y - 7) / scale, color);
                    stack.m_85849_();
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    stack.m_85836_();
                }
                if (!heldEye.m_41619_() || !heldOcular.m_41619_()) {
                    BlockHitResult blockHitResult;
                    BlockPos pos;
                    HitResult totalAmount2;
                    stack.m_85836_();
                    RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAYS);
                    int conf = (Integer)ModConfig.instance.auraBarLocation.get();
                    if (!(mc.f_91066_.f_92063_ || conf == 2 && mc.f_91080_ instanceof ChatScreen)) {
                        int y;
                        int startX;
                        int color = IAuraType.forLevel((Level)mc.f_91073_).getColor();
                        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
                        int totalAmount2 = IAuraChunk.triangulateAuraInArea((Level)mc.f_91073_, mc.f_91074_.m_142538_(), 35);
                        float totalPercentage = (float)totalAmount2 / 2000000.0f;
                        String text = I18n.m_118938_((String)"info.naturesaura.aura_in_area", (Object[])new Object[0]);
                        float textScale = 0.75f;
                        int n = startX = conf % 2 == 0 ? 3 : res.m_85445_() - 3 - 6;
                        int startY = conf < 2 ? 10 : (!heldOcular.m_41619_() && (totalPercentage > 1.0f || totalPercentage < 0.0f) ? -26 : 0) + res.m_85446_() - 60;
                        float plusOffX = conf % 2 == 0 ? 7.0f : -7.0f;
                        float textX = conf % 2 == 0 ? 3.0f : (float)(res.m_85445_() - 3) - (float)mc.f_91062_.m_92895_(text) * textScale;
                        float textY = conf < 2 ? 3.0f : (float)(res.m_85446_() - 3 - 6);
                        int tHeight = Mth.m_14167_((float)(Mth.m_14036_((float)totalPercentage, (float)0.0f, (float)1.0f) * 50.0f));
                        int n2 = y = !heldOcular.m_41619_() && totalPercentage > 1.0f ? startY + 26 : startY;
                        if (tHeight < 50) {
                            Screen.m_93133_((PoseStack)stack, (int)startX, (int)y, (float)6.0f, (float)12.0f, (int)6, (int)(50 - tHeight), (int)256, (int)256);
                        }
                        if (tHeight > 0) {
                            Screen.m_93133_((PoseStack)stack, (int)startX, (int)(y + 50 - tHeight), (float)0.0f, (float)(62 - tHeight), (int)6, (int)tHeight, (int)256, (int)256);
                        }
                        if (!heldOcular.m_41619_()) {
                            int bottomHeight;
                            int topHeight = Mth.m_14167_((float)(Mth.m_14036_((float)((totalPercentage - 1.0f) * 2.0f), (float)0.0f, (float)1.0f) * 25.0f));
                            if (topHeight > 0) {
                                if (topHeight < 25) {
                                    Screen.m_93133_((PoseStack)stack, (int)startX, (int)startY, (float)18.0f, (float)12.0f, (int)6, (int)(25 - topHeight), (int)256, (int)256);
                                }
                                Screen.m_93133_((PoseStack)stack, (int)startX, (int)(startY + 25 - topHeight), (float)12.0f, (float)(37 - topHeight), (int)6, (int)topHeight, (int)256, (int)256);
                            }
                            if ((bottomHeight = Mth.m_14143_((float)(Mth.m_14036_((float)((totalPercentage + 1.0f) * 2.0f - 1.0f), (float)0.0f, (float)1.0f) * 25.0f))) < 25) {
                                Screen.m_93133_((PoseStack)stack, (int)startX, (int)(startY + 51), (float)18.0f, (float)12.0f, (int)6, (int)(25 - bottomHeight), (int)256, (int)256);
                                if (bottomHeight > 0) {
                                    Screen.m_93133_((PoseStack)stack, (int)startX, (int)(startY + 51 + 25 - bottomHeight), (float)12.0f, (float)(37 - bottomHeight), (int)6, (int)bottomHeight, (int)256, (int)256);
                                }
                            }
                        }
                        float f = heldOcular.m_41619_() ? 1.0f : 1.5f;
                        if (totalPercentage > f) {
                            mc.f_91062_.m_92750_(stack, "+", (float)startX + plusOffX, (float)startY - 0.5f, color);
                        }
                        float f2 = heldOcular.m_41619_() ? 0.0f : -0.5f;
                        if (totalPercentage < f2) {
                            mc.f_91062_.m_92750_(stack, "-", (float)startX + plusOffX, (float)startY - 0.5f + (float)(heldOcular.m_41619_() ? 44 : 70), color);
                        }
                        stack.m_85836_();
                        stack.m_85841_(textScale, textScale, textScale);
                        mc.f_91062_.m_92750_(stack, text, textX / textScale, textY / textScale, color);
                        stack.m_85849_();
                        if (!heldOcular.m_41619_()) {
                            float scale = 0.75f;
                            stack.m_85836_();
                            stack.m_85841_(scale, scale, scale);
                            int stackX = conf % 2 == 0 ? 10 : res.m_85445_() - 22;
                            int stackY = conf < 2 ? 15 : res.m_85446_() - 55;
                            for (Tuple<ItemStack, Boolean> effect : SHOWING_EFFECTS.values()) {
                                int theX = (int)((float)stackX / scale);
                                int theY = (int)((float)stackY / scale);
                                ItemStack itemStack = (ItemStack)effect.m_14418_();
                                Helper.renderItemInGui(itemStack, theX, theY, 1.0f);
                                if (((Boolean)effect.m_14419_()).booleanValue()) {
                                    RenderSystem.m_69465_();
                                    RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAYS);
                                    Screen.m_93133_((PoseStack)stack, (int)theX, (int)theY, (float)240.0f, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
                                    RenderSystem.m_69482_();
                                }
                                stackY += 8;
                            }
                            stack.m_85849_();
                        }
                    }
                    if ((totalAmount2 = mc.f_91077_) instanceof BlockHitResult && (pos = (blockHitResult = (BlockHitResult)totalAmount2).m_82425_()) != null) {
                        BlockEntityAuraTimer timer;
                        ItemStack itemStack;
                        IAuraContainer container;
                        BlockEntity tile = mc.f_91073_.m_7702_(pos);
                        int x = res.m_85445_() / 2;
                        int y = res.m_85446_() / 2;
                        if (tile != null && (container = (IAuraContainer)tile.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER, null).orElse(null)) != null) {
                            IAuraContainer stackCont;
                            ItemStack tileStack;
                            BlockState state = mc.f_91073_.m_8055_(pos);
                            ItemStack blockStack = state.m_60734_().getCloneItemStack(state, (HitResult)blockHitResult, (BlockGetter)mc.f_91073_, pos, (Player)mc.f_91074_);
                            this.drawContainerInfo(stack, container.getStoredAura(), container.getMaxAura(), container.getAuraColor(), mc, res, 35, blockStack.m_41786_().getString(), null);
                            if (tile instanceof BlockEntityNatureAltar && !(tileStack = ((BlockEntityNatureAltar)tile).getItemHandler().getStackInSlot(0)).m_41619_() && (stackCont = (IAuraContainer)tileStack.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER, null).orElse(null)) != null) {
                                this.drawContainerInfo(stack, stackCont.getStoredAura(), stackCont.getMaxAura(), stackCont.getAuraColor(), mc, res, 55, tileStack.m_41786_().getString(), null);
                            }
                        } else if (tile instanceof BlockEntityRFConverter) {
                            BlockEntityRFConverter.RFStorage storage = ((BlockEntityRFConverter)tile).storage;
                            this.drawContainerInfo(stack, storage.getEnergyStored(), storage.getMaxEnergyStored(), 13388054, mc, res, 35, I18n.m_118938_((String)"block.naturesaura.rf_converter", (Object[])new Object[0]), storage.getEnergyStored() + " / " + storage.getMaxEnergyStored() + " RF");
                        } else if (tile instanceof BlockEntityGratedChute) {
                            BlockEntityGratedChute chute = (BlockEntityGratedChute)tile;
                            ItemStack itemStack2 = chute.getItemHandler().getStackInSlot(0);
                            if (itemStack2.m_41619_()) {
                                mc.f_91062_.m_92750_(stack, ChatFormatting.GRAY.toString() + ChatFormatting.ITALIC + I18n.m_118938_((String)"info.naturesaura.empty", (Object[])new Object[0]), (float)(x + 5), (float)(y - 11), 0xFFFFFF);
                            } else {
                                Helper.renderItemInGui(itemStack2, x + 2, y - 18, 1.0f);
                            }
                            Helper.renderItemInGui(ITEM_FRAME, x - 24, y - 24, 1.0f);
                            RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAYS);
                            int u = chute.isBlacklist ? 240 : 224;
                            RenderSystem.m_69465_();
                            Screen.m_93133_((PoseStack)stack, (int)(x - 18), (int)(y - 18), (float)u, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
                            RenderSystem.m_69482_();
                        } else if (tile instanceof BlockEntityItemDistributor) {
                            BlockEntityItemDistributor distributor = (BlockEntityItemDistributor)tile;
                            Helper.renderItemInGui(DISPENSER, x - 24, y - 24, 1.0f);
                            RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAYS);
                            int u = !distributor.isRandomMode ? 240 : 224;
                            RenderSystem.m_69465_();
                            Screen.m_93133_((PoseStack)stack, (int)(x - 18), (int)(y - 18), (float)u, (float)0.0f, (int)16, (int)16, (int)256, (int)256);
                            RenderSystem.m_69482_();
                        } else if (tile instanceof BlockEntityAuraTimer && !(itemStack = (timer = (BlockEntityAuraTimer)tile).getItemHandler().getStackInSlot(0)).m_41619_()) {
                            Helper.renderItemInGui(itemStack, x - 20, y - 20, 1.0f);
                            mc.f_91062_.m_92750_(stack, ChatFormatting.GRAY + this.createTimeString(timer.getTotalTime()), (float)(x + 5), (float)(y - 11), 0xFFFFFF);
                            mc.f_91062_.m_92750_(stack, ChatFormatting.GRAY + I18n.m_118938_((String)"info.naturesaura.remaining", (Object[])new Object[]{this.createTimeString(timer.getTimeLeft())}), (float)(x + 5), (float)(y + 3), 0xFFFFFF);
                        }
                    }
                    RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    stack.m_85849_();
                }
                if (hoveringAuraSpot != null) {
                    NumberFormat format = NumberFormat.getInstance();
                    int amount = IAuraChunk.getAuraChunk((Level)mc.f_91073_, hoveringAuraSpot).getDrainSpot(hoveringAuraSpot);
                    ChatFormatting color = amount > 0 ? ChatFormatting.GREEN : ChatFormatting.RED;
                    mc.f_91062_.m_92750_(stack, color + format.format(amount), (float)res.m_85445_() / 2.0f + 5.0f, (float)res.m_85446_() / 2.0f - 11.0f, 0xFFFFFF);
                }
            }
        }
    }

    private String createTimeString(int totalTicks) {
        int ticks = totalTicks % 20;
        int seconds = totalTicks / 20 % 60;
        int minutes = totalTicks / 20 / 60 % 60;
        int hours = totalTicks / 20 / 60 / 60;
        return String.format("%02d:%02d:%02d.%02d", hours, minutes, seconds, ticks);
    }

    private void drawContainerInfo(PoseStack stack, int stored, int max, int color, Minecraft mc, Window res, int yOffset, String name, String textBelow) {
        RenderSystem.m_157429_((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        int x = res.m_85445_() / 2 - 40;
        int y = res.m_85446_() / 2 + yOffset;
        int width = Mth.m_14167_((float)((float)stored / (float)max * 80.0f));
        RenderSystem.m_157456_((int)0, (ResourceLocation)OVERLAYS);
        if (width < 80) {
            Screen.m_93133_((PoseStack)stack, (int)(x + width), (int)y, (float)width, (float)0.0f, (int)(80 - width), (int)6, (int)256, (int)256);
        }
        if (width > 0) {
            Screen.m_93133_((PoseStack)stack, (int)x, (int)y, (float)0.0f, (float)6.0f, (int)width, (int)6, (int)256, (int)256);
        }
        mc.f_91062_.m_92750_(stack, name, (float)(x + 40) - (float)mc.f_91062_.m_92895_(name) / 2.0f, (float)(y - 9), color);
        if (textBelow != null) {
            mc.f_91062_.m_92750_(stack, textBelow, (float)(x + 40) - (float)mc.f_91062_.m_92895_(textBelow) / 2.0f, (float)(y + 7), color);
        }
    }
}

