/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.gen;

import com.mojang.serialization.Codec;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityAuraBloom;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class LevelGenAuraBloom
extends Feature<NoneFeatureConfiguration> {
    private final Block block;
    private final int chance;
    private final boolean nether;

    public LevelGenAuraBloom(Block block, int chance, boolean nether) {
        super(Codec.unit((Object)FeatureConfiguration.f_67737_));
        this.block = block;
        this.chance = chance;
        this.nether = nether;
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel levelIn = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        Random rand = ctx.m_159776_();
        if (rand.nextInt(this.chance) != 0) {
            return false;
        }
        int startX = pos.m_123341_() + rand.nextInt(16);
        int startZ = pos.m_123343_() + rand.nextInt(16);
        boolean any = false;
        block0: for (int i = Mth.m_14072_((Random)rand, (int)3, (int)8); i > 0; --i) {
            int offX = startX + Mth.m_14072_((Random)rand, (int)-5, (int)5);
            int offZ = startZ + Mth.m_14072_((Random)rand, (int)-5, (int)5);
            if (this.nether) {
                int y = Mth.m_14072_((Random)rand, (int)0, (int)128);
                for (int off = 0; off < 64; ++off) {
                    if (!this.tryPlace(levelIn, new BlockPos(offX, y - off, offZ)) && !this.tryPlace(levelIn, new BlockPos(offX, y + off, offZ))) continue;
                    any = true;
                    continue block0;
                }
                continue;
            }
            BlockPos placePos = new BlockPos(offX, levelIn.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, offX, offZ), offZ);
            if (!this.tryPlace(levelIn, placePos)) continue;
            any = true;
        }
        return any;
    }

    private boolean tryPlace(WorldGenLevel level, BlockPos pos) {
        BlockState state = this.block.m_49966_();
        if (this.block.m_7898_(state, (LevelReader)level, pos)) {
            level.m_7731_(pos, state, 3);
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof BlockEntityAuraBloom) {
                BlockEntityAuraBloom bloom = (BlockEntityAuraBloom)tile;
                bloom.justGenerated = true;
            }
            return true;
        }
        return false;
    }
}

