/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.WeatherType;
import de.ellpeck.naturesaura.api.misc.WeightedOre;
import de.ellpeck.naturesaura.recipes.AltarRecipe;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.recipes.OfferingRecipe;
import de.ellpeck.naturesaura.recipes.TreeRitualRecipe;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class ModRecipes {
    public static final RecipeType<AltarRecipe> ALTAR_TYPE = new RecipeType();
    public static final RecipeSerializer<AltarRecipe> ALTAR_SERIAIZER = new AltarRecipe.Serializer();
    public static final RecipeType<AnimalSpawnerRecipe> ANIMAL_SPAWNER_TYPE = new RecipeType();
    public static final RecipeSerializer<AnimalSpawnerRecipe> ANIMAL_SPAWNER_SERIALIZER = new AnimalSpawnerRecipe.Serializer();
    public static final RecipeType<OfferingRecipe> OFFERING_TYPE = new RecipeType();
    public static final RecipeSerializer<OfferingRecipe> OFFERING_SERIALIZER = new OfferingRecipe.Serializer();
    public static final RecipeType<TreeRitualRecipe> TREE_RITUAL_TYPE = new RecipeType();
    public static final RecipeSerializer<TreeRitualRecipe> TREE_RITUAL_SERIALIZER = new TreeRitualRecipe.Serializer();

    public static void register(IForgeRegistry<RecipeSerializer<?>> registry) {
        ModRecipes.register(registry, "altar", ALTAR_TYPE, ALTAR_SERIAIZER);
        ModRecipes.register(registry, "animal_spawner", ANIMAL_SPAWNER_TYPE, ANIMAL_SPAWNER_SERIALIZER);
        ModRecipes.register(registry, "offering", OFFERING_TYPE, OFFERING_SERIALIZER);
        ModRecipes.register(registry, "tree_ritual", TREE_RITUAL_TYPE, TREE_RITUAL_SERIALIZER);
    }

    public static void init() {
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.f_50652_.m_49966_(), (Object)Blocks.f_50079_.m_49966_());
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.f_50222_.m_49966_(), (Object)Blocks.f_50223_.m_49966_());
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.f_50274_.m_49966_(), (Object)Blocks.f_50275_.m_49966_());
        NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.put((Object)Blocks.f_50609_.m_49966_(), (Object)Blocks.f_50607_.m_49966_());
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/coal", 5000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/coal", 5000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/iron", 3000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/iron", 3000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/gold", 500);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/gold", 500);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/diamond", 50);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/diamond", 50);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/lapis", 250);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/lapis", 250);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/redstone", 200);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/redstone", 200);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/emerald", 30);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/emerald", 30);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/quartz", 8000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/netherite_scrap", 30);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/copper", 2000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/copper", 2000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/tin", 1800);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/tin", 1800);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/lead", 1500);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/lead", 1500);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/silver", 1000);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/silver", 1000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/nickel", 100);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/nickel", 100);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/platinum", 20);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/nether/platinum", 20);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/aluminum", 1200);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/aluminium", 1200);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/osmium", 1500);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/zinc", 1000);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/yellorite", 1200);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/uranium", 400);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/apatite", 700);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/ruby", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/peridot", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/topaz", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/tanzanite", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/malachite", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/sapphire", 40);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/amber", 150);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/resonating", 50);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/sulfur", 600);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/saltpeter", 250);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/firestone", 30);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/salt", 2900);
        ModRecipes.ore(NaturesAuraAPI.OVERWORLD_ORES, "ores/draconium", 5);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/cobalt", 50);
        ModRecipes.ore(NaturesAuraAPI.NETHER_ORES, "ores/ardite", 50);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20483_, 10000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20477_, 7000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20527_, 35000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20484_, 50000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20485_, 200000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20548_, 30000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20478_, 40000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20522_, 300000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20467_, 100000);
        NaturesAuraAPI.PROJECTILE_GENERATIONS.put(EntityType.f_20487_, 3000000);
        NaturesAuraAPI.WEATHER_CHANGER_CONVERSIONS.put(new ItemStack((ItemLike)Blocks.f_50355_), WeatherType.SUN);
        NaturesAuraAPI.WEATHER_CHANGER_CONVERSIONS.put(new ItemStack((ItemLike)Items.f_42194_), WeatherType.RAIN);
        NaturesAuraAPI.WEATHER_CHANGER_CONVERSIONS.put(new ItemStack((ItemLike)Items.f_42613_), WeatherType.THUNDERSTORM);
    }

    private static void ore(List<WeightedOre> list, String name, int weight) {
        ResourceLocation res = new ResourceLocation("forge", name);
        list.add(new WeightedOre(res, weight));
    }

    private static void register(IForgeRegistry<RecipeSerializer<?>> registry, String name, RecipeType<?> type, RecipeSerializer<?> serializer) {
        ResourceLocation res = new ResourceLocation("naturesaura", name);
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)res, type);
        registry.register((IForgeRegistryEntry)((RecipeSerializer)serializer.setRegistryName(res)));
    }

    public static JsonObject serializeStack(ItemStack stack) {
        CompoundTag nbt = stack.m_41739_(new CompoundTag());
        byte c = nbt.m_128445_("Count");
        if (c != 1) {
            nbt.m_128344_("count", c);
        }
        nbt.m_128473_("Count");
        ModRecipes.renameTag(nbt, "id", "item");
        ModRecipes.renameTag(nbt, "tag", "nbt");
        Dynamic dyn = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt);
        return ((JsonElement)dyn.convert((DynamicOps)JsonOps.INSTANCE).getValue()).getAsJsonObject();
    }

    private static void renameTag(CompoundTag nbt, String oldName, String newName) {
        Tag tag = nbt.m_128423_(oldName);
        if (tag != null) {
            nbt.m_128473_(oldName);
            nbt.m_128365_(newName, tag);
        }
    }

    private static class RecipeType<T extends Recipe<?>>
    implements net.minecraft.world.item.crafting.RecipeType<T> {
        private RecipeType() {
        }

        public String toString() {
            return Registry.f_122864_.m_7981_((Object)this).toString();
        }
    }
}

