/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.types;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.NotNull;

public enum BarrelType implements StringRepresentable
{
    ZERO(0, "0perc", MaterialColor.f_76411_),
    TWENTY(1, "20perc", MaterialColor.f_76411_),
    FORTY(2, "40perc", MaterialColor.f_76411_),
    SIXTY(3, "60perc", MaterialColor.f_76411_),
    EIGHTY(4, "80perc", MaterialColor.f_76411_),
    HUNDRED(5, "100perc", MaterialColor.f_76411_),
    WORKING(6, "working", MaterialColor.f_76411_),
    DONE(7, "done", MaterialColor.f_76411_);

    private static final BarrelType[] META_LOOKUP;
    private final int meta;
    private final String name;
    private final String unlocalizedName;
    private final MaterialColor mapColor;

    private BarrelType(int metaIn, String nameIn, MaterialColor mapColorIn) {
        this(metaIn, nameIn, nameIn, mapColorIn);
    }

    private BarrelType(int metaIn, String nameIn, String unlocalizedNameIn, MaterialColor mapColorIn) {
        this.meta = metaIn;
        this.name = nameIn;
        this.unlocalizedName = unlocalizedNameIn;
        this.mapColor = mapColorIn;
    }

    public static BarrelType byMetadata(int meta) {
        int tempMeta = meta;
        if (tempMeta < 0 || tempMeta >= META_LOOKUP.length) {
            tempMeta = 0;
        }
        return META_LOOKUP[tempMeta];
    }

    public int getMetadata() {
        return this.meta;
    }

    public MaterialColor getMaterialColor() {
        return this.mapColor;
    }

    public String toString() {
        return this.name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return this.unlocalizedName;
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    static {
        META_LOOKUP = new BarrelType[BarrelType.values().length];
        BarrelType[] barrelTypeArray = BarrelType.values();
        int n = barrelTypeArray.length;
        for (int i = 0; i < n; ++i) {
            BarrelType enumtype;
            BarrelType.META_LOOKUP[enumtype.getMetadata()] = enumtype = barrelTypeArray[i];
        }
    }
}

