/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.NotNull;

public interface IColonyTagCapability {
    public void removeColony(int var1, LevelChunk var2);

    public void addColony(int var1, LevelChunk var2);

    @NotNull
    public List<Integer> getAllCloseColonies();

    public void setOwningColony(int var1, LevelChunk var2);

    public int getOwningColony();

    public void reset(LevelChunk var1);

    public void addBuildingClaim(int var1, BlockPos var2, LevelChunk var3);

    public void removeBuildingClaim(int var1, BlockPos var2, LevelChunk var3);

    public void setCloseColonies(List<Integer> var1);

    @NotNull
    public Map<Integer, Set<BlockPos>> getAllClaimingBuildings();

    public void readFromNBT(CompoundTag var1);

    public static class Storage {
        public static Tag writeNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable Direction side) {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("id", instance.getOwningColony());
            compound.m_128365_("colonies", (Tag)instance.getAllCloseColonies().stream().map(Storage::write).collect(NBTUtils.toListNBT()));
            compound.m_128365_("buildingsClaim", (Tag)instance.getAllClaimingBuildings().entrySet().stream().map(Storage::writeClaims).collect(NBTUtils.toListNBT()));
            return compound;
        }

        public static void readNBT(@NotNull Capability<IColonyTagCapability> capability, @NotNull IColonyTagCapability instance, @Nullable Direction side, @NotNull Tag nbt) {
            if (nbt instanceof CompoundTag && ((CompoundTag)nbt).m_128441_("id")) {
                instance.readFromNBT((CompoundTag)nbt);
            }
        }

        private static CompoundTag write(int id) {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("id", id);
            return compound;
        }

        private static CompoundTag writeClaims(@NotNull Map.Entry<Integer, Set<BlockPos>> entry) {
            CompoundTag compound = new CompoundTag();
            compound.m_128405_("id", entry.getKey().intValue());
            compound.m_128365_("buildings", (Tag)entry.getValue().stream().map(pos -> BlockPosUtil.write(new CompoundTag(), "building", pos)).collect(NBTUtils.toListNBT()));
            return compound;
        }
    }

    public static class Impl
    implements IColonyTagCapability {
        private Set<Integer> colonies = new HashSet<Integer>();
        private int owningColony = 0;
        private final Map<Integer, Set<BlockPos>> claimingBuildings = new HashMap<Integer, Set<BlockPos>>();

        @Override
        public void addColony(int id, LevelChunk chunk) {
            this.colonies.add(id);
            chunk.m_8092_(true);
        }

        @Override
        public void removeColony(int id, LevelChunk chunk) {
            this.colonies.remove(id);
            if (this.owningColony == id) {
                this.owningColony = 0;
            }
            chunk.m_8092_(true);
        }

        @Override
        public void setCloseColonies(List<Integer> colonies) {
            this.colonies = new HashSet<Integer>(colonies);
        }

        @Override
        public void reset(LevelChunk chunk) {
            this.colonies.clear();
            this.owningColony = 0;
            this.claimingBuildings.clear();
            chunk.m_8092_(true);
        }

        @Override
        public void addBuildingClaim(int colonyId, BlockPos pos, LevelChunk chunk) {
            if (this.owningColony == 0) {
                this.setOwningColony(colonyId, chunk);
            }
            if (this.claimingBuildings.containsKey(colonyId)) {
                this.claimingBuildings.get(colonyId).add(pos);
            } else {
                HashSet<BlockPos> newList = new HashSet<BlockPos>();
                newList.add(pos);
                this.claimingBuildings.put(colonyId, newList);
            }
            chunk.m_8092_(true);
        }

        @Override
        public void removeBuildingClaim(int colonyId, BlockPos pos, LevelChunk chunk) {
            if (this.claimingBuildings.containsKey(colonyId)) {
                Set<BlockPos> buildings = this.claimingBuildings.get(colonyId);
                buildings.remove(pos);
                if (buildings.isEmpty()) {
                    this.claimingBuildings.remove(colonyId);
                }
                if (this.owningColony == colonyId) {
                    if (this.claimingBuildings.isEmpty()) {
                        this.reset(chunk);
                    } else if (this.claimingBuildings.size() == 1) {
                        this.setOwningColony(this.claimingBuildings.keySet().iterator().next(), chunk);
                    } else {
                        this.setOwningColony(this.claimingBuildings.keySet().toArray(new Integer[0])[new Random().nextInt(this.claimingBuildings.size())], chunk);
                    }
                }
            }
            chunk.m_8092_(true);
        }

        @Override
        public void setOwningColony(int id, LevelChunk chunk) {
            this.owningColony = id;
            chunk.m_8092_(true);
        }

        @Override
        public int getOwningColony() {
            return this.owningColony;
        }

        @Override
        @NotNull
        public List<Integer> getAllCloseColonies() {
            return new ArrayList<Integer>(this.colonies);
        }

        @Override
        @NotNull
        public Map<Integer, Set<BlockPos>> getAllClaimingBuildings() {
            return this.claimingBuildings;
        }

        @Override
        public void readFromNBT(CompoundTag compound) {
            this.owningColony = compound.m_128451_("id");
            NBTUtils.streamCompound(compound.m_128437_("colonies", 10)).map(c -> c.m_128451_("id")).forEach(this.colonies::add);
            NBTUtils.streamCompound(compound.m_128437_("buildingsClaim", 10)).forEach(this::readClaims);
        }

        private void readClaims(CompoundTag compound) {
            int id = compound.m_128451_("id");
            NBTUtils.streamCompound(compound.m_128437_("buildings", 10)).forEach(tag -> {
                BlockPos pos = BlockPosUtil.read(tag, "building");
                if (this.claimingBuildings.containsKey(id)) {
                    this.claimingBuildings.get(id).add(pos);
                } else {
                    HashSet<BlockPos> newList = new HashSet<BlockPos>();
                    newList.add(pos);
                    this.claimingBuildings.put(id, newList);
                }
            });
        }
    }
}

