/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.interactionhandling;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;

public final class InteractionValidatorRegistry {
    private static Map<Component, Predicate<ICitizenData>> map = new HashMap<Component, Predicate<ICitizenData>>();
    private static Map<Component, BiPredicate<ICitizenData, BlockPos>> posMap = new HashMap<Component, BiPredicate<ICitizenData, BlockPos>>();
    private static Map<Component, BiPredicate<ICitizenData, IToken<?>>> tokenMap = new HashMap();

    public static Predicate<ICitizenData> getStandardInteractionValidatorPredicate(Component key) {
        return map.get(key);
    }

    public static BiPredicate<ICitizenData, BlockPos> getPosBasedInteractionValidatorPredicate(Component key) {
        return posMap.get(key);
    }

    public static BiPredicate<ICitizenData, IToken<?>> getTokenBasedInteractionValidatorPredicate(Component key) {
        return tokenMap.get(key);
    }

    public static void registerStandardPredicate(Component key, Predicate<ICitizenData> predicate) {
        map.put(key, predicate);
    }

    public static void registerPosBasedPredicate(Component key, BiPredicate<ICitizenData, BlockPos> predicate) {
        posMap.put(key, predicate);
    }

    public static void registerTokenBasedPredicate(Component key, BiPredicate<ICitizenData, IToken<?>> predicate) {
        tokenMap.put(key, predicate);
    }

    public static boolean hasValidator(TranslatableComponent component) {
        return map.containsKey(component) || posMap.containsKey(component) || tokenMap.containsKey(component);
    }

    private InteractionValidatorRegistry() {
    }
}

