/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeCompat;
import com.minecolonies.api.compatibility.resourcefulbees.ResourcefulBeesCompat;
import com.minecolonies.api.compatibility.tinkers.SlimeTreeCheck;
import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockStateStorage;
import com.minecolonies.api.util.Disease;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.OreBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CompatibilityManager
implements ICompatibilityManager {
    private final Map<BlockStateStorage, ItemStorage> leavesToSaplingMap = new HashMap<BlockStateStorage, ItemStorage>();
    private final List<ItemStorage> saplings = new ArrayList<ItemStorage>();
    private final List<Property<?>> leafCompareWithoutProperties = ImmutableList.of((Object)checkDecay, (Object)decayable, (Object)DYN_PROP_HYDRO, (Object)TREE_DISTANCE);
    private static final BooleanProperty checkDecay = BooleanProperty.m_61465_((String)"check_decay");
    private static final BooleanProperty decayable = BooleanProperty.m_61465_((String)"decayable");
    public static final IntegerProperty DYN_PROP_HYDRO = IntegerProperty.m_61631_((String)"hydro", (int)1, (int)4);
    public static final IntegerProperty TREE_DISTANCE = IntegerProperty.m_61631_((String)"distance", (int)1, (int)7);
    private final Set<Block> oreBlocks = new HashSet<Block>();
    private final Set<ItemStorage> smeltableOres = new HashSet<ItemStorage>();
    private final Map<Item, CompostRecipe> compostRecipes = new HashMap<Item, CompostRecipe>();
    private final Set<ItemStorage> plantables = new HashSet<ItemStorage>();
    private final Set<ItemStorage> fuel = new HashSet<ItemStorage>();
    private final Set<ItemStorage> food = new HashSet<ItemStorage>();
    private final Set<ItemStorage> edibles = new HashSet<ItemStorage>();
    private final Map<String, Disease> diseases = new HashMap<String, Disease>();
    private final List<String> diseaseList = new ArrayList<String>();
    private final List<ItemStorage> luckyOres = new ArrayList<ItemStorage>();
    private final List<Tuple<Item, Integer>> recruitmentCostsWeights = new ArrayList<Tuple<Item, Integer>>();
    private static final Random random = new Random();
    private static ImmutableList<ItemStack> allItems = ImmutableList.of();
    private static ImmutableSet<ItemStorage> allItemsSet = ImmutableSet.of();
    private final Set<Block> freeBlocks = new HashSet<Block>();
    private final Set<BlockPos> freePositions = new HashSet<BlockPos>();
    private ImmutableSet<ResourceLocation> monsters = ImmutableSet.of();

    @Override
    public void discover(@NotNull RecipeManager recipeManager) {
        this.saplings.clear();
        this.oreBlocks.clear();
        this.smeltableOres.clear();
        this.plantables.clear();
        this.food.clear();
        this.edibles.clear();
        this.fuel.clear();
        this.compostRecipes.clear();
        this.luckyOres.clear();
        this.recruitmentCostsWeights.clear();
        this.diseases.clear();
        this.diseaseList.clear();
        this.freeBlocks.clear();
        this.freePositions.clear();
        this.monsters = ImmutableSet.of();
        this.discoverAllItems();
        this.discoverSaplings();
        this.discoverOres();
        this.discoverPlantables();
        this.discoverFood();
        this.discoverFuel();
        this.discoverMobs();
        this.discoverCompostRecipes(recipeManager);
        this.discoverLuckyOres();
        this.discoverRecruitCosts();
        this.discoverDiseases();
        this.discoverFreeBlocksAndPos();
        this.discoverModCompat();
    }

    @Override
    public List<ItemStack> getListOfAllItems() {
        return allItems;
    }

    @Override
    public Set<ItemStorage> getSetOfAllItems() {
        return allItemsSet;
    }

    @Override
    public boolean isPlantable(ItemStack itemStack) {
        return !itemStack.m_41619_() && itemStack.m_41720_() instanceof BlockItem && ModTags.floristFlowers.m_8110_((Object)itemStack.m_41720_());
    }

    @Override
    public boolean isLuckyBlock(Block block) {
        return ModTags.oreChanceBlocks.m_8110_((Object)block);
    }

    @Override
    public ItemStack getSaplingForLeaf(BlockState block) {
        BlockStateStorage tempLeaf = new BlockStateStorage(block, this.leafCompareWithoutProperties, true);
        if (this.leavesToSaplingMap.containsKey(tempLeaf)) {
            return this.leavesToSaplingMap.get(tempLeaf).getItemStack();
        }
        return null;
    }

    @Override
    public Set<ItemStorage> getCopyOfSaplings() {
        return new HashSet<ItemStorage>(this.saplings);
    }

    @Override
    public Set<ItemStorage> getFuel() {
        return this.fuel;
    }

    @Override
    public Set<ItemStorage> getFood() {
        return this.food;
    }

    @Override
    public Set<ItemStorage> getEdibles() {
        return this.edibles;
    }

    @Override
    public Set<ItemStorage> getSmeltableOres() {
        return this.smeltableOres;
    }

    @Override
    public Map<Item, CompostRecipe> getCopyOfCompostRecipes() {
        return ImmutableMap.copyOf(this.compostRecipes);
    }

    @Override
    public Set<ItemStorage> getCompostInputs() {
        return this.compostRecipes.keySet().stream().map(item -> new ItemStorage(new ItemStack((ItemLike)item))).collect(Collectors.toSet());
    }

    @Override
    public Set<ItemStorage> getCopyOfPlantables() {
        return new HashSet<ItemStorage>(this.plantables);
    }

    @Override
    public String getRandomDisease() {
        return this.diseaseList.get(random.nextInt(this.diseaseList.size()));
    }

    @Override
    public Disease getDisease(String disease) {
        return this.diseases.get(disease);
    }

    @Override
    public List<Disease> getDiseases() {
        return new ArrayList<Disease>(this.diseases.values());
    }

    @Override
    public List<Tuple<Item, Integer>> getRecruitmentCostsWeights() {
        return Collections.unmodifiableList(this.recruitmentCostsWeights);
    }

    @Override
    public boolean isOre(BlockState block) {
        if (block.m_60734_() instanceof OreBlock || block.m_60734_() instanceof RedStoneOreBlock) {
            return true;
        }
        return this.oreBlocks.contains(block.m_60734_());
    }

    @Override
    public boolean isOre(@NotNull ItemStack stack) {
        if (this.isMineableOre(stack) || stack.m_150922_(ModTags.raw_ore) || stack.m_150922_(ModTags.breakable_ore)) {
            ItemStack smeltingResult = MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack);
            return ModTags.breakable_ore.m_8110_((Object)stack.m_41720_()) || !smeltingResult.m_41619_();
        }
        return false;
    }

    @Override
    public boolean isMineableOre(@NotNull ItemStack stack) {
        return ItemStackUtils.isEmpty(stack) == false && stack.m_150922_((Tag)Tags.Items.ORES);
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        @NotNull ListTag saplingsLeavesTagList = this.leavesToSaplingMap.entrySet().stream().filter(entry -> entry.getKey() != null).map(entry -> CompatibilityManager.writeLeafSaplingEntryToNBT(((BlockStateStorage)entry.getKey()).getState(), (ItemStorage)entry.getValue())).collect(NBTUtils.toListNBT());
        compound.m_128365_("tagSapLeaves", (net.minecraft.nbt.Tag)saplingsLeavesTagList);
    }

    @Override
    public void read(@NotNull CompoundTag compound) {
        NBTUtils.streamCompound(compound.m_128437_("tagSapLeaves", 10)).map(CompatibilityManager::readLeafSaplingEntryFromNBT).filter(key -> !this.leavesToSaplingMap.containsKey(new BlockStateStorage((BlockState)key.getA(), this.leafCompareWithoutProperties, true)) && !this.leavesToSaplingMap.containsValue(key.getB())).forEach(key -> this.leavesToSaplingMap.put(new BlockStateStorage((BlockState)key.getA(), this.leafCompareWithoutProperties, true), (ItemStorage)key.getB()));
    }

    @Override
    public void connectLeafToSapling(BlockState leaf, ItemStack stack) {
        BlockStateStorage store = new BlockStateStorage(leaf, this.leafCompareWithoutProperties, true);
        if (!this.leavesToSaplingMap.containsKey(store)) {
            this.leavesToSaplingMap.put(store, new ItemStorage(stack, false, true));
        }
    }

    @Override
    public ItemStack getRandomLuckyOre(double chanceBonus) {
        if (random.nextDouble() * 100.0 <= (double)((Integer)MinecoloniesAPIProxy.getInstance().getConfig().getServer().luckyBlockChance.get()).intValue() * chanceBonus) {
            return this.luckyOres.get(random.nextInt(this.luckyOres.size())).getItemStack().m_41777_();
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean isFreeBlock(Block block) {
        return this.freeBlocks.contains(block);
    }

    @Override
    public boolean isFreePos(BlockPos block) {
        return this.freePositions.contains(block);
    }

    @Override
    public ImmutableSet<ResourceLocation> getAllMonsters() {
        return this.monsters;
    }

    private void discoverMobs() {
        HashSet<ResourceLocation> monsterSet = new HashSet<ResourceLocation>();
        for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
            if (((EntityType)entry.getValue()).m_20674_() == MobCategory.MONSTER) {
                monsterSet.add(((ResourceKey)entry.getKey()).m_135782_());
                continue;
            }
            if (!ModTags.hostile.m_8110_((Object)((EntityType)entry.getValue()))) continue;
            monsterSet.add(((ResourceKey)entry.getKey()).m_135782_());
        }
        this.monsters = ImmutableSet.copyOf(monsterSet);
    }

    private void discoverAllItems() {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            NonNullList list = NonNullList.m_122779_();
            item.m_6787_(CreativeModeTab.f_40754_, list);
            listBuilder.addAll((Iterable)list);
            for (ItemStack stack : list) {
                setBuilder.add((Object)new ItemStorage(stack, true));
            }
        }
        allItems = listBuilder.build();
        allItemsSet = setBuilder.build();
    }

    private void discoverOres() {
        if (this.smeltableOres.isEmpty()) {
            HashSet m = new HashSet();
            m.addAll(Tags.Items.ORES.m_6497_());
            m.addAll(ModTags.breakable_ore.m_6497_());
            m.addAll(ModTags.raw_ore.m_6497_());
            for (Item item : m) {
                NonNullList list = NonNullList.m_122779_();
                item.m_6787_(CreativeModeTab.f_40754_, list);
                for (ItemStack stack : list) {
                    if (stack.m_41720_() instanceof BlockItem) {
                        this.oreBlocks.add(((BlockItem)stack.m_41720_()).m_40614_());
                    }
                    if (MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack).m_41619_()) continue;
                    this.smeltableOres.add(new ItemStorage(stack));
                }
            }
        }
        Log.getLogger().info("Finished discovering Ores " + this.oreBlocks.size() + " " + this.smeltableOres.size());
    }

    private void discoverSaplings() {
        for (Item item : ItemTags.f_13180_.m_6497_()) {
            NonNullList list = NonNullList.m_122779_();
            item.m_6787_(CreativeModeTab.f_40754_, list);
            for (ItemStack stack : list) {
                this.saplings.add(new ItemStorage(stack, false, true));
            }
        }
        Log.getLogger().info("Finished discovering saplings " + this.saplings.size());
    }

    private void discoverCompostRecipes(@NotNull RecipeManager recipeManager) {
        if (this.compostRecipes.isEmpty()) {
            for (Recipe r : recipeManager.m_44054_(CompostRecipe.TYPE).values()) {
                CompostRecipe recipe = (CompostRecipe)r;
                for (ItemStack stack : recipe.getInput().m_43908_()) {
                    this.compostRecipes.merge(stack.m_41720_(), recipe, (r1, r2) -> r1.getStrength() < r2.getStrength() ? r1 : r2);
                }
            }
            Log.getLogger().info("Finished discovering compostables " + this.compostRecipes.size());
        }
    }

    private void discoverPlantables() {
        if (this.plantables.isEmpty()) {
            for (Item item : ModTags.floristFlowers.m_6497_()) {
                NonNullList list = NonNullList.m_122779_();
                item.m_6787_(CreativeModeTab.f_40754_, list);
                for (ItemStack stack : list) {
                    if (!(stack.m_41720_() instanceof BlockItem)) continue;
                    this.plantables.add(new ItemStorage(stack));
                }
            }
        }
        Log.getLogger().info("Finished discovering plantables " + this.plantables.size());
    }

    private void discoverFuel() {
        if (this.fuel.isEmpty()) {
            for (ItemStack item : allItems) {
                if (!FurnaceBlockEntity.m_58399_((ItemStack)item)) continue;
                this.fuel.add(new ItemStorage(item));
            }
        }
        Log.getLogger().info("Finished discovering fuel " + this.fuel.size());
    }

    private void discoverFood() {
        if (this.food.isEmpty()) {
            for (ItemStack item : allItems) {
                if (!ItemStackUtils.ISFOOD.test(item) && !ItemStackUtils.ISCOOKABLE.test(item)) continue;
                this.food.add(new ItemStorage(item));
                if (!ItemStackUtils.CAN_EAT.test(item)) continue;
                this.edibles.add(new ItemStorage(item));
            }
        }
        Log.getLogger().info("Finished discovering food " + this.edibles.size() + " " + this.food.size());
    }

    private void discoverLuckyOres() {
        if (this.luckyOres.isEmpty()) {
            for (String ore : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().luckyOres.get()) {
                String[] split = ore.split("!");
                if (split.length < 2) {
                    Log.getLogger().warn("Wrong configured ore: " + ore);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
                if (item == null || item == Items.f_41852_) {
                    Log.getLogger().warn("Invalid lucky block: " + ore);
                    continue;
                }
                ItemStack stack = new ItemStack((ItemLike)item, 1);
                try {
                    int rarity = Integer.parseInt(split[split.length - 1]);
                    for (int i = 0; i < rarity; ++i) {
                        this.luckyOres.add(new ItemStorage(stack));
                    }
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Ore has invalid rarity: " + ore);
                }
            }
        }
        Log.getLogger().info("Finished discovering lucky oreBlocks " + this.luckyOres.size());
    }

    private void discoverRecruitCosts() {
        if (this.recruitmentCostsWeights.isEmpty()) {
            for (String itemString : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().configListRecruitmentItems.get()) {
                String[] split = itemString.split(";");
                if (split.length < 2) {
                    Log.getLogger().warn("Wrong configured recruitment cost: " + itemString);
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0]));
                if (item == null || item == Items.f_41852_) {
                    Log.getLogger().warn("Invalid recruitment item: " + item);
                    continue;
                }
                try {
                    int rarity = Integer.parseInt(split[split.length - 1]);
                    this.recruitmentCostsWeights.add(new Tuple<Item, Integer>(item, rarity));
                }
                catch (NumberFormatException ex) {
                    Log.getLogger().warn("Invalid recruitment weight for: " + item);
                }
            }
        }
        Log.getLogger().info("Finished discovering recruitment costs");
    }

    private void discoverDiseases() {
        if (this.diseases.isEmpty()) {
            for (String disease : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().diseases.get()) {
                String[] split = disease.split(",");
                if (split.length < 3) {
                    Log.getLogger().warn("Wrongly configured disease: " + disease);
                    continue;
                }
                try {
                    int i;
                    String name = split[0];
                    int rarity = Integer.parseInt(split[1]);
                    ArrayList<ItemStack> cure = new ArrayList<ItemStack>();
                    for (i = 2; i < split.length; ++i) {
                        String[] theItem = split[i].split(":");
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(theItem[0], theItem[1]));
                        if (item == null || item == Items.f_41852_) {
                            Log.getLogger().warn("Invalid cure item: " + disease);
                            continue;
                        }
                        ItemStack stack = new ItemStack((ItemLike)item, 1);
                        cure.add(stack);
                    }
                    this.diseases.put(name, new Disease(name, rarity, cure));
                    for (i = 0; i < rarity; ++i) {
                        this.diseaseList.add(name);
                    }
                }
                catch (NumberFormatException e) {
                    Log.getLogger().warn("Wrongly configured disease: " + disease);
                }
            }
        }
        Log.getLogger().info("Finished discovering diseases");
    }

    private static CompoundTag writeLeafSaplingEntryToNBT(BlockState state, ItemStorage storage) {
        CompoundTag compound = NbtUtils.m_129202_((BlockState)state);
        storage.getItemStack().m_41739_(compound);
        return compound;
    }

    private static Tuple<BlockState, ItemStorage> readLeafSaplingEntryFromNBT(CompoundTag compound) {
        return new Tuple<BlockState, ItemStorage>(NbtUtils.m_129241_((CompoundTag)compound), new ItemStorage(ItemStack.m_41712_((CompoundTag)compound), false, true));
    }

    private void discoverFreeBlocksAndPos() {
        for (String s : (List)MinecoloniesAPIProxy.getInstance().getConfig().getServer().freeToInteractBlocks.get()) {
            try {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null || block instanceof AirBlock) continue;
                this.freeBlocks.add(block);
            }
            catch (Exception ex) {
                BlockPos pos = BlockPosUtil.getBlockPosOfString(s);
                if (pos == null) continue;
                this.freePositions.add(pos);
            }
        }
    }

    private void discoverModCompat() {
        if (ModList.get().isLoaded("resourcefulbees")) {
            Compatibility.beeHiveCompat = new ResourcefulBeesCompat();
        }
        if (ModList.get().isLoaded("tconstruct")) {
            Compatibility.tinkersCompat = new TinkersToolHelper();
            Compatibility.tinkersSlimeCompat = new SlimeTreeCheck();
        }
        if (ModList.get().isLoaded("dynamictrees")) {
            Compatibility.dynamicTreesCompat = new DynamicTreeCompat();
        }
    }

    public static Set<ItemStorage> getAllBeekeeperFlowers() {
        HashSet<ItemStorage> flowers = new HashSet<ItemStorage>();
        for (Item item : ItemTags.f_13149_.m_6497_()) {
            NonNullList list = NonNullList.m_122779_();
            item.m_6787_(CreativeModeTab.f_40754_, list);
            for (ItemStack stack : list) {
                flowers.add(new ItemStorage(stack));
            }
        }
        return flowers;
    }
}

