/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;

public class CountedIngredient
extends Ingredient {
    public static final ResourceLocation ID = new ResourceLocation("minecolonies", "counted");
    @NotNull
    private final Ingredient child;
    private final int count;
    private ItemStack[] array = null;

    public CountedIngredient(@NotNull Ingredient child, int count) {
        super(Arrays.stream(child.m_43908_()).map(Ingredient.ItemValue::new));
        this.child = child;
        this.count = count;
    }

    @NotNull
    public Ingredient getChild() {
        return this.child;
    }

    public int getCount() {
        return this.count;
    }

    @NotNull
    public ItemStack[] m_43908_() {
        if (this.array == null) {
            List<ItemStack> matchingStacks = Arrays.stream(this.child.m_43908_()).map(ItemStack::m_41777_).collect(Collectors.toList());
            matchingStacks.forEach(s -> s.m_41764_(this.count));
            this.array = matchingStacks.toArray(new ItemStack[matchingStacks.size()]);
        }
        return this.array;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.getInstance();
    }

    public static class Serializer
    implements IIngredientSerializer<CountedIngredient> {
        private static final Serializer INSTANCE = new Serializer();

        public static Serializer getInstance() {
            return INSTANCE;
        }

        private Serializer() {
        }

        @NotNull
        public CountedIngredient parse(@NotNull JsonObject json) {
            Ingredient child = Ingredient.m_43917_((JsonElement)json.get("item"));
            int count = GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1);
            return new CountedIngredient(child, count);
        }

        @NotNull
        public CountedIngredient parse(@NotNull FriendlyByteBuf buffer) {
            int count = buffer.m_130242_();
            Ingredient child = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            return new CountedIngredient(child, count);
        }

        public void write(@NotNull FriendlyByteBuf buffer, @NotNull CountedIngredient ingredient) {
            buffer.m_130130_(ingredient.getCount());
            CraftingHelper.write((FriendlyByteBuf)buffer, (Ingredient)ingredient.getChild());
        }
    }
}

