/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.AbstractRecipeType;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IRecipeStorage {
    public List<ItemStorage> getInput();

    public List<ItemStorage> getCleanedInput();

    public ItemStack getPrimaryOutput();

    public int getGridSize();

    public Block getIntermediate();

    public boolean canFullFillRecipe(int var1, Map<ItemStorage, Integer> var2, IItemHandler ... var3);

    public boolean canFullFillRecipe(int var1, Map<ItemStorage, Integer> var2, @NotNull List<IItemHandler> var3, @NotNull IBuilding var4);

    default public boolean fullFillRecipe(@NotNull Level world, IItemHandler ... inventories) {
        return this.fullfillRecipe(world, Arrays.asList(inventories));
    }

    default public boolean fullFillRecipe(@NotNull LootContext context, IItemHandler ... inventories) {
        return this.fullfillRecipe(context, Arrays.asList(inventories));
    }

    default public boolean fullfillRecipe(LootContext context, List<IItemHandler> handlers) {
        return this.fullfillRecipeAndCopy(context, handlers) != null;
    }

    default public boolean fullfillRecipe(Level world, List<IItemHandler> handlers) {
        return this.fullfillRecipeAndCopy(world, handlers) != null;
    }

    @Nullable
    public List<ItemStack> fullfillRecipeAndCopy(LootContext var1, List<IItemHandler> var2);

    @Nullable
    default public List<ItemStack> fullfillRecipeAndCopy(Level world, List<IItemHandler> handlers) {
        return this.fullfillRecipeAndCopy(new LootContext.Builder((ServerLevel)world).m_78975_(LootContextParamSets.f_81410_), handlers);
    }

    public AbstractRecipeType<IRecipeStorage> getRecipeType();

    public List<ItemStack> getAlternateOutputs();

    public RecipeStorage getClassicForMultiOutput(ItemStack var1);

    public RecipeStorage getClassicForMultiOutput(Predicate<ItemStack> var1);

    public ResourceLocation getRecipeSource();

    public List<ItemStack> getSecondaryOutputs();

    public List<ItemStack> getCraftingToolsAndSecondaryOutputs();

    public List<ItemStack> getCraftingTools();

    public ResourceLocation getLootTable();

    public IToken<?> getToken();
}

