/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen;

import com.google.common.collect.Lists;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.MinecoloniesMinecart;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStatusHandler;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.PathingStuckHandler;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityCitizen
extends AbstractCivilianEntity
implements MenuProvider {
    private static final double CITIZEN_SWIM_BONUS = 2.0;
    public static final EntityDataAccessor<Integer> DATA_LEVEL = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_TEXTURE = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_IS_FEMALE = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_COLONY_ID = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_CITIZEN_ID = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> DATA_MODEL = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_RENDER_METADATA = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> DATA_IS_ASLEEP = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_IS_CHILD = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<BlockPos> DATA_BED_POS = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<String> DATA_STYLE = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_TEXTURE_SUFFIX = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_JOB = SynchedEntityData.m_135353_(AbstractEntityCitizen.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private ResourceLocation modelId = ModModelTypes.SETTLER_ID;
    private int textureId;
    private String renderMetadata = "";
    private boolean female;
    private ResourceLocation texture;
    private boolean textureDirty = true;
    private AbstractAdvancedPathNavigate pathNavigate;
    private int collisionCounter = 0;
    private static final int COLL_THRESHOLD = 50;
    private boolean isEquipmentDirty = true;

    public AbstractEntityCitizen(EntityType<? extends AgeableMob> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder getDefaultAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22277_, 100.0);
    }

    public GoalSelector getTasks() {
        return this.f_21345_;
    }

    public int getTicksExisted() {
        return this.f_19797_;
    }

    @NotNull
    public BlockPos m_142538_() {
        return new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public boolean m_21531_() {
        return false;
    }

    public boolean m_6109_() {
        return false;
    }

    @NotNull
    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        if (!player.f_19853_.m_5776_()) {
            SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this), this.m_142538_(), EventType.INTERACTION, this.getCitizenData());
        }
        return super.m_7111_(player, vec, hand);
    }

    public boolean m_21525_() {
        return false;
    }

    public void setTexture() {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).f_46443_) {
            return;
        }
        this.texture = IModelTypeRegistry.getInstance().getModelType(this.getModelType()).getTexture(this);
        this.textureDirty = false;
    }

    public abstract ICitizenDataView getCitizenDataView();

    @NotNull
    public ResourceLocation getTexture() {
        String renderMeta = this.getRenderMetadata();
        if (this.texture == null || this.textureDirty || !this.texture.m_135815_().contains(renderMeta) || !this.texture.m_135815_().contains((CharSequence)this.m_20088_().m_135370_(DATA_STYLE)) || !this.texture.m_135815_().contains((CharSequence)this.m_20088_().m_135370_(DATA_TEXTURE_SUFFIX))) {
            this.setTexture();
        }
        return this.texture;
    }

    public void setTextureDirty() {
        this.textureDirty = true;
    }

    public ResourceLocation getModelType() {
        return this.modelId;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob parent) {
        return null;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TEXTURE_SUFFIX, (Object)"_b");
        this.f_19804_.m_135372_(DATA_TEXTURE, (Object)0);
        this.f_19804_.m_135372_(DATA_LEVEL, (Object)0);
        this.f_19804_.m_135372_(DATA_STYLE, (Object)"default");
        this.f_19804_.m_135372_(DATA_IS_FEMALE, (Object)0);
        this.f_19804_.m_135372_(DATA_MODEL, (Object)ModModelTypes.SETTLER_ID.toString());
        this.f_19804_.m_135372_(DATA_RENDER_METADATA, (Object)"");
        this.f_19804_.m_135372_(DATA_IS_ASLEEP, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_CHILD, (Object)false);
        this.f_19804_.m_135372_(DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
        this.f_19804_.m_135372_(DATA_JOB, (Object)"");
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setFemale(boolean female) {
        this.female = female;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.pathNavigate == null) {
            this.pathNavigate = IPathNavigateRegistry.getInstance().getNavigateFor((Mob)this);
            this.f_21344_ = this.pathNavigate;
            this.pathNavigate.m_7008_(true);
            this.pathNavigate.setSwimSpeedFactor(2.0);
            this.pathNavigate.getPathingOptions().setEnterDoors(true);
            this.pathNavigate.getPathingOptions().setCanOpenDoors(true);
            this.pathNavigate.setStuckHandler(PathingStuckHandler.createStuckHandler().withTeleportOnFullStuck().withTeleportSteps(5));
        }
        return this.pathNavigate;
    }

    public void m_7334_(@NotNull Entity entityIn) {
        if ((this.collisionCounter += 2) > 50) {
            if (this.collisionCounter > 100) {
                this.collisionCounter = 0;
            }
            return;
        }
        if (this.f_19824_ instanceof MinecoloniesMinecart) {
            return;
        }
        super.m_7334_(entityIn);
    }

    public boolean m_6094_() {
        if (this.f_19824_ instanceof MinecoloniesMinecart) {
            return false;
        }
        return super.m_6094_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
    }

    protected void m_21186_() {
    }

    protected void m_21185_() {
    }

    public boolean m_6039_() {
        return false;
    }

    public void setOwnRotation(float yaw, float pitch) {
        this.m_19915_(yaw, pitch);
    }

    public void setModelId(ResourceLocation model) {
        this.modelId = model;
    }

    public void setRenderMetadata(String renderMetadata) {
        if (renderMetadata.equals(this.getRenderMetadata())) {
            return;
        }
        this.renderMetadata = renderMetadata;
        this.f_19804_.m_135381_(DATA_RENDER_METADATA, (Object)this.getRenderMetadata());
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void setTextureId(int textureId) {
        this.textureId = textureId;
        this.f_19804_.m_135381_(DATA_TEXTURE, (Object)textureId);
    }

    public String getRenderMetadata() {
        return this.renderMetadata;
    }

    public Random m_21187_() {
        return this.f_19796_;
    }

    public int getOffsetTicks() {
        return this.f_19797_ + 7 * this.m_142049_();
    }

    public boolean m_21254_() {
        return this.m_21211_().m_41720_() instanceof ShieldItem;
    }

    public int getRecentlyHit() {
        return this.f_20889_;
    }

    public boolean checkCanDropLoot() {
        return this.m_6149_();
    }

    public abstract ILocation getLocation();

    public abstract boolean isWorkerAtSiteWithMove(@NotNull BlockPos var1, int var2);

    public abstract ICitizenData getCitizenData();

    @NotNull
    public abstract InventoryCitizen getInventoryCitizen();

    @NotNull
    public abstract IItemHandler getItemHandlerCitizen();

    @NotNull
    public abstract DesiredActivity getDesiredActivity();

    public abstract void setCitizensize(@NotNull float var1, @NotNull float var2);

    public abstract void setIsChild(boolean var1);

    public abstract void playMoveAwaySound();

    public abstract IWalkToProxy getProxy();

    public abstract void decreaseSaturationForAction();

    public abstract void decreaseSaturationForContinuousAction();

    public abstract ICitizenExperienceHandler getCitizenExperienceHandler();

    public abstract ICitizenChatHandler getCitizenChatHandler();

    public abstract ICitizenStatusHandler getCitizenStatusHandler();

    public abstract ICitizenItemHandler getCitizenItemHandler();

    public abstract ICitizenInventoryHandler getCitizenInventoryHandler();

    public abstract void setCitizenInventoryHandler(ICitizenInventoryHandler var1);

    public abstract ICitizenColonyHandler getCitizenColonyHandler();

    public abstract void setCitizenColonyHandler(ICitizenColonyHandler var1);

    public abstract ICitizenJobHandler getCitizenJobHandler();

    public abstract ICitizenSleepHandler getCitizenSleepHandler();

    public abstract ICitizenDiseaseHandler getCitizenDiseaseHandler();

    public abstract void setCitizenDiseaseHandler(ICitizenDiseaseHandler var1);

    public abstract boolean isOkayToEat();

    public abstract boolean shouldBeFed();

    public abstract boolean isIdlingAtJob();

    public abstract float getRotationYaw();

    public abstract float getRotationPitch();

    public abstract boolean isDead();

    public abstract void setCitizenSleepHandler(ICitizenSleepHandler var1);

    public abstract void setCitizenJobHandler(ICitizenJobHandler var1);

    public abstract void setCitizenItemHandler(ICitizenItemHandler var1);

    public abstract void setCitizenChatHandler(ICitizenChatHandler var1);

    public abstract void setCitizenExperienceHandler(ICitizenExperienceHandler var1);

    public abstract boolean isCurrentlyFleeing();

    public abstract void callForHelp(Entity var1, int var2);

    public abstract void setFleeingState(boolean var1);

    public void updatePose(Pose pose) {
        this.m_20124_(pose);
    }

    public void m_21315_() {
        if (this.isEquipmentDirty) {
            this.isEquipmentDirty = false;
            ArrayList list = Lists.newArrayListWithCapacity((int)6);
            list.add(new Pair((Object)EquipmentSlot.CHEST, (Object)this.m_6844_(EquipmentSlot.CHEST)));
            list.add(new Pair((Object)EquipmentSlot.FEET, (Object)this.m_6844_(EquipmentSlot.FEET)));
            list.add(new Pair((Object)EquipmentSlot.HEAD, (Object)this.m_6844_(EquipmentSlot.HEAD)));
            list.add(new Pair((Object)EquipmentSlot.LEGS, (Object)this.m_6844_(EquipmentSlot.LEGS)));
            list.add(new Pair((Object)EquipmentSlot.OFFHAND, (Object)this.m_6844_(EquipmentSlot.OFFHAND)));
            list.add(new Pair((Object)EquipmentSlot.MAINHAND, (Object)this.m_6844_(EquipmentSlot.MAINHAND)));
            ((ServerLevel)this.f_19853_).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEquipmentPacket(this.m_142049_(), (List)list));
        }
    }

    public void m_8061_(EquipmentSlot slot, @NotNull ItemStack newItem) {
        ItemStack previous;
        if (!this.f_19853_.f_46443_ && !ItemStackUtils.compareItemStacksIgnoreStackSize(previous = this.m_6844_(slot), newItem, false, true)) {
            if (!previous.m_41619_()) {
                this.m_21204_().m_22161_(previous.m_41638_(slot));
            }
            if (!newItem.m_41619_()) {
                this.m_21204_().m_22178_(newItem.m_41638_(slot));
            }
            this.markEquipmentDirty();
        }
        super.m_8061_(slot, newItem);
    }

    public void markEquipmentDirty() {
        this.isEquipmentDirty = true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_20321_(boolean down) {
    }
}

