/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.apiimp.initializer;

import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.TagConstants;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ModTagsInitializer {
    private static final String REDUCEABLE = "reduceable";
    private static final String PRODUCT = "_product";
    private static final String PRODUCT_EXCLUDED = "_product_excluded";
    private static final String INGREDIENT = "_ingredient";
    private static final String INGREDIENT_EXCLUDED = "_ingredient_excluded";
    private static TagContainer supplier;

    public static void init(TagContainer tagSupplier) {
        supplier = tagSupplier;
        ModTags.decorationItems = ModTagsInitializer.getBlockTags(TagConstants.DECORATION_ITEMS);
        ModTags.concretePowder = ModTagsInitializer.getItemTags(TagConstants.CONCRETE_POWDER);
        ModTags.concreteBlock = ModTagsInitializer.getBlockTags(TagConstants.CONCRETE_BLOCK);
        ModTags.pathingBlocks = ModTagsInitializer.getBlockTags(TagConstants.PATHING_BLOCKS);
        ModTags.floristFlowers = ModTagsInitializer.getItemTags(TagConstants.FLORIST_FLOWERS);
        ModTags.excludedFood = ModTagsInitializer.getItemTags(TagConstants.EXCLUDED_FOOD);
        ModTags.fungi = ModTagsInitializer.getItemTags(TagConstants.FUNGI);
        ModTags.meshes = ModTagsInitializer.getItemTags(TagConstants.MESHES);
        ModTags.breakable_ore = ModTagsInitializer.getItemTags(TagConstants.BREAKABLE_ORE);
        ModTags.raw_ore = ModTagsInitializer.getItemTags(TagConstants.RAW_ORE);
        ModTags.oreChanceBlocks = ModTagsInitializer.getBlockTags(TagConstants.ORECHANCEBLOCKS);
        ModTags.colonyProtectionException = ModTagsInitializer.getBlockTags(TagConstants.COLONYPROTECTIONEXCEPTION);
        ModTags.indestructible = ModTagsInitializer.getBlockTags(TagConstants.INDESTRUCTIBLE);
        ModTags.hostile = ModTagsInitializer.getEntityTags(TagConstants.HOSTILE);
        ModTagsInitializer.initCrafterRules("baker");
        ModTagsInitializer.initCrafterRules("blacksmith");
        ModTagsInitializer.initCrafterRules("chickenherder");
        ModTagsInitializer.initCrafterRules("concretemixer");
        ModTagsInitializer.initCrafterRules("cook");
        ModTagsInitializer.initCrafterRules("cowboy");
        ModTagsInitializer.initCrafterRules("crusher");
        ModTagsInitializer.initCrafterRules("dyer");
        ModTagsInitializer.initCrafterRules("farmer");
        ModTagsInitializer.initCrafterRules("fisherman");
        ModTagsInitializer.initCrafterRules("fletcher");
        ModTagsInitializer.initCrafterRules("glassblower");
        ModTagsInitializer.initCrafterRules("glassblower_smelting");
        ModTagsInitializer.initCrafterRules("dyer_smelting");
        ModTagsInitializer.initCrafterRules("lumberjack");
        ModTagsInitializer.initCrafterRules("mechanic");
        ModTagsInitializer.initCrafterRules("plantation");
        ModTagsInitializer.initCrafterRules("rabbithutch");
        ModTagsInitializer.initCrafterRules("sawmill");
        ModTagsInitializer.initCrafterRules("shepherd");
        ModTagsInitializer.initCrafterRules("smelter");
        ModTagsInitializer.initCrafterRules("stonemason");
        ModTagsInitializer.initCrafterRules("stonesmeltery");
        ModTagsInitializer.initCrafterRules("swineherder");
        ModTagsInitializer.initCrafterRules(REDUCEABLE);
        Log.getLogger().info("Tags Loaded");
    }

    private static void initCrafterRules(String crafterName) {
        String lowerName = crafterName.toLowerCase();
        ResourceLocation products = new ResourceLocation("minecolonies", lowerName.concat(PRODUCT));
        ResourceLocation ingredients = new ResourceLocation("minecolonies", lowerName.concat(INGREDIENT));
        ResourceLocation productsExcluded = new ResourceLocation("minecolonies", lowerName.concat(PRODUCT_EXCLUDED));
        ResourceLocation ingredientsExcluded = new ResourceLocation("minecolonies", lowerName.concat(INGREDIENT_EXCLUDED));
        ModTags.crafterProduct.put(lowerName, ModTagsInitializer.getItemTags(products));
        ModTags.crafterProductExclusions.put(lowerName, ModTagsInitializer.getItemTags(productsExcluded));
        ModTags.crafterIngredient.put(lowerName, ModTagsInitializer.getItemTags(ingredients));
        ModTags.crafterIngredientExclusions.put(lowerName, ModTagsInitializer.getItemTags(ingredientsExcluded));
    }

    private static Tag<Item> getItemTags(ResourceLocation resourceLocation) {
        return ItemTags.m_13193_().m_7689_(resourceLocation);
    }

    private static Tag<Block> getBlockTags(ResourceLocation resourceLocation) {
        return BlockTags.m_13115_().m_7689_(resourceLocation);
    }

    private static Tag<EntityType<?>> getEntityTags(ResourceLocation resourceLocation) {
        return EntityTypeTags.m_13126_().m_7689_(resourceLocation);
    }
}

